/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.deserialization;

import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import kotlin.Triple;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.NameResolver;
import org.jetbrains.kotlin.serialization.deserialization.NameResolverImpl$WhenMappings;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"M\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0005\u0005\u000b\u0001)\u0011\u0001D\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\u000f\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001\u0003\t\u0006\u0003!-Q!\u0001\u0003\u0002\u0019\u0001\u0001B\"G\u0001\u0019\u0002u\u0005A\"i\u0006\u0005\u0003%\u0019\u0001\"A\u0007\u00021\u0007I1\u0001\u0003\u0002\u000e\u0003a\u0015\u0011kA\u0001\t\u0007\u0015BAa\u0003E\u0004\u001b\u0005AB!G\u0002\t\n5\t\u0001$BS\u000b\t-AY!d\u0002\u0019\rE\u001b\u0011\u0001\"\u0004\u001a\u0007!%Q\"\u0001\r\u0006K\u001dAq!D\u0001\u0019\u0010e\u0019\u0001\u0012B\u0007\u00021\u0015)C\u0002B\u0006\t\u00115)\u0001#C\u000b\u0003\u0019\u0003A\n\u0002'\u0005\u001a\u0007!%Q\"\u0001\r\u0006K]!\u0011\u0001c\u0005\u000e!%)\u0011\u0002B\u0005\u0003\u0013\u0005A\n\u0002'\u0006\n\u000b%!\u0011BA\u0005\u00021#A*\"\u0003\u0002\n\u0003aY\u0001DC\r\u0004\u0011/i\u0011\u0001G\u0003*\u000f\u0011\t\u0005\u0002\u0003\u0002\u000e\u0003a\u0015\u0011kA\u0001\u0006\u0001%:A!\u0011\u0005\t\u00035\t\u00014A)\u0004\u0003\u0015\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/serialization/deserialization/NameResolverImpl;", "Lorg/jetbrains/kotlin/serialization/deserialization/NameResolver;", "strings", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$StringTable;", "qualifiedNames", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$QualifiedNameTable;", "(Lorg/jetbrains/kotlin/serialization/ProtoBuf$StringTable;Lorg/jetbrains/kotlin/serialization/ProtoBuf$QualifiedNameTable;)V", "getClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "index", "", "getName", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/annotations/NotNull;", "getPackageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "getString", "", "kotlin.jvm.PlatformType", "traverseIds", "Lkotlin/Triple;", "", "", "startingIndex", "Companion"}, moduleName="deserialization")
public final class NameResolverImpl
implements NameResolver {
    private final ProtoBuf.StringTable strings;
    private final ProtoBuf.QualifiedNameTable qualifiedNames;
    public static final Companion Companion = org.jetbrains.kotlin.serialization.deserialization.NameResolverImpl$Companion.INSTANCE;

    @Override
    public String getString(int index) {
        return this.strings.getString(index);
    }

    @Override
    @NotNull
    public Name getName(int index) {
        return Name.guess((String)this.strings.getString(index));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ClassId getClassId(int index) {
        void isLocal;
        void relativeClassNameSegments;
        void packageFqNameSegments;
        Triple<List<String>, List<String>, Boolean> triple = this.traverseIds(index);
        List list = (List)triple.component1();
        List list2 = (List)triple.component2();
        boolean bl = (Boolean)triple.component3();
        triple = null;
        return new ClassId(FqName.fromSegments((List)packageFqNameSegments), FqName.fromSegments((List)relativeClassNameSegments), (boolean)isLocal);
    }

    @NotNull
    public final FqName getPackageFqName(int index) {
        List packageNameSegments = (List)this.traverseIds(index).getFirst();
        FqName fqName = FqName.fromSegments((List)packageNameSegments);
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName, (String)"FqName.fromSegments(packageNameSegments)");
        return fqName;
    }

    private final Triple<List<String>, List<String>, Boolean> traverseIds(int startingIndex) {
        int index = startingIndex;
        LinkedList<String> packageNameSegments = new LinkedList<String>();
        LinkedList<String> relativeClassNameSegments = new LinkedList<String>();
        boolean local = false;
        while (index != -1) {
            ProtoBuf.QualifiedNameTable.QualifiedName proto = this.qualifiedNames.getQualifiedName(index);
            String shortName = this.strings.getString(proto.getShortName());
            ProtoBuf.QualifiedNameTable.QualifiedName.Kind kind = proto.getKind();
            if (kind == null) {
                Intrinsics.throwNpe();
            }
            switch (NameResolverImpl$WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
                case 1: {
                    relativeClassNameSegments.addFirst(shortName);
                    break;
                }
                case 2: {
                    packageNameSegments.addFirst(shortName);
                    break;
                }
                case 3: {
                    relativeClassNameSegments.addFirst(shortName);
                    local = true;
                }
            }
            index = proto.getParentQualifiedName();
        }
        return new Triple(packageNameSegments, relativeClassNameSegments, (Object)local);
    }

    private NameResolverImpl(ProtoBuf.StringTable strings, ProtoBuf.QualifiedNameTable qualifiedNames) {
        this.strings = strings;
        this.qualifiedNames = qualifiedNames;
    }

    public /* synthetic */ NameResolverImpl(@NotNull ProtoBuf.StringTable strings, @NotNull ProtoBuf.QualifiedNameTable qualifiedNames, DefaultConstructorMarker $constructor_marker) {
        this(strings, qualifiedNames);
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"\u0017\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005!19\u0001\u0007\u00013\u0005A\n!i\u0002\u0005\u0003E\u001b\u0011\u0001C\u0001&\u000f!\rQ\"\u0001\r\u00033\rA)!D\u0001\u0019\u0007\u0001"}, strings={"Lorg/jetbrains/kotlin/serialization/deserialization/NameResolverImpl$Companion;", "", "()V", "read", "Lorg/jetbrains/kotlin/serialization/deserialization/NameResolverImpl;", "stream", "Ljava/io/InputStream;"}, moduleName="deserialization")
    public static final class Companion {
        public static final Companion INSTANCE;

        @NotNull
        public final NameResolverImpl read(@NotNull InputStream stream) {
            Intrinsics.checkParameterIsNotNull((Object)stream, (String)"stream");
            ProtoBuf.StringTable simpleNames = ProtoBuf.StringTable.parseDelimitedFrom(stream);
            ProtoBuf.QualifiedNameTable qualifiedNames = ProtoBuf.QualifiedNameTable.parseDelimitedFrom(stream);
            ProtoBuf.StringTable stringTable = simpleNames;
            Intrinsics.checkExpressionValueIsNotNull((Object)stringTable, (String)"simpleNames");
            ProtoBuf.QualifiedNameTable qualifiedNameTable = qualifiedNames;
            Intrinsics.checkExpressionValueIsNotNull((Object)qualifiedNameTable, (String)"qualifiedNames");
            return new NameResolverImpl(stringTable, qualifiedNameTable, null);
        }

        private Companion() {
            INSTANCE = this;
        }

        static {
            new Companion();
        }
    }
}

