/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.impl.references;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import java.util.List;
import org.intellij.lang.xpath.psi.impl.ResolveUtil;
import org.intellij.lang.xpath.xslt.impl.XsltIncludeIndex;
import org.intellij.lang.xpath.xslt.impl.references.AttributeReference;
import org.intellij.lang.xpath.xslt.quickfix.CreateTemplateFix;
import org.intellij.lang.xpath.xslt.util.NamedTemplateMatcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TemplateReference
extends AttributeReference
implements EmptyResolveMessageProvider,
LocalQuickFixProvider,
PsiPolyVariantReference {
    private final String myName;

    public TemplateReference(XmlAttribute attribute) {
        super(attribute, TemplateReference.createMatcher(attribute), false);
        this.myName = attribute.getValue();
    }

    private static ResolveUtil.Matcher createMatcher(XmlAttribute attribute) {
        return new NamedTemplateMatcher((XmlDocument)PsiTreeUtil.getParentOfType((PsiElement)attribute, XmlDocument.class), attribute.getValue());
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        PsiElement element = this.resolve();
        if (element != null) {
            ResolveResult[] resolveResultArray = new ResolveResult[]{new PsiElementResolveResult(element)};
            if (resolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/impl/references/TemplateReference", "multiResolve"));
            }
            return resolveResultArray;
        }
        XmlFile xmlFile = (XmlFile)this.getElement().getContainingFile();
        if (xmlFile != null) {
            SmartList targets = new SmartList();
            XsltIncludeIndex.processBackwardDependencies(xmlFile, new Processor<XmlFile>((List)targets){
                final /* synthetic */ List val$targets;
                {
                    this.val$targets = list;
                }

                public boolean process(XmlFile xmlFile) {
                    PsiElement e = ResolveUtil.resolve(new NamedTemplateMatcher(xmlFile.getDocument(), TemplateReference.this.myName));
                    if (e != null) {
                        this.val$targets.add(new PsiElementResolveResult(e));
                    }
                    return true;
                }
            });
            ResolveResult[] resolveResultArray = targets.toArray(new ResolveResult[targets.size()]);
            if (resolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/impl/references/TemplateReference", "multiResolve"));
            }
            return resolveResultArray;
        }
        if (ResolveResult.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/impl/references/TemplateReference", "multiResolve"));
        }
        return ResolveResult.EMPTY_ARRAY;
    }

    @Nullable
    public LocalQuickFix[] getQuickFixes() {
        return new LocalQuickFix[]{new CreateTemplateFix(this.myAttribute.getParent(), this.myName)};
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        if ("Cannot resolve template ''{0}''" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/impl/references/TemplateReference", "getUnresolvedMessagePattern"));
        }
        return "Cannot resolve template ''{0}''";
    }
}

