/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.tools.idea.editors.theme.attributes.AttributesTableModel;
import com.intellij.openapi.ui.JBPopupMenu;
import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.RowSorter;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import spantable.CellSpanModel;
import spantable.CellSpanTable;

public class ThemeEditorTable
extends CellSpanTable {
    private final JBPopupMenu myPopupMenu = new JBPopupMenu();
    private ActionListener myLastDefinitionActionListener = null;
    private ActionListener myLastResetActionListener;
    private final JMenuItem myGoToDefinitionItem = this.myPopupMenu.add(new JMenuItem("Go to definition"));
    private final JMenuItem myResetItem;
    private Map<Class<?>, Integer> myClassHeights;

    public ThemeEditorTable() {
        this.myGoToDefinitionItem.setVisible(false);
        this.myResetItem = this.myPopupMenu.add(new JMenuItem("Reset value"));
        this.myResetItem.setVisible(false);
    }

    public JPopupMenu getComponentPopupMenu() {
        Point point = MouseInfo.getPointerInfo().getLocation();
        SwingUtilities.convertPointFromScreen(point, (Component)((Object)this));
        return this.getPopupMenuAtCell(this.rowAtPoint(point), this.columnAtPoint(point));
    }

    public void setRowSorter(RowSorter<? extends TableModel> sorter) {
        super.setRowSorter(sorter);
        this.updateRowHeights();
    }

    public void updateRowHeights() {
        TableModel rawModel = this.getModel();
        if (!(rawModel instanceof CellSpanModel)) {
            return;
        }
        CellSpanModel myModel = (CellSpanModel)rawModel;
        this.setRowHeight(this.myClassHeights.get(Object.class));
        for (int row = 0; row < myModel.getRowCount(); ++row) {
            int viewRow;
            Class cellClass = myModel.getCellClass(row, 0);
            Integer rowHeight = this.myClassHeights.get(cellClass);
            if (rowHeight == null || (viewRow = this.convertRowIndexToView(row)) == -1) continue;
            this.setRowHeight(viewRow, rowHeight);
        }
    }

    public void setClassHeights(Map<Class<?>, Integer> classHeights) {
        this.myClassHeights = classHeights;
        this.updateRowHeights();
    }

    private JPopupMenu getPopupMenuAtCell(int row, int column) {
        this.myGoToDefinitionItem.setVisible(false);
        this.myResetItem.setVisible(false);
        TableModel model = this.getModel();
        if (!(model instanceof AttributesTableModel)) {
            return null;
        }
        AttributesTableModel.RowContents contents = ((AttributesTableModel)model).getRowContents(this.convertRowIndexToModel(row));
        if (contents == null) {
            return null;
        }
        ActionListener definitionCallback = contents.getGoToDefinitionCallback();
        ActionListener resetCallback = contents.getResetCallback();
        if (definitionCallback == null && resetCallback == null) {
            return null;
        }
        if (definitionCallback != null) {
            this.myGoToDefinitionItem.setVisible(true);
            this.setDefinitionActionListener(definitionCallback);
        }
        if (resetCallback != null) {
            this.myResetItem.setVisible(true);
            this.setResetActionListener(resetCallback);
        }
        return this.myPopupMenu;
    }

    private void setDefinitionActionListener(ActionListener callback) {
        if (this.myLastDefinitionActionListener != null) {
            this.myGoToDefinitionItem.removeActionListener(this.myLastDefinitionActionListener);
        }
        this.myGoToDefinitionItem.addActionListener(callback);
        this.myLastDefinitionActionListener = callback;
    }

    private void setResetActionListener(ActionListener callback) {
        if (this.myLastResetActionListener != null) {
            this.myResetItem.removeActionListener(this.myLastResetActionListener);
        }
        this.myResetItem.addActionListener(callback);
        this.myLastResetActionListener = callback;
    }
}

