/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.attributes.editors;

import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.attributes.editors.AttributeEditorValue;
import com.android.tools.idea.editors.theme.attributes.editors.TypedCellEditor;
import com.android.tools.idea.editors.theme.datamodels.EditedStyleItem;
import com.intellij.openapi.project.Project;
import com.intellij.ui.TextFieldWithAutoCompletion;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AttributeReferenceRendererEditor
extends TypedCellEditor<EditedStyleItem, AttributeEditorValue>
implements TableCellRenderer {
    protected final Box myBox = new Box(2);
    protected final JLabel myLabel = new JLabel();
    protected final TextFieldWithAutoCompletion<String> myTextField;
    protected final CompletionProvider myCompletionProvider;
    protected EditedStyleItem myEditValue;
    protected String myStringValue;

    public AttributeReferenceRendererEditor(@Nullable Project project, @Nullable CompletionProvider completionProvider) {
        this.myCompletionProvider = project != null ? completionProvider : null;
        this.myTextField = new TextFieldWithAutoCompletion<String>(project, TextFieldWithAutoCompletion.EMPTY_COMPLETION, true, null){

            protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                if (e.getKeyCode() == 10) {
                    AttributeReferenceRendererEditor.this.stopCellEditing();
                    return true;
                }
                return false;
            }
        };
        this.myBox.add((Component)this.myTextField);
        this.myBox.add(Box.createHorizontalGlue());
        this.myTextField.setAlignmentX(0.0f);
        this.myTextField.setOneLineMode(true);
        this.myLabel.setOpaque(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component component;
        if (!(value instanceof EditedStyleItem)) {
            return null;
        }
        EditedStyleItem item = (EditedStyleItem)value;
        if (column == 0) {
            component = table.getDefaultRenderer(String.class).getTableCellRendererComponent(table, ThemeEditorUtils.getDisplayHtml(item), isSelected, hasFocus, row, column);
        } else {
            this.myLabel.setFont(table.getFont());
            this.myLabel.setText(item.getValue());
            this.myLabel.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
            component = this.myLabel;
        }
        return component;
    }

    @Override
    public Component getEditorComponent(JTable table, EditedStyleItem value, boolean isSelected, int row, int column) {
        this.myEditValue = value;
        this.myStringValue = value.getValue();
        this.myTextField.setText(this.myStringValue);
        this.myTextField.setFont(table.getFont());
        if (this.myCompletionProvider != null) {
            this.myTextField.setVariants(this.myCompletionProvider.getCompletions(value));
        }
        this.myBox.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
        return this.myBox;
    }

    @Override
    public AttributeEditorValue getEditorValue() {
        return new AttributeEditorValue(this.myTextField.getText(), false);
    }

    public static interface CompletionProvider {
        @NotNull
        public List<String> getCompletions(@NotNull EditedStyleItem var1);
    }
}

