/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.model.java;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.idea.IdeaContentRoot;
import org.gradle.tooling.model.idea.IdeaSourceDirectory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ExtIdeaContentRoot;

public class JavaModuleContentRoot
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final File myRootDirPath;
    @NotNull
    private final Collection<File> mySourceDirPaths;
    @NotNull
    private final Collection<File> myGenSourceDirPaths;
    @NotNull
    private final Collection<File> myResourceDirPaths;
    @NotNull
    private final Collection<File> myTestDirPaths;
    @NotNull
    private final Collection<File> myGenTestDirPaths;
    @NotNull
    private final Collection<File> myTestResourceDirPaths;
    @NotNull
    private final Collection<File> myExcludeDirPaths;

    @NotNull
    public static JavaModuleContentRoot copy(@NotNull IdeaContentRoot original) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/android/tools/idea/gradle/model/java/JavaModuleContentRoot", "copy"));
        }
        File rootDirPath = original.getRootDirectory();
        Collection<File> sourceDirPaths = JavaModuleContentRoot.copy((DomainObjectSet<? extends IdeaSourceDirectory>)original.getSourceDirectories());
        Collection<File> genSourceDirPaths = JavaModuleContentRoot.copy((DomainObjectSet<? extends IdeaSourceDirectory>)original.getGeneratedSourceDirectories());
        Collection<File> testDirPaths = JavaModuleContentRoot.copy((DomainObjectSet<? extends IdeaSourceDirectory>)original.getTestDirectories());
        Collection<File> genTestDirPaths = JavaModuleContentRoot.copy((DomainObjectSet<? extends IdeaSourceDirectory>)original.getGeneratedTestDirectories());
        Set<File> resourceDirPaths = Collections.emptySet();
        Set<File> testResourceDirPaths = Collections.emptySet();
        if (original instanceof ExtIdeaContentRoot) {
            ExtIdeaContentRoot extContentRoot = (ExtIdeaContentRoot)original;
            resourceDirPaths = JavaModuleContentRoot.copy((DomainObjectSet<? extends IdeaSourceDirectory>)extContentRoot.getResourceDirectories());
            testResourceDirPaths = JavaModuleContentRoot.copy((DomainObjectSet<? extends IdeaSourceDirectory>)extContentRoot.getTestResourceDirectories());
        }
        HashSet excludeDirPaths = Collections.emptySet();
        Set exclude = original.getExcludeDirectories();
        if (exclude != null) {
            excludeDirPaths = Sets.newHashSet();
            for (File path : exclude) {
                if (path == null) continue;
                excludeDirPaths.add(path);
            }
        }
        JavaModuleContentRoot javaModuleContentRoot = new JavaModuleContentRoot(rootDirPath, sourceDirPaths, genSourceDirPaths, resourceDirPaths, testDirPaths, genTestDirPaths, testResourceDirPaths, excludeDirPaths);
        if (javaModuleContentRoot == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/model/java/JavaModuleContentRoot", "copy"));
        }
        return javaModuleContentRoot;
    }

    @NotNull
    private static Collection<File> copy(@Nullable DomainObjectSet<? extends IdeaSourceDirectory> directories) {
        if (directories == null) {
            Set<File> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/model/java/JavaModuleContentRoot", "copy"));
            }
            return set;
        }
        HashSet paths = Sets.newHashSet();
        for (IdeaSourceDirectory directory : directories) {
            paths.add(directory.getDirectory());
        }
        HashSet hashSet = paths;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/model/java/JavaModuleContentRoot", "copy"));
        }
        return hashSet;
    }

    public JavaModuleContentRoot(@NotNull File rootDirPath, @NotNull Collection<File> sourceDirPaths, @NotNull Collection<File> genSourceDirPaths, @NotNull Collection<File> resourceDirPaths, @NotNull Collection<File> testDirPaths, @NotNull Collection<File> genTestDirPaths, @NotNull Collection<File> testResourceDirPaths, @NotNull Collection<File> excludeDirPaths) {
        if (rootDirPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootDirPath", "com/android/tools/idea/gradle/model/java/JavaModuleContentRoot", "<init>"));
        }
        if (sourceDirPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceDirPaths", "com/android/tools/idea/gradle/model/java/JavaModuleContentRoot", "<init>"));
        }
        if (genSourceDirPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "genSourceDirPaths", "com/android/tools/idea/gradle/model/java/JavaModuleContentRoot", "<init>"));
        }
        if (resourceDirPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceDirPaths", "com/android/tools/idea/gradle/model/java/JavaModuleContentRoot", "<init>"));
        }
        if (testDirPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testDirPaths", "com/android/tools/idea/gradle/model/java/JavaModuleContentRoot", "<init>"));
        }
        if (genTestDirPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "genTestDirPaths", "com/android/tools/idea/gradle/model/java/JavaModuleContentRoot", "<init>"));
        }
        if (testResourceDirPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testResourceDirPaths", "com/android/tools/idea/gradle/model/java/JavaModuleContentRoot", "<init>"));
        }
        if (excludeDirPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "excludeDirPaths", "com/android/tools/idea/gradle/model/java/JavaModuleContentRoot", "<init>"));
        }
        this.myRootDirPath = rootDirPath;
        this.mySourceDirPaths = sourceDirPaths;
        this.myGenSourceDirPaths = genSourceDirPaths;
        this.myResourceDirPaths = resourceDirPaths;
        this.myTestDirPaths = testDirPaths;
        this.myGenTestDirPaths = genTestDirPaths;
        this.myTestResourceDirPaths = testResourceDirPaths;
        this.myExcludeDirPaths = excludeDirPaths;
    }

    @NotNull
    public File getRootDirPath() {
        File file = this.myRootDirPath;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/model/java/JavaModuleContentRoot", "getRootDirPath"));
        }
        return file;
    }

    @NotNull
    public Collection<File> getSourceDirPaths() {
        Collection<File> collection = this.mySourceDirPaths;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/model/java/JavaModuleContentRoot", "getSourceDirPaths"));
        }
        return collection;
    }

    @NotNull
    public Collection<File> getGenSourceDirPaths() {
        Collection<File> collection = this.myGenSourceDirPaths;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/model/java/JavaModuleContentRoot", "getGenSourceDirPaths"));
        }
        return collection;
    }

    @NotNull
    public Collection<File> getResourceDirPaths() {
        Collection<File> collection = this.myResourceDirPaths;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/model/java/JavaModuleContentRoot", "getResourceDirPaths"));
        }
        return collection;
    }

    @NotNull
    public Collection<File> getTestDirPaths() {
        Collection<File> collection = this.myTestDirPaths;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/model/java/JavaModuleContentRoot", "getTestDirPaths"));
        }
        return collection;
    }

    @NotNull
    public Collection<File> getGenTestDirPaths() {
        Collection<File> collection = this.myGenTestDirPaths;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/model/java/JavaModuleContentRoot", "getGenTestDirPaths"));
        }
        return collection;
    }

    @NotNull
    public Collection<File> getTestResourceDirPaths() {
        Collection<File> collection = this.myTestResourceDirPaths;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/model/java/JavaModuleContentRoot", "getTestResourceDirPaths"));
        }
        return collection;
    }

    @NotNull
    public Collection<File> getExcludeDirPaths() {
        Collection<File> collection = this.myExcludeDirPaths;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/model/java/JavaModuleContentRoot", "getExcludeDirPaths"));
        }
        return collection;
    }
}

