/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.parser;

import com.android.tools.idea.gradle.parser.BuildFileKey;
import com.android.tools.idea.gradle.parser.GradleBuildFile;
import com.android.tools.idea.gradle.parser.GradleGroovyFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiElement;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;

public enum BuildFileKeyType {
    STRING((Class)String.class, "''"){

        @Override
        public void setValue(@NotNull GroovyPsiElement arg, @NotNull Object value) {
            if (arg == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg", "com/android/tools/idea/gradle/parser/BuildFileKeyType$1", "setValue"));
            }
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/gradle/parser/BuildFileKeyType$1", "setValue"));
            }
            arg.replace((PsiElement)GroovyPsiElementFactory.getInstance((Project)arg.getProject()).createLiteralFromValue((Object)value.toString()));
        }

        @Override
        @NotNull
        public String convertValueToExpression(@NotNull Object value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/gradle/parser/BuildFileKeyType$1", "convertValueToExpression"));
            }
            String string = "'" + BuildFileKey.escapeLiteralString(value.toString()) + "'";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/parser/BuildFileKeyType$1", "convertValueToExpression"));
            }
            return string;
        }
    }
    ,
    INTEGER(Integer.class, "0"),
    INTEGER_OR_STRING((Class)String.class, "0"){

        @Override
        public void setValue(@NotNull GroovyPsiElement arg, @NotNull Object value) {
            if (arg == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg", "com/android/tools/idea/gradle/parser/BuildFileKeyType$2", "setValue"));
            }
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/gradle/parser/BuildFileKeyType$2", "setValue"));
            }
            String valueString = value.toString();
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)arg.getProject());
            if (BuildFileKeyType.isInteger(valueString)) {
                arg.replace((PsiElement)factory.createExpressionFromText((CharSequence)valueString));
            } else {
                arg.replace((PsiElement)factory.createLiteralFromValue(value));
            }
        }

        @Override
        @NotNull
        public String convertValueToExpression(@NotNull Object value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/gradle/parser/BuildFileKeyType$2", "convertValueToExpression"));
            }
            String valueString = value.toString();
            if (BuildFileKeyType.isInteger(valueString)) {
                String string = valueString;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/parser/BuildFileKeyType$2", "convertValueToExpression"));
                }
                return string;
            }
            String string = "'" + BuildFileKey.escapeLiteralString(value.toString()) + "'";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/parser/BuildFileKeyType$2", "convertValueToExpression"));
            }
            return string;
        }

        @Override
        @Nullable
        public Object getValue(@NotNull GroovyPsiElement arg) {
            if (arg == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg", "com/android/tools/idea/gradle/parser/BuildFileKeyType$2", "getValue"));
            }
            if (!(arg instanceof GrLiteral)) {
                return GradleBuildFile.UNRECOGNIZED_VALUE;
            }
            Object value = ((GrLiteral)arg).getValue();
            return value != null ? value.toString() : null;
        }
    }
    ,
    BOOLEAN(Boolean.class, "false"),
    CLOSURE((Class)List.class, "{}"){

        @Override
        @NotNull
        public String convertValueToExpression(@NotNull Object value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/gradle/parser/BuildFileKeyType$3", "convertValueToExpression"));
            }
            if ("{\n}" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/parser/BuildFileKeyType$3", "convertValueToExpression"));
            }
            return "{\n}";
        }
    }
    ,
    FILE((Class)File.class, "file('')"){

        @Override
        @Nullable
        public Object getValue(@NotNull GroovyPsiElement arg) {
            if (arg == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg", "com/android/tools/idea/gradle/parser/BuildFileKeyType$4", "getValue"));
            }
            if (!(arg instanceof GrMethodCall)) {
                return GradleBuildFile.UNRECOGNIZED_VALUE;
            }
            GrMethodCall call = (GrMethodCall)arg;
            if (!"file".equals(GradleGroovyFile.getMethodCallName(call))) {
                return GradleBuildFile.UNRECOGNIZED_VALUE;
            }
            Object path = GradleGroovyFile.getFirstLiteralArgumentValue(call);
            if (path == null) {
                return GradleBuildFile.UNRECOGNIZED_VALUE;
            }
            return new File(path.toString());
        }

        @Override
        public void setValue(@NotNull GroovyPsiElement arg, @NotNull Object value) {
            if (arg == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg", "com/android/tools/idea/gradle/parser/BuildFileKeyType$4", "setValue"));
            }
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/gradle/parser/BuildFileKeyType$4", "setValue"));
            }
            arg.replace((PsiElement)GroovyPsiElementFactory.getInstance((Project)arg.getProject()).createStatementFromText((CharSequence)("file('" + BuildFileKeyType.getFilePath(value, true) + "')")));
        }

        @Override
        @NotNull
        public String convertValueToExpression(@NotNull Object value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/gradle/parser/BuildFileKeyType$4", "convertValueToExpression"));
            }
            String string = "file('" + BuildFileKeyType.getFilePath(value, true) + "')";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/parser/BuildFileKeyType$4", "convertValueToExpression"));
            }
            return string;
        }
    }
    ,
    FILE_AS_STRING((Class)File.class, "''"){

        @Override
        @Nullable
        public Object getValue(@NotNull GroovyPsiElement arg) {
            if (arg == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg", "com/android/tools/idea/gradle/parser/BuildFileKeyType$5", "getValue"));
            }
            if (!(arg instanceof GrLiteral)) {
                return GradleBuildFile.UNRECOGNIZED_VALUE;
            }
            Object value = ((GrLiteral)arg).getValue();
            return value != null ? new File(value.toString()) : null;
        }

        @Override
        public void setValue(@NotNull GroovyPsiElement arg, @NotNull Object value) {
            if (arg == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg", "com/android/tools/idea/gradle/parser/BuildFileKeyType$5", "setValue"));
            }
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/gradle/parser/BuildFileKeyType$5", "setValue"));
            }
            arg.replace((PsiElement)GroovyPsiElementFactory.getInstance((Project)arg.getProject()).createLiteralFromValue((Object)BuildFileKeyType.getFilePath(value, false)));
        }

        @Override
        @NotNull
        public String convertValueToExpression(@NotNull Object value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/gradle/parser/BuildFileKeyType$5", "convertValueToExpression"));
            }
            String string = "'" + BuildFileKeyType.getFilePath(value, true) + "'";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/parser/BuildFileKeyType$5", "convertValueToExpression"));
            }
            return string;
        }
    }
    ,
    REFERENCE((Class)String.class, "reference"){

        @Override
        @Nullable
        public Object getValue(@NotNull GroovyPsiElement arg) {
            if (arg == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg", "com/android/tools/idea/gradle/parser/BuildFileKeyType$6", "getValue"));
            }
            return arg.getText();
        }
    };

    private final Class<?> myNativeType;
    private final String myDefaultValue;

    private BuildFileKeyType(Class<?> nativeType, String defaultValue) {
        if (nativeType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nativeType", "com/android/tools/idea/gradle/parser/BuildFileKeyType", "<init>"));
        }
        if (defaultValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultValue", "com/android/tools/idea/gradle/parser/BuildFileKeyType", "<init>"));
        }
        this.myNativeType = nativeType;
        this.myDefaultValue = defaultValue;
    }

    @NotNull
    public Class<?> getNativeType() {
        Class<?> clazz = this.myNativeType;
        if (clazz == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/parser/BuildFileKeyType", "getNativeType"));
        }
        return clazz;
    }

    @NotNull
    public String convertValueToExpression(@NotNull Object value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/gradle/parser/BuildFileKeyType", "convertValueToExpression"));
        }
        String string = value.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/parser/BuildFileKeyType", "convertValueToExpression"));
        }
        return string;
    }

    private static String getFilePath(Object value, boolean escape) {
        String path = FileUtil.toSystemIndependentName((String)((File)value).getPath());
        return escape ? BuildFileKey.escapeLiteralString(path) : path;
    }

    @Nullable
    public Object getValue(@NotNull GroovyPsiElement arg) {
        if (arg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg", "com/android/tools/idea/gradle/parser/BuildFileKeyType", "getValue"));
        }
        if (!(arg instanceof GrLiteral)) {
            return GradleBuildFile.UNRECOGNIZED_VALUE;
        }
        return ((GrLiteral)arg).getValue();
    }

    public void setValue(@NotNull GroovyPsiElement arg, @NotNull Object value) {
        if (arg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg", "com/android/tools/idea/gradle/parser/BuildFileKeyType", "setValue"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/gradle/parser/BuildFileKeyType", "setValue"));
        }
        arg.replace((PsiElement)GroovyPsiElementFactory.getInstance((Project)arg.getProject()).createExpressionFromText((CharSequence)value.toString()));
    }

    private static boolean isInteger(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/android/tools/idea/gradle/parser/BuildFileKeyType", "isInteger"));
        }
        try {
            Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static class Constants {
        private static final String FILE_METHOD_CALL = "file";

        private Constants() {
        }
    }
}

