/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.compatibility;

import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.PreciseRevision;
import com.google.common.base.Splitter;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class VersionRange {
    @NonNls
    private static final char OR_GREATER = '+';
    @NonNls
    private static final char START_INCLUSIVE = '[';
    @NonNls
    private static final char START_EXCLUSIVE = '(';
    @NonNls
    private static final char END_INCLUSIVE = ']';
    @NonNls
    private static final char END_EXCLUSIVE = ')';
    @NotNull
    private final String myMinVersion;
    @Nullable
    private final FullRevision myMinRevision;
    private final boolean myMinVersionInclusive;
    @Nullable
    private final FullRevision myMaxRevision;
    @Nullable
    private final String myMaxVersion;
    private final boolean myMaxVersionInclusive;

    @NotNull
    static VersionRange parse(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/gradle/project/compatibility/VersionRange", "parse"));
        }
        if (value.isEmpty()) {
            throw new IllegalArgumentException("Empty string is not a valid value");
        }
        int size = value.length();
        char lastChar = value.charAt(size - 1);
        if (lastChar == '+') {
            String minVersion = value.substring(0, size - 1);
            VersionRange versionRange = new VersionRange(minVersion, true, null, false);
            if (versionRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/compatibility/VersionRange", "parse"));
            }
            return versionRange;
        }
        char firstChar = value.charAt(0);
        if (firstChar == '[' || firstChar == '(') {
            boolean minVersionInclusive;
            boolean bl = minVersionInclusive = firstChar == '[';
            if (lastChar != ']' && lastChar != ')') {
                throw new IllegalArgumentException(String.format("Value '%1$s' should end with ']' or ')'", value));
            }
            boolean maxVersionInclusive = lastChar == ']';
            String rangeValue = value.substring(1, size - 1);
            List values = Splitter.on((char)',').splitToList((CharSequence)rangeValue);
            if (values.size() != 2) {
                throw new IllegalArgumentException(String.format("Range '%1$s' should contain 2 values", value));
            }
            String minVersion = ((String)values.get(0)).trim();
            String maxVersion = ((String)values.get(1)).trim();
            if (maxVersion.length() == 1 && maxVersion.charAt(0) == '+') {
                maxVersion = null;
            }
            VersionRange versionRange = new VersionRange(minVersion, minVersionInclusive, maxVersion, maxVersionInclusive);
            if (versionRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/compatibility/VersionRange", "parse"));
            }
            return versionRange;
        }
        VersionRange versionRange = new VersionRange(value, false, null, false);
        if (versionRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/compatibility/VersionRange", "parse"));
        }
        return versionRange;
    }

    private VersionRange(@NotNull String minVersion, boolean minVersionInclusive, @Nullable String maxVersion, boolean maxVersionInclusive) {
        if (minVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "minVersion", "com/android/tools/idea/gradle/project/compatibility/VersionRange", "<init>"));
        }
        this.myMinVersion = minVersion;
        this.myMinRevision = VersionRange.asRevision(minVersion);
        this.myMinVersionInclusive = minVersionInclusive;
        this.myMaxVersion = maxVersion;
        this.myMaxRevision = VersionRange.asRevision(maxVersion);
        this.myMaxVersionInclusive = maxVersionInclusive;
    }

    boolean contains(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/gradle/project/compatibility/VersionRange", "contains"));
        }
        if (this.myMinRevision != null) {
            boolean contains = false;
            FullRevision revision = VersionRange.asRevision(value);
            if (revision != null) {
                if (this.myMinVersionInclusive) {
                    contains = revision.compareTo(this.myMinRevision, FullRevision.PreviewComparison.IGNORE) >= 0;
                } else {
                    boolean bl = contains = revision.compareTo(this.myMinRevision, FullRevision.PreviewComparison.IGNORE) > 0;
                }
                if (contains && this.myMaxRevision != null) {
                    contains = this.myMaxVersionInclusive ? revision.compareTo(this.myMaxRevision, FullRevision.PreviewComparison.IGNORE) <= 0 : revision.compareTo(this.myMaxRevision, FullRevision.PreviewComparison.IGNORE) < 0;
                }
            }
            return contains;
        }
        return value.equals(this.myMinVersion) || value.equals(this.myMaxVersion);
    }

    @Nullable
    private static FullRevision asRevision(@Nullable String version) {
        if (version != null) {
            try {
                return PreciseRevision.parseRevision((String)version);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @NotNull
    String getDescription() {
        if (this.myMinVersion.equals(this.myMaxVersion)) {
            String string = this.myMinVersion;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/compatibility/VersionRange", "getDescription"));
            }
            return string;
        }
        if (this.myMaxVersion == null) {
            String string = String.format("%1$s (or newer)", this.myMinVersion);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/compatibility/VersionRange", "getDescription"));
            }
            return string;
        }
        String string = "versions " + this.myMinVersion + VersionRange.inclusiveness(this.myMinVersionInclusive) + " to " + this.myMaxVersion + VersionRange.inclusiveness(this.myMaxVersionInclusive);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/compatibility/VersionRange", "getDescription"));
        }
        return string;
    }

    private static String inclusiveness(boolean inclusive) {
        return "(" + (inclusive ? "inclusive" : "exclusive") + ")";
    }
}

