/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification;

import com.android.tools.idea.gradle.service.notification.errors.AbstractSyncErrorHandler;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationExtension;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.NonNavigatable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleNotificationExtension
implements ExternalSystemNotificationExtension {
    private final List<AbstractSyncErrorHandler> myHandlers;

    public GradleNotificationExtension() {
        this(Arrays.asList(AbstractSyncErrorHandler.EP_NAME.getExtensions()));
    }

    @VisibleForTesting
    GradleNotificationExtension(@NotNull List<AbstractSyncErrorHandler> errorHandlers) {
        if (errorHandlers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorHandlers", "com/android/tools/idea/gradle/service/notification/GradleNotificationExtension", "<init>"));
        }
        this.myHandlers = errorHandlers;
    }

    @NotNull
    public ProjectSystemId getTargetExternalSystemId() {
        ProjectSystemId projectSystemId = GradleUtil.GRADLE_SYSTEM_ID;
        if (projectSystemId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/service/notification/GradleNotificationExtension", "getTargetExternalSystemId"));
        }
        return projectSystemId;
    }

    public void customize(@NotNull NotificationData notification, @NotNull Project project, @Nullable Throwable error) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/android/tools/idea/gradle/service/notification/GradleNotificationExtension", "customize"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/notification/GradleNotificationExtension", "customize"));
        }
        Throwable cause = error;
        if (error instanceof UndeclaredThrowableException && (cause = ((UndeclaredThrowableException)error).getUndeclaredThrowable()) instanceof InvocationTargetException) {
            cause = ((InvocationTargetException)cause).getTargetException();
        }
        if (cause instanceof ExternalSystemException) {
            this.handleError((ExternalSystemException)cause, notification, project);
        }
        if (notification.getNavigatable() == null) {
            notification.setNavigatable(NonNavigatable.INSTANCE);
        }
    }

    private void handleError(ExternalSystemException error, NotificationData notification, Project project) {
        String msg = error.getMessage();
        if (StringUtil.isEmpty((String)msg)) {
            return;
        }
        List lines = Splitter.on((char)'\n').omitEmptyStrings().trimResults().splitToList((CharSequence)msg);
        for (AbstractSyncErrorHandler handler : this.myHandlers) {
            if (!handler.handleError(lines, error, notification, project)) continue;
            return;
        }
    }
}

