/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification.hyperlink;

import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.descriptors.PkgDesc;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.service.notification.hyperlink.FixBuildToolsVersionHyperlink;
import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.android.tools.idea.sdk.wizard.SdkQuickfixWizard;
import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstallBuildToolsHyperlink
extends NotificationHyperlink {
    @NotNull
    private final String myVersion;
    @Nullable
    private final VirtualFile myBuildFile;

    public InstallBuildToolsHyperlink(@NotNull String version, @Nullable VirtualFile buildFile) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/android/tools/idea/gradle/service/notification/hyperlink/InstallBuildToolsHyperlink", "<init>"));
        }
        super("install.build.tools", InstallBuildToolsHyperlink.getText(version, buildFile));
        this.myBuildFile = buildFile;
        this.myVersion = version;
    }

    @NotNull
    private static String getText(@NotNull String version, @Nullable VirtualFile buildFile) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/android/tools/idea/gradle/service/notification/hyperlink/InstallBuildToolsHyperlink", "getText"));
        }
        String msg = String.format("Install Build Tools %1$s", version);
        msg = buildFile != null ? msg + ", update version in build file and sync project" : msg + " and sync project";
        String string = msg;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/service/notification/hyperlink/InstallBuildToolsHyperlink", "getText"));
        }
        return string;
    }

    @Override
    protected void execute(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/notification/hyperlink/InstallBuildToolsHyperlink", "execute"));
        }
        ArrayList requested = Lists.newArrayList();
        FullRevision minBuildToolsRev = FullRevision.parseRevision((String)this.myVersion);
        requested.add(PkgDesc.Builder.newBuildTool((FullRevision)minBuildToolsRev).create());
        SdkQuickfixWizard wizard = new SdkQuickfixWizard(project, null, requested);
        wizard.init();
        if (wizard.showAndGet()) {
            if (this.myBuildFile != null) {
                FixBuildToolsVersionHyperlink.fixBuildToolsVersionAndSync(project, this.myBuildFile, this.myVersion);
            } else {
                GradleProjectImporter.getInstance().requestProjectSync(project, null);
            }
        }
    }
}

