/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.cpu;

import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.tools.chartlib.EventData;
import com.android.tools.chartlib.TimelineComponent;
import com.android.tools.chartlib.TimelineData;
import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.ddms.actions.ToggleMethodProfilingAction;
import com.android.tools.idea.monitor.BaseMonitorView;
import com.android.tools.idea.monitor.DeviceSampler;
import com.android.tools.idea.monitor.TimelineEventListener;
import com.android.tools.idea.monitor.actions.RecordingAction;
import com.android.tools.idea.monitor.cpu.CpuSampler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithActions;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CpuMonitorView
extends BaseMonitorView
implements TimelineEventListener,
DeviceContext.DeviceSelectionListener {
    public static final int SAMPLES = 2048;
    private static final Color BACKGROUND_COLOR = UIUtil.getTextFieldBackground();
    private static final int SAMPLE_FREQUENCY_MS = 500;
    @NotNull
    private final CpuSampler myCpuSampler;
    private final DeviceContext myDeviceContext;

    public CpuMonitorView(@NotNull Project project, @NotNull DeviceContext deviceContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/monitor/cpu/CpuMonitorView", "<init>"));
        }
        if (deviceContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deviceContext", "com/android/tools/idea/monitor/cpu/CpuMonitorView", "<init>"));
        }
        super(project);
        float bufferTimeInSeconds = 0.75f;
        float initialMax = 100.0f;
        float initialMarker = 10.0f;
        TimelineData data = new TimelineData(2, 2048);
        EventData events = new EventData();
        TimelineComponent timelineComponent = new TimelineComponent(data, events, bufferTimeInSeconds, initialMax, 100.0f, initialMarker);
        timelineComponent.configureUnits("%");
        timelineComponent.configureStream(0, "Kernel", (Color)new JBColor(14106431, 14106431));
        timelineComponent.configureStream(1, "User", (Color)new JBColor(15441823, 10308684));
        timelineComponent.setBackground(BACKGROUND_COLOR);
        this.setComponent((JComponent)timelineComponent);
        this.myCpuSampler = new CpuSampler(data, 500);
        this.myCpuSampler.addListener(this);
        this.myDeviceContext = deviceContext;
        this.myDeviceContext.addListener(this, (Disposable)project);
    }

    @NotNull
    public ActionGroup getToolbarActions() {
        DefaultActionGroup group = new DefaultActionGroup();
        if (Boolean.getBoolean("enable.experimental.actions")) {
            group.add((AnAction)new RecordingAction(this.myCpuSampler));
        }
        group.add((AnAction)new ToggleMethodProfilingAction(this.myProject, this.myDeviceContext));
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/monitor/cpu/CpuMonitorView", "getToolbarActions"));
        }
        return defaultActionGroup;
    }

    @NotNull
    public ComponentWithActions createComponent() {
        ComponentWithActions.Impl impl = new ComponentWithActions.Impl(this.getToolbarActions(), null, null, null, (JComponent)this.myContentPane);
        if (impl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/monitor/cpu/CpuMonitorView", "createComponent"));
        }
        return impl;
    }

    @Override
    public void deviceSelected(@Nullable IDevice device) {
    }

    @Override
    public void deviceChanged(@NotNull IDevice device, int changeMask) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/monitor/cpu/CpuMonitorView", "deviceChanged"));
        }
    }

    @Override
    public void clientSelected(@Nullable Client c) {
        this.myCpuSampler.setClient(c);
    }

    @Override
    public void onStart() {
    }

    @Override
    public void onStop() {
    }

    @Override
    protected DeviceSampler getSampler() {
        return this.myCpuSampler;
    }
}

