/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.android.inspections.lint.SuppressLintIntentionAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SetAttributeFix
extends WriteCommandAction<Void> {
    private final XmlTag myTag;
    private final String myNamespace;
    private final String myAttribute;
    private final String myValue;

    public SetAttributeFix(@NotNull Project project, @NotNull XmlTag tag, @NotNull String attribute, @Nullable String namespace, @Nullable String value) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/rendering/SetAttributeFix", "<init>"));
        }
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/android/tools/idea/rendering/SetAttributeFix", "<init>"));
        }
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/android/tools/idea/rendering/SetAttributeFix", "<init>"));
        }
        super(project, String.format("Set %1$s Attribute", StringUtil.capitalize((String)attribute)), new PsiFile[]{tag.getContainingFile()});
        this.myTag = tag;
        this.myNamespace = namespace;
        this.myAttribute = attribute;
        this.myValue = value;
    }

    protected void run(@NotNull Result<Void> result) throws Throwable {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/rendering/SetAttributeFix", "run"));
        }
        if (this.myNamespace != null && this.myValue != null) {
            SuppressLintIntentionAction.ensureNamespaceImported(this.getProject(), (XmlFile)this.myTag.getContainingFile(), this.myNamespace);
        }
        this.myTag.setAttribute(this.myAttribute, this.myNamespace, this.myValue);
    }
}

