/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.remote.internal.packages;

import com.android.annotations.NonNull;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.SdkManager;
import com.android.sdklib.io.IFileOp;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.MajorRevision;
import com.android.sdklib.repository.descriptors.PkgDesc;
import com.android.tools.idea.sdk.remote.RemotePkgInfo;
import com.android.tools.idea.sdk.remote.internal.ITaskMonitor;
import com.android.tools.idea.sdk.remote.internal.archives.Archive;
import com.android.tools.idea.sdk.remote.internal.packages.IAndroidVersionProvider;
import com.android.tools.idea.sdk.remote.internal.packages.RemotePackageParserUtils;
import com.android.tools.idea.sdk.remote.internal.sources.SdkSource;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.w3c.dom.Node;

public class RemoteSourcePkgInfo
extends RemotePkgInfo
implements IAndroidVersionProvider {
    public RemoteSourcePkgInfo(SdkSource source, Node packageNode, String nsUri, Map<String, String> licenses) {
        super(source, packageNode, nsUri, licenses);
        int apiLevel = RemotePackageParserUtils.getXmlInt(packageNode, "api-level", 0);
        String codeName = RemotePackageParserUtils.getXmlString(packageNode, "codename");
        if (codeName.length() == 0) {
            codeName = null;
        }
        AndroidVersion version = new AndroidVersion(apiLevel, codeName);
        PkgDesc.Builder pkgDescBuilder = PkgDesc.Builder.newSource((AndroidVersion)version, (MajorRevision)new MajorRevision(this.getRevision()));
        pkgDescBuilder.setDescriptionShort(RemoteSourcePkgInfo.createShortDescription(this.mListDisplay, this.getRevision(), version, this.isObsolete()));
        pkgDescBuilder.setDescriptionUrl(this.getDescUrl());
        pkgDescBuilder.setListDisplay(RemoteSourcePkgInfo.createListDescription(this.mListDisplay, version, this.isObsolete()));
        pkgDescBuilder.setIsObsolete(this.isObsolete());
        pkgDescBuilder.setLicense(this.getLicense());
        this.mPkgDesc = pkgDescBuilder.create();
    }

    @Override
    public void saveProperties(Properties props) {
        super.saveProperties(props);
        this.getPkgDesc().getAndroidVersion().saveProperties(props);
    }

    @Override
    @NonNull
    public AndroidVersion getAndroidVersion() {
        return this.getPkgDesc().getAndroidVersion();
    }

    @Override
    public String installId() {
        return "source-" + this.getPkgDesc().getAndroidVersion().getApiString();
    }

    private static String createListDescription(String listDisplay, AndroidVersion version, boolean obsolete) {
        if (!listDisplay.isEmpty()) {
            return String.format("%1$s%2$s", listDisplay, obsolete ? " (Obsolete)" : "");
        }
        if (version.isPreview()) {
            return String.format("Sources for Android '%1$s' Preview SDK%2$s", version.getCodename(), obsolete ? " (Obsolete)" : "");
        }
        return String.format("Sources for Android SDK%2$s", version.getApiLevel(), obsolete ? " (Obsolete)" : "");
    }

    private static String createShortDescription(String listDisplay, FullRevision revision, AndroidVersion version, boolean obsolete) {
        if (!listDisplay.isEmpty()) {
            return String.format("%1$s, revision %2$s%3$s", listDisplay, revision.toShortString(), obsolete ? " (Obsolete)" : "");
        }
        if (version.isPreview()) {
            return String.format("Sources for Android '%1$s' Preview SDK, revision %2$s%3$s", version.getCodename(), revision.toShortString(), obsolete ? " (Obsolete)" : "");
        }
        return String.format("Sources for Android SDK, API %1$d, revision %2$s%3$s", version.getApiLevel(), revision.toShortString(), obsolete ? " (Obsolete)" : "");
    }

    @Override
    public File getInstallFolder(String osSdkRoot, SdkManager sdkManager) {
        File folder = new File(osSdkRoot, "sources");
        folder = new File(folder, "android-" + this.getPkgDesc().getAndroidVersion().getApiString());
        return folder;
    }

    @Override
    public void postUnzipFileHook(Archive archive, ITaskMonitor monitor, IFileOp fileOp, File unzippedFile, ZipArchiveEntry zipEntry) {
        super.postUnzipFileHook(archive, monitor, fileOp, unzippedFile, zipEntry);
        if (fileOp.isFile(unzippedFile) && !"source.properties".equals(unzippedFile.getName())) {
            fileOp.setReadOnly(unzippedFile);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        AndroidVersion version = this.getPkgDesc().getAndroidVersion();
        result = 31 * result + (version == null ? 0 : version.hashCode());
        return result;
    }
}

