/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.wizard;

import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.tools.idea.sdk.SdkState;
import com.android.tools.idea.sdk.remote.UpdatablePkgInfo;
import com.android.tools.idea.sdk.wizard.LicenseAgreementStep;
import com.android.tools.idea.sdk.wizard.SmwOldApiDirectInstall;
import com.android.tools.idea.wizard.DialogWrapperHost;
import com.android.tools.idea.wizard.DynamicWizard;
import com.android.tools.idea.wizard.DynamicWizardPath;
import com.android.tools.idea.wizard.ScopedStateStore;
import com.android.tools.idea.wizard.WizardConstants;
import com.google.common.collect.Sets;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.android.actions.RunAndroidSdkManagerAction;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkQuickfixWizard
extends DynamicWizard {
    private final List<IPkgDesc> myRequestedPackages;

    public SdkQuickfixWizard(@Nullable Project project, @Nullable Module module, List<IPkgDesc> requestedPackages) {
        this(project, module, requestedPackages, new DialogWrapperHost(project));
    }

    public SdkQuickfixWizard(@Nullable Project project, @Nullable Module module, List<IPkgDesc> requestedPackages, DialogWrapperHost host) {
        super(project, module, "SDK Quickfix Installation", host);
        this.myRequestedPackages = requestedPackages;
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return null;
    }

    @Override
    public void init() {
        ScopedStateStore state = this.getState();
        this.addPath(new SdkQuickfixPath(this.getDisposable()));
        Set<IPkgDesc> problems = this.findProblemPackages();
        int selectedOption = 1;
        if (!problems.isEmpty()) {
            StringBuilder warningBuilder = new StringBuilder("Due to your system configuration and the packages to be installed, \nit is likely that the following packages cannot be successfully installed while ");
            warningBuilder.append(ApplicationNamesInfo.getInstance().getFullProductName());
            warningBuilder.append(" is running. \n\nPlease exit and install the following packages using the standalone SDK manager:");
            for (IPkgDesc problemPkg : problems) {
                warningBuilder.append("\n    -");
                warningBuilder.append(problemPkg.getListDescription());
            }
            if (problems.size() == this.myRequestedPackages.size()) {
                selectedOption = Messages.showDialog((Project)this.getProject(), (String)warningBuilder.toString(), (String)"Warning", (String[])new String[]{String.format("Exit %s and launch SDK Manager", ApplicationNamesInfo.getInstance().getProductName()), "Attempt to install packages"}, (int)0, (Icon)AllIcons.General.Warning);
            } else {
                String[] options = new String[]{String.format("Exit %s and launch SDK Manager", ApplicationNamesInfo.getInstance().getProductName()), "Attempt to install all packages", "Install safe packages"};
                selectedOption = Messages.showDialog((Project)this.getProject(), (String)warningBuilder.toString(), (String)"Warning", (String[])options, (int)2, (Icon)AllIcons.General.Warning);
            }
        }
        if (selectedOption == 0) {
            this.startSdkManagerAndExit();
        } else {
            for (IPkgDesc desc : this.myRequestedPackages) {
                if (selectedOption == 2 && problems.contains(desc)) {
                    state.listPush(WizardConstants.SKIPPED_INSTALL_REQUESTS_KEY, desc);
                    continue;
                }
                state.listPush(WizardConstants.INSTALL_REQUESTS_KEY, desc);
            }
        }
        super.init();
    }

    private void startSdkManagerAndExit() {
        RunAndroidSdkManagerAction.runSpecificSdkManagerSynchronously(this.getProject(), AndroidSdkUtils.tryToChooseAndroidSdk().getLocation());
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                ApplicationManagerEx.getApplicationEx().exit(true, true);
            }
        });
    }

    private Set<IPkgDesc> findProblemPackages() {
        HashSet result = Sets.newHashSet();
        if (!SystemInfo.isWindows) {
            return result;
        }
        SdkState state = SdkState.getInstance(AndroidSdkUtils.tryToChooseAndroidSdk());
        state.loadSynchronously(SdkState.DEFAULT_EXPIRATION_PERIOD_MS, false, null, null, null, false);
        HashSet available = Sets.newHashSet();
        for (UpdatablePkgInfo update : state.getPackages().getUpdatedPkgs()) {
            if (update.hasRemote(false)) {
                available.add(update.getRemote(false).getPkgDesc().getInstallId());
            }
            if (!update.hasPreview()) continue;
            available.add(update.getRemote(true).getPkgDesc().getInstallId());
        }
        for (IPkgDesc request : this.myRequestedPackages) {
            if (!available.contains(request.getInstallId())) continue;
            result.add(request);
        }
        return result;
    }

    @Override
    public void performFinishingActions() {
        List<IPkgDesc> skipped = this.myState.get(WizardConstants.SKIPPED_INSTALL_REQUESTS_KEY);
        if (skipped != null && !skipped.isEmpty()) {
            StringBuilder warningBuilder = new StringBuilder("The following packages were not installed.\n\n Would you like to exit ");
            warningBuilder.append(ApplicationNamesInfo.getInstance().getFullProductName());
            warningBuilder.append(" and install the following packages using the standalone SDK manager?");
            for (IPkgDesc problemPkg : skipped) {
                warningBuilder.append("\n");
                warningBuilder.append(problemPkg.getListDescription());
            }
            String restartOption = String.format("Exit %s and launch SDK Manager", ApplicationNamesInfo.getInstance().getProductName());
            int result = Messages.showDialog((Project)this.getProject(), (String)warningBuilder.toString(), (String)"Warning", (String[])new String[]{restartOption, "Skip installation"}, (int)0, (Icon)AllIcons.General.Warning);
            if (result == 0) {
                this.startSdkManagerAndExit();
            }
        }
        AndroidSdkData data = AndroidSdkUtils.tryToChooseAndroidSdk();
        SdkState.getInstance(data).loadAsync(SdkState.DEFAULT_EXPIRATION_PERIOD_MS, false, null, null, null, true);
    }

    @Override
    @NotNull
    protected String getProgressTitle() {
        if ("Finishing install..." == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/wizard/SdkQuickfixWizard", "getProgressTitle"));
        }
        return "Finishing install...";
    }

    @Override
    protected String getWizardActionDescription() {
        return "Provides a method for handling quickfix SDK installation actions";
    }

    private static class SdkQuickfixPath
    extends DynamicWizardPath {
        private Disposable myDisposable;
        private LicenseAgreementStep myLicenseAgreementStep;

        public SdkQuickfixPath(Disposable disposable) {
            this.myDisposable = disposable;
        }

        @Override
        protected void init() {
            this.myLicenseAgreementStep = new LicenseAgreementStep(this.myDisposable);
            this.addStep(this.myLicenseAgreementStep);
            this.addStep(new SmwOldApiDirectInstall(this.myDisposable));
        }

        @Override
        @NotNull
        public String getPathName() {
            if ("SDK Installation Quickfix" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/wizard/SdkQuickfixWizard$SdkQuickfixPath", "getPathName"));
            }
            return "SDK Installation Quickfix";
        }

        @Override
        public boolean performFinishingActions() {
            this.myLicenseAgreementStep.performFinishingActions();
            return true;
        }
    }
}

