/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.structure;

import com.intellij.openapi.roots.ui.configuration.ConfigurationError;
import com.intellij.ui.awt.RelativePoint;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectConfigurationError
extends ConfigurationError {
    @Nullable
    private final JComponent myNavigationTarget;
    private Runnable myNavigationTask;
    private Runnable myQuickFix;

    public ProjectConfigurationError(@NotNull String description, @Nullable JComponent navigationTarget) {
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/android/tools/idea/structure/ProjectConfigurationError", "<init>"));
        }
        super(description, description);
        this.myNavigationTarget = navigationTarget;
    }

    public ProjectConfigurationError(@NotNull String description, @Nullable JComponent navigationTarget, boolean ignored) {
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/android/tools/idea/structure/ProjectConfigurationError", "<init>"));
        }
        super(description, description, ignored);
        this.myNavigationTarget = navigationTarget;
    }

    public void setNavigationTask(@NotNull Runnable navigationTask) {
        if (navigationTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigationTask", "com/android/tools/idea/structure/ProjectConfigurationError", "setNavigationTask"));
        }
        this.myNavigationTask = navigationTask;
    }

    public void navigate() {
        if (this.myNavigationTask != null) {
            this.myNavigationTask.run();
            if (this.myNavigationTarget != null) {
                this.myNavigationTarget.requestFocusInWindow();
            }
        }
    }

    public void setQuickFix(@NotNull Runnable quickFix) {
        if (quickFix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quickFix", "com/android/tools/idea/structure/ProjectConfigurationError", "setQuickFix"));
        }
        this.myQuickFix = quickFix;
    }

    public boolean canBeFixed() {
        return this.myQuickFix != null;
    }

    public void fix(JComponent contextComponent, RelativePoint relativePoint) {
        if (this.canBeFixed()) {
            this.myQuickFix.run();
        }
    }
}

