/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.logging.LogLevel;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogLevel;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;

public class Http2FrameLogger
extends ChannelHandlerAdapter {
    private static final int BUFFER_LENGTH_THRESHOLD = 64;
    private final InternalLogger logger;
    private final InternalLogLevel level;

    public Http2FrameLogger(LogLevel level) {
        this(level.toInternalLevel(), InternalLoggerFactory.getInstance(Http2FrameLogger.class));
    }

    public Http2FrameLogger(LogLevel level, String name) {
        this(level.toInternalLevel(), InternalLoggerFactory.getInstance(name));
    }

    public Http2FrameLogger(LogLevel level, Class<?> clazz) {
        this(level.toInternalLevel(), InternalLoggerFactory.getInstance(clazz));
    }

    private Http2FrameLogger(InternalLogLevel level, InternalLogger logger) {
        this.level = ObjectUtil.checkNotNull(level, "level");
        this.logger = ObjectUtil.checkNotNull(logger, "logger");
    }

    public void logData(Direction direction, int streamId, ByteBuf data, int padding, boolean endStream) {
        if (this.enabled()) {
            this.log(direction, "DATA: streamId=%d, padding=%d, endStream=%b, length=%d, bytes=%s", streamId, padding, endStream, data.readableBytes(), this.toString(data));
        }
    }

    public void logHeaders(Direction direction, int streamId, Http2Headers headers, int padding, boolean endStream) {
        if (this.enabled()) {
            this.log(direction, "HEADERS: streamId=%d, headers=%s, padding=%d, endStream=%b", streamId, headers, padding, endStream);
        }
    }

    public void logHeaders(Direction direction, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) {
        if (this.enabled()) {
            this.log(direction, "HEADERS: streamId=%d, headers=%s, streamDependency=%d, weight=%d, exclusive=%b, padding=%d, endStream=%b", streamId, headers, streamDependency, weight, exclusive, padding, endStream);
        }
    }

    public void logPriority(Direction direction, int streamId, int streamDependency, short weight, boolean exclusive) {
        if (this.enabled()) {
            this.log(direction, "PRIORITY: streamId=%d, streamDependency=%d, weight=%d, exclusive=%b", streamId, streamDependency, weight, exclusive);
        }
    }

    public void logRstStream(Direction direction, int streamId, long errorCode) {
        if (this.enabled()) {
            this.log(direction, "RST_STREAM: streamId=%d, errorCode=%d", streamId, errorCode);
        }
    }

    public void logSettingsAck(Direction direction) {
        if (this.enabled()) {
            this.log(direction, "SETTINGS ack=true", new Object[0]);
        }
    }

    public void logSettings(Direction direction, Http2Settings settings) {
        if (this.enabled()) {
            this.log(direction, "SETTINGS: ack=false, settings=%s", settings);
        }
    }

    public void logPing(Direction direction, ByteBuf data) {
        if (this.enabled()) {
            this.log(direction, "PING: ack=false, length=%d, bytes=%s", data.readableBytes(), this.toString(data));
        }
    }

    public void logPingAck(Direction direction, ByteBuf data) {
        if (this.enabled()) {
            this.log(direction, "PING: ack=true, length=%d, bytes=%s", data.readableBytes(), this.toString(data));
        }
    }

    public void logPushPromise(Direction direction, int streamId, int promisedStreamId, Http2Headers headers, int padding) {
        if (this.enabled()) {
            this.log(direction, "PUSH_PROMISE: streamId=%d, promisedStreamId=%d, headers=%s, padding=%d", streamId, promisedStreamId, headers, padding);
        }
    }

    public void logGoAway(Direction direction, int lastStreamId, long errorCode, ByteBuf debugData) {
        if (this.enabled()) {
            this.log(direction, "GO_AWAY: lastStreamId=%d, errorCode=%d, length=%d, bytes=%s", lastStreamId, errorCode, debugData.readableBytes(), this.toString(debugData));
        }
    }

    public void logWindowsUpdate(Direction direction, int streamId, int windowSizeIncrement) {
        if (this.enabled()) {
            this.log(direction, "WINDOW_UPDATE: streamId=%d, windowSizeIncrement=%d", streamId, windowSizeIncrement);
        }
    }

    public void logUnknownFrame(Direction direction, byte frameType, int streamId, Http2Flags flags, ByteBuf data) {
        if (this.enabled()) {
            this.log(direction, "UNKNOWN: frameType=%d, streamId=%d, flags=%d, length=%d, bytes=%s", frameType & 0xFF, streamId, flags.value(), data.readableBytes(), this.toString(data));
        }
    }

    private boolean enabled() {
        return this.logger.isEnabled(this.level);
    }

    private String toString(ByteBuf buf) {
        if (this.level == InternalLogLevel.TRACE || buf.readableBytes() <= 64) {
            return ByteBufUtil.hexDump(buf);
        }
        int length = Math.min(buf.readableBytes(), 64);
        return ByteBufUtil.hexDump(buf, buf.readerIndex(), length) + "...";
    }

    private void log(Direction direction, String format, Object ... args) {
        StringBuilder b = new StringBuilder(200);
        b.append("\n----------------").append(direction.name()).append("--------------------\n").append(String.format(format, args)).append("\n------------------------------------");
        this.logger.log(this.level, b.toString());
    }

    public static enum Direction {
        INBOUND,
        OUTBOUND;

    }
}

