/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.instrumentation;

import com.intellij.compiler.instrumentation.InstrumentationClassFinder;
import org.jetbrains.org.objectweb.asm.ClassWriter;

public class InstrumenterClassWriter
extends ClassWriter {
    private final InstrumentationClassFinder myFinder;

    public InstrumenterClassWriter(int flags, InstrumentationClassFinder finder) {
        super(flags);
        this.myFinder = finder;
    }

    protected String getCommonSuperClass(String type1, String type2) {
        try {
            InstrumentationClassFinder.PseudoClass cls1 = this.myFinder.loadClass(type1);
            InstrumentationClassFinder.PseudoClass cls2 = this.myFinder.loadClass(type2);
            if (cls1.isAssignableFrom(cls2)) {
                return cls1.getName();
            }
            if (cls2.isAssignableFrom(cls1)) {
                return cls2.getName();
            }
            if (cls1.isInterface() || cls2.isInterface()) {
                return "java/lang/Object";
            }
            InstrumentationClassFinder.PseudoClass c = cls1;
            while (!(c = c.getSuperClass()).isAssignableFrom(cls2)) {
            }
            return c.getName();
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString(), e);
        }
    }
}

