/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.ActionSet;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Macros;
import org.gjt.sp.jedit.gui.FilteredTableModel;
import org.gjt.sp.jedit.gui.GrabKeyDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;
import org.jedit.keymap.Keymap;
import org.jedit.keymap.KeymapManager;

public class ShortcutsOptionPane
extends AbstractOptionPane {
    private Keymap selectedKeymap;
    private JButton duplicateKeymap;
    private JButton resetKeymap;
    private JButton deleteKeymap;
    private JComboBox<String> keymaps;
    private JTable keyTable;
    private Vector<ShortcutsModel> models;
    private FilteredTableModel<ShortcutsModel> filteredModel;
    private JComboBox<ShortcutsModel> selectModel;
    private List<GrabKeyDialog.KeyBinding> allBindings;
    private JTextField filterTF;

    public ShortcutsOptionPane() {
        super("shortcuts");
    }

    @Override
    protected void _init() {
        this.allBindings = new Vector<GrabKeyDialog.KeyBinding>();
        this.setLayout(new BorderLayout(12, 12));
        KeymapManager keymapManager = jEdit.getKeymapManager();
        String string = jEdit.getProperty("keymap.current");
        this.selectedKeymap = keymapManager.getKeymap(string);
        if (this.selectedKeymap == null) {
            this.selectedKeymap = keymapManager.getKeymap("jEdit");
        }
        this.initModels();
        this.duplicateKeymap = new JButton(jEdit.getProperty("options.shortcuts.duplicatekeymap.label"));
        this.resetKeymap = new JButton(jEdit.getProperty("options.shortcuts.resetkeymap.label"));
        this.deleteKeymap = new JButton(jEdit.getProperty("options.shortcuts.deletekeymap.label"));
        this.resetButtons();
        ActionHandler actionHandler = new ActionHandler();
        KeymapsModel keymapsModel = new KeymapsModel();
        this.keymaps = new JComboBox<String>(keymapsModel);
        this.keymaps.setRenderer(new KeymapCellRenderer());
        this.keymaps.setSelectedItem(string);
        this.duplicateKeymap.addActionListener(actionHandler);
        this.resetKeymap.addActionListener(actionHandler);
        this.deleteKeymap.addActionListener(actionHandler);
        this.keymaps.addActionListener(actionHandler);
        this.keymaps.setSelectedItem(this.selectedKeymap);
        JPanel jPanel = new JPanel(new FlowLayout(3));
        jPanel.add(new JLabel(jEdit.getProperty("options.shortcuts.keymap.label")));
        jPanel.add(this.keymaps);
        jPanel.add(Box.createHorizontalStrut(6));
        jPanel.add(this.duplicateKeymap);
        jPanel.add(this.resetKeymap);
        jPanel.add(this.deleteKeymap);
        this.selectModel = new JComboBox<ShortcutsModel>(this.models);
        this.selectModel.addActionListener(actionHandler);
        this.selectModel.setToolTipText(jEdit.getProperty("options.shortcuts.select.tooltip"));
        Box box = Box.createHorizontalBox();
        box.add(new JLabel(jEdit.getProperty("options.shortcuts.select.label")));
        box.add(Box.createHorizontalStrut(6));
        box.add(this.selectModel);
        this.filterTF = new JTextField(40);
        this.filterTF.setToolTipText(jEdit.getProperty("options.shortcuts.filter.tooltip"));
        this.filterTF.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                ShortcutsOptionPane.this.setFilter();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                ShortcutsOptionPane.this.setFilter();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                ShortcutsOptionPane.this.setFilter();
            }
        });
        JButton jButton = new JButton(jEdit.getProperty("options.shortcuts.clear.label"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ShortcutsOptionPane.this.filterTF.setText("");
                ShortcutsOptionPane.this.filterTF.requestFocus();
            }
        });
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(new JLabel(jEdit.getProperty("options.shortcuts.filter.label")));
        jPanel2.add(this.filterTF);
        jPanel2.add(jButton);
        this.keyTable = new JTable(this.filteredModel);
        this.filteredModel.setTable(this.keyTable);
        this.keyTable.getTableHeader().setReorderingAllowed(false);
        this.keyTable.getTableHeader().addMouseListener(new HeaderMouseHandler());
        this.keyTable.addMouseListener(new TableMouseHandler());
        Dimension dimension = this.keyTable.getPreferredSize();
        dimension.height = Math.min(dimension.height, 200);
        JScrollPane jScrollPane = new JScrollPane(this.keyTable);
        jScrollPane.setPreferredSize(dimension);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add("North", jPanel2);
        jPanel3.add("Center", jScrollPane);
        Box box2 = Box.createVerticalBox();
        box2.add(jPanel);
        box2.add(Box.createVerticalGlue());
        box2.add(box);
        this.add("North", box2);
        this.add("Center", jPanel3);
        try {
            this.selectModel.setSelectedIndex(jEdit.getIntegerProperty("options.shortcuts.select.index", 0));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    protected void _save() {
        jEdit.setProperty("keymap.current", this.selectedKeymap.toString());
        if (this.keyTable.getCellEditor() != null) {
            this.keyTable.getCellEditor().stopCellEditing();
        }
        for (ShortcutsModel shortcutsModel : this.models) {
            shortcutsModel.save();
        }
        Macros.loadMacros();
        this.selectedKeymap.save();
    }

    private void setFilter() {
        this.filteredModel.setFilter(this.filterTF.getText());
    }

    private void initModels() {
        this.filteredModel = new FilteredTableModel<ShortcutsModel>(){

            @Override
            public String prepareFilter(String string) {
                return string.toLowerCase();
            }

            @Override
            public boolean passFilter(int n, String string) {
                String string2 = ((ShortcutsModel)this.delegated).getBindingAt((int)n, (int)0).label.toLowerCase();
                return string2.contains(string);
            }
        };
        this.models = new Vector();
        this.reloadModels();
    }

    private void reloadModels() {
        this.models.clear();
        this.allBindings.clear();
        ArrayList<GrabKeyDialog.KeyBinding[]> arrayList = new ArrayList<GrabKeyDialog.KeyBinding[]>();
        HashSet<String> hashSet = new HashSet<String>();
        ActionSet[] actionSetArray = jEdit.getActionSets();
        for (ActionSet actionSet : actionSetArray) {
            if (actionSet.getActionCount() == 0) continue;
            String string = actionSet.getLabel();
            if (string == null) {
                Log.log(9, this, "Empty action set: " + actionSet.getPluginJAR());
            }
            ShortcutsModel shortcutsModel = this.createModel(actionSet.getLabel(), string, actionSet.getActionNames());
            this.models.add(shortcutsModel);
            List<GrabKeyDialog.KeyBinding[]> list = shortcutsModel.getBindings();
            for (GrabKeyDialog.KeyBinding[] keyBindingArray : list) {
                String string2 = keyBindingArray[0].name;
                if (hashSet.contains(string2)) continue;
                hashSet.add(string2);
                arrayList.add(keyBindingArray);
            }
        }
        if (this.models.size() > 1) {
            this.models.add(new ShortcutsModel("All", arrayList));
        }
        Object object = this.filteredModel.getDelegated();
        Collections.sort(this.models, new StandardUtilities.StringCompare(true));
        if (object == null) {
            object = this.models.get(0);
        } else {
            for (ShortcutsModel shortcutsModel : this.models) {
                if (!shortcutsModel.toString().equals(((ShortcutsModel)object).toString())) continue;
                object = shortcutsModel;
                break;
            }
        }
        this.filteredModel.setDelegated((ShortcutsModel)object);
        this.filteredModel.fireTableDataChanged();
    }

    private ShortcutsModel createModel(String string, String string2, String[] stringArray) {
        ArrayList<GrabKeyDialog.KeyBinding[]> arrayList = new ArrayList<GrabKeyDialog.KeyBinding[]>(stringArray.length);
        for (String string3 : stringArray) {
            EditAction editAction = jEdit.getAction(string3);
            String string4 = editAction.getLabel();
            if (string4 == null) continue;
            string4 = GUIUtilities.prettifyMenuLabel(string4);
            this.addBindings(string, string3, string4, arrayList);
        }
        return new ShortcutsModel(string2, arrayList);
    }

    private void addBindings(String string, String string2, String string3, Collection<GrabKeyDialog.KeyBinding[]> collection) {
        GrabKeyDialog.KeyBinding[] keyBindingArray = new GrabKeyDialog.KeyBinding[]{this.createBinding(string, string2, string3, this.selectedKeymap.getShortcut(string2 + ".shortcut")), this.createBinding(string, string2, string3, this.selectedKeymap.getShortcut(string2 + ".shortcut2"))};
        collection.add(keyBindingArray);
    }

    private GrabKeyDialog.KeyBinding createBinding(String string, String string2, String string3, String string4) {
        if (string4 != null && string4.isEmpty()) {
            string4 = null;
        }
        GrabKeyDialog.KeyBinding keyBinding = new GrabKeyDialog.KeyBinding(string2, string3, string4, false);
        keyBinding.actionSet = string;
        this.allBindings.add(keyBinding);
        return keyBinding;
    }

    private void resetButtons() {
        KeymapManager keymapManager = jEdit.getKeymapManager();
        KeymapManager.State state = keymapManager.getKeymapState(this.selectedKeymap.toString());
        this.resetKeymap.setEnabled(state == KeymapManager.State.SystemModified);
        this.deleteKeymap.setEnabled(state == KeymapManager.State.User);
    }

    private static class KeymapCellRenderer
    extends DefaultListCellRenderer {
        private KeymapCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent(jList, object, n, bl, bl2);
            String string = jEdit.getProperty("keymaps." + object + ".label", String.valueOf(object).replace('_', ' '));
            this.setText(string);
            return this;
        }
    }

    private static class KeymapsModel
    extends AbstractListModel<String>
    implements ComboBoxModel<String> {
        private String[] keymaps;
        private Object selectedItem;

        private KeymapsModel() {
            this.reset();
        }

        void reset() {
            KeymapManager keymapManager = jEdit.getKeymapManager();
            Collection<String> collection = keymapManager.getKeymapNames();
            this.keymaps = collection.toArray(new String[collection.size()]);
            if (!this.isValidName(this.selectedItem)) {
                this.selectedItem = this.keymaps[0];
            }
            this.fireContentsChanged(this, 0, this.keymaps.length - 1);
        }

        @Override
        public int getSize() {
            return this.keymaps.length;
        }

        @Override
        public String getElementAt(int n) {
            return this.keymaps[n];
        }

        @Override
        public void setSelectedItem(Object object) {
            this.selectedItem = this.isValidName(object) ? object : this.keymaps[0];
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedItem;
        }

        private boolean isValidName(Object object) {
            for (String string : this.keymaps) {
                if (!string.equals(object)) continue;
                return true;
            }
            return false;
        }
    }

    private class ShortcutsModel
    extends AbstractTableModel {
        public static final String ALL = "All";
        private final List<GrabKeyDialog.KeyBinding[]> bindings;
        private final String name;

        ShortcutsModel(String string, List<GrabKeyDialog.KeyBinding[]> list) {
            this.name = string;
            this.bindings = list;
            this.sort(0);
        }

        public List<GrabKeyDialog.KeyBinding[]> getBindings() {
            return this.bindings;
        }

        public void sort(int n) {
            Collections.sort(this.bindings, new KeyCompare(n));
        }

        @Override
        public int getColumnCount() {
            if (ALL.equals(this.name)) {
                return 4;
            }
            return 3;
        }

        @Override
        public int getRowCount() {
            return this.bindings.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            GrabKeyDialog.KeyBinding keyBinding = this.getBindingAt(n, 0);
            ShortcutsOptionPane.this.setToolTipText(keyBinding.label);
            switch (n2) {
                case 0: {
                    return keyBinding.label;
                }
                case 1: {
                    return GUIUtilities.getPlatformShortcutLabel(keyBinding.shortcut);
                }
                case 2: {
                    return GUIUtilities.getPlatformShortcutLabel(this.getBindingAt((int)n, (int)1).shortcut);
                }
                case 3: {
                    return keyBinding.actionSet;
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                return;
            }
            this.getBindingAt((int)n, (int)(n2 - 1)).shortcut = (String)object;
            this.fireTableDataChanged();
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return jEdit.getProperty("options.shortcuts.name");
                }
                case 1: {
                    return jEdit.getProperty("options.shortcuts.shortcut1");
                }
                case 2: {
                    return jEdit.getProperty("options.shortcuts.shortcut2");
                }
                case 3: {
                    return jEdit.getProperty("options.shortcuts.actionset");
                }
            }
            return null;
        }

        public void save() {
            for (GrabKeyDialog.KeyBinding[] keyBindingArray : this.bindings) {
                ShortcutsOptionPane.this.selectedKeymap.setShortcut(keyBindingArray[0].name + ".shortcut", keyBindingArray[0].shortcut);
                ShortcutsOptionPane.this.selectedKeymap.setShortcut(keyBindingArray[1].name + ".shortcut2", keyBindingArray[1].shortcut);
            }
        }

        public GrabKeyDialog.KeyBinding getBindingAt(int n, int n2) {
            GrabKeyDialog.KeyBinding[] keyBindingArray = this.bindings.get(n);
            return keyBindingArray[n2];
        }

        public String toString() {
            return this.name;
        }

        private class KeyCompare
        implements Comparator<GrabKeyDialog.KeyBinding[]> {
            private final int col;

            KeyCompare(int n) {
                this.col = n;
            }

            @Override
            public int compare(GrabKeyDialog.KeyBinding[] keyBindingArray, GrabKeyDialog.KeyBinding[] keyBindingArray2) {
                String string;
                String string2;
                String string3 = keyBindingArray[0].label.toLowerCase();
                String string4 = keyBindingArray2[0].label.toLowerCase();
                if (this.col == 0) {
                    return StandardUtilities.compareStrings(string3, string4, true);
                }
                if (this.col == 1) {
                    string2 = keyBindingArray[0].shortcut;
                    string = keyBindingArray2[0].shortcut;
                } else {
                    string2 = keyBindingArray[1].shortcut;
                    string = keyBindingArray2[1].shortcut;
                }
                if (string2 == null && string != null) {
                    return 1;
                }
                if (string == null && string2 != null) {
                    return -1;
                }
                if (string2 == null) {
                    return StandardUtilities.compareStrings(string3, string4, true);
                }
                return StandardUtilities.compareStrings(string2, string, true);
            }
        }
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            KeymapManager keymapManager;
            KeymapManager.State state;
            int n;
            if (actionEvent.getSource() == ShortcutsOptionPane.this.selectModel) {
                ShortcutsModel shortcutsModel = (ShortcutsModel)ShortcutsOptionPane.this.selectModel.getSelectedItem();
                if (ShortcutsOptionPane.this.filteredModel.getDelegated() != shortcutsModel) {
                    jEdit.setIntegerProperty("options.shortcuts.select.index", ShortcutsOptionPane.this.selectModel.getSelectedIndex());
                    ShortcutsOptionPane.this.filteredModel.setDelegated(shortcutsModel);
                    ShortcutsOptionPane.this.setFilter();
                }
            } else if (actionEvent.getSource() == ShortcutsOptionPane.this.keymaps) {
                String string = (String)ShortcutsOptionPane.this.keymaps.getSelectedItem();
                KeymapManager keymapManager2 = jEdit.getKeymapManager();
                ShortcutsOptionPane.this.selectedKeymap = keymapManager2.getKeymap(string);
                ShortcutsOptionPane.this.resetButtons();
                ShortcutsOptionPane.this.reloadModels();
            } else if (actionEvent.getSource() == ShortcutsOptionPane.this.duplicateKeymap) {
                String string = JOptionPane.showInputDialog(ShortcutsOptionPane.this, jEdit.getProperty("options.shortcuts.duplicatekeymap.dialog.label"), jEdit.getProperty("options.shortcuts.duplicatekeymap.dialog.title"), 3);
                if (string == null) {
                    return;
                }
                string = string.replace(' ', '_');
                KeymapManager keymapManager3 = jEdit.getKeymapManager();
                Collection<String> collection = keymapManager3.getKeymapNames();
                while (collection.contains(string)) {
                    string = JOptionPane.showInputDialog(ShortcutsOptionPane.this, jEdit.getProperty("options.shortcuts.duplicatekeymap.keymapalreadyexists.label"), jEdit.getProperty("options.shortcuts.duplicatekeymap.dialog.title"), 3);
                    if (string == null) {
                        return;
                    }
                    string = string.replace(' ', '_');
                }
                if (keymapManager3.copyKeymap(ShortcutsOptionPane.this.selectedKeymap.toString(), string)) {
                    KeymapsModel keymapsModel = (KeymapsModel)ShortcutsOptionPane.this.keymaps.getModel();
                    keymapsModel.reset();
                    ShortcutsOptionPane.this.keymaps.setSelectedItem(string);
                }
            } else if (actionEvent.getSource() == ShortcutsOptionPane.this.resetKeymap) {
                int n2 = JOptionPane.showConfirmDialog(ShortcutsOptionPane.this, jEdit.getProperty("options.shortcuts.resetkeymap.dialog.label"), jEdit.getProperty("options.shortcuts.resetkeymap.dialog.title"), 0, 3);
                if (n2 == 0) {
                    String string = ShortcutsOptionPane.this.selectedKeymap.toString();
                    KeymapManager keymapManager4 = jEdit.getKeymapManager();
                    keymapManager4.resetKeymap(string);
                    ShortcutsOptionPane.this.selectedKeymap = keymapManager4.getKeymap(string);
                    ShortcutsOptionPane.this.resetButtons();
                    ShortcutsOptionPane.this.reloadModels();
                }
            } else if (actionEvent.getSource() == ShortcutsOptionPane.this.deleteKeymap && (n = JOptionPane.showConfirmDialog(ShortcutsOptionPane.this, jEdit.getProperty("options.shortcuts.deletekeymap.dialog.label"), jEdit.getProperty("options.shortcuts.deletekeymap.dialog.title"), 0, 3)) == 0 && (state = (keymapManager = jEdit.getKeymapManager()).getKeymapState(ShortcutsOptionPane.this.selectedKeymap.toString())) == KeymapManager.State.User) {
                keymapManager.deleteUserKeymap(ShortcutsOptionPane.this.selectedKeymap.toString());
                KeymapsModel keymapsModel = (KeymapsModel)ShortcutsOptionPane.this.keymaps.getModel();
                keymapsModel.reset();
            }
        }
    }

    private class TableMouseHandler
    extends MouseAdapter {
        private TableMouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            GrabKeyDialog grabKeyDialog;
            int n = ShortcutsOptionPane.this.keyTable.getSelectedRow();
            int n2 = ShortcutsOptionPane.this.keyTable.getSelectedColumn();
            if (n2 != 0 && n != -1 && (grabKeyDialog = new GrabKeyDialog((Dialog)GUIUtilities.getParentDialog(ShortcutsOptionPane.this), ((ShortcutsModel)ShortcutsOptionPane.this.filteredModel.getDelegated()).getBindingAt(ShortcutsOptionPane.this.filteredModel.getTrueRow(n), n2 - 1), (List<GrabKeyDialog.KeyBinding>)ShortcutsOptionPane.this.allBindings, null)).isOK()) {
                ShortcutsOptionPane.this.filteredModel.setValueAt(grabKeyDialog.getShortcut(), n, n2);
            }
        }
    }

    private class HeaderMouseHandler
    extends MouseAdapter {
        private HeaderMouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            ShortcutsModel shortcutsModel = (ShortcutsModel)ShortcutsOptionPane.this.filteredModel.getDelegated();
            switch (ShortcutsOptionPane.this.keyTable.getTableHeader().columnAtPoint(mouseEvent.getPoint())) {
                case 0: {
                    shortcutsModel.sort(0);
                    break;
                }
                case 1: {
                    shortcutsModel.sort(1);
                    break;
                }
                case 2: {
                    shortcutsModel.sort(2);
                }
            }
            ShortcutsOptionPane.this.setFilter();
        }
    }
}

