/*
 * Decompiled with CFR 0.152.
 */
package javajs.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.Lst;
import javajs.util.T3;

public final class AU {
    public static Object ensureLength(Object array, int minimumLength) {
        if (array != null && AU.getLength(array) >= minimumLength) {
            return array;
        }
        return AU.arrayCopyObject(array, minimumLength);
    }

    public static String[] ensureLengthS(String[] array, int minimumLength) {
        if (array != null && array.length >= minimumLength) {
            return array;
        }
        return AU.arrayCopyS(array, minimumLength);
    }

    public static float[] ensureLengthA(float[] array, int minimumLength) {
        if (array != null && array.length >= minimumLength) {
            return array;
        }
        return AU.arrayCopyF(array, minimumLength);
    }

    public static int[] ensureLengthI(int[] array, int minimumLength) {
        if (array != null && array.length >= minimumLength) {
            return array;
        }
        return AU.arrayCopyI(array, minimumLength);
    }

    public static short[] ensureLengthShort(short[] array, int minimumLength) {
        if (array != null && array.length >= minimumLength) {
            return array;
        }
        return AU.arrayCopyShort(array, minimumLength);
    }

    public static byte[] ensureLengthByte(byte[] array, int minimumLength) {
        if (array != null && array.length >= minimumLength) {
            return array;
        }
        return AU.arrayCopyByte(array, minimumLength);
    }

    public static Object doubleLength(Object array) {
        return AU.arrayCopyObject(array, array == null ? 16 : 2 * AU.getLength(array));
    }

    public static String[] doubleLengthS(String[] array) {
        return AU.arrayCopyS(array, array == null ? 16 : 2 * array.length);
    }

    public static float[] doubleLengthF(float[] array) {
        return AU.arrayCopyF(array, array == null ? 16 : 2 * array.length);
    }

    public static int[] doubleLengthI(int[] array) {
        return AU.arrayCopyI(array, array == null ? 16 : 2 * array.length);
    }

    public static short[] doubleLengthShort(short[] array) {
        return AU.arrayCopyShort(array, array == null ? 16 : 2 * array.length);
    }

    public static byte[] doubleLengthByte(byte[] array) {
        return AU.arrayCopyByte(array, array == null ? 16 : 2 * array.length);
    }

    public static boolean[] doubleLengthBool(boolean[] array) {
        return AU.arrayCopyBool(array, array == null ? 16 : 2 * array.length);
    }

    public static Object deleteElements(Object array, int firstElement, int nElements) {
        if (nElements == 0 || array == null) {
            return array;
        }
        int oldLength = AU.getLength(array);
        if (firstElement >= oldLength) {
            return array;
        }
        int n = oldLength - (firstElement + nElements);
        if (n < 0) {
            n = 0;
        }
        Object t = AU.newInstanceO(array, firstElement + n);
        if (firstElement > 0) {
            System.arraycopy(array, 0, t, 0, firstElement);
        }
        if (n > 0) {
            System.arraycopy(array, firstElement + nElements, t, firstElement, n);
        }
        return t;
    }

    public static Object arrayCopyObject(Object array, int newLength) {
        if (array == null) {
            return null;
        }
        int oldLength = AU.getLength(array);
        if (newLength == oldLength) {
            return array;
        }
        Object t = AU.newInstanceO(array, newLength);
        System.arraycopy(array, 0, t, 0, oldLength < newLength ? oldLength : newLength);
        return t;
    }

    private static Object newInstanceO(Object array, int n) {
        if (AU.isAI(array)) {
            return new int[n];
        }
        return Array.newInstance(array.getClass().getComponentType(), n);
    }

    public static int getLength(Object array) {
        return Array.getLength(array);
    }

    public static String[] arrayCopyS(String[] array, int newLength) {
        if (newLength < 0) {
            newLength = array.length;
        }
        String[] t = new String[newLength];
        if (array != null) {
            int oldLength = array.length;
            System.arraycopy(array, 0, t, 0, oldLength < newLength ? oldLength : newLength);
        }
        return t;
    }

    public static int[][] arrayCopyII(int[][] array, int newLength) {
        int[][] t = AU.newInt2(newLength);
        if (array != null) {
            int oldLength = array.length;
            System.arraycopy(array, 0, t, 0, oldLength < newLength ? oldLength : newLength);
        }
        return t;
    }

    public static T3[] arrayCopyPt(T3[] array, int newLength) {
        if (newLength < 0) {
            newLength = array.length;
        }
        T3[] t = new T3[newLength];
        if (array != null) {
            int oldLength = array.length;
            System.arraycopy(array, 0, t, 0, oldLength < newLength ? oldLength : newLength);
        }
        return t;
    }

    public static float[] arrayCopyF(float[] array, int newLength) {
        if (newLength < 0) {
            newLength = array.length;
        }
        float[] t = new float[newLength];
        if (array != null) {
            int oldLength = array.length;
            System.arraycopy(array, 0, t, 0, oldLength < newLength ? oldLength : newLength);
        }
        return t;
    }

    public static int[] arrayCopyI(int[] array, int newLength) {
        if (newLength < 0) {
            newLength = array.length;
        }
        int[] t = new int[newLength];
        if (array != null) {
            int oldLength = array.length;
            System.arraycopy(array, 0, t, 0, oldLength < newLength ? oldLength : newLength);
        }
        return t;
    }

    public static int[] arrayCopyRangeI(int[] array, int i0, int n) {
        if (array == null) {
            return null;
        }
        int oldLength = array.length;
        if (n == -1) {
            n = oldLength;
        }
        if (n == -2) {
            n = oldLength / 2;
        }
        int[] t = new int[n -= i0];
        System.arraycopy(array, i0, t, 0, n);
        return t;
    }

    public static int[] arrayCopyRangeRevI(int[] array, int i0, int n) {
        if (array == null) {
            return null;
        }
        int[] t = AU.arrayCopyRangeI(array, i0, n);
        if (n < 0) {
            n = array.length;
        }
        int i = n / 2;
        while (--i >= 0) {
            AU.swapInt(t, i, n - 1 - i);
        }
        return t;
    }

    public static short[] arrayCopyShort(short[] array, int newLength) {
        if (newLength < 0) {
            newLength = array.length;
        }
        short[] t = new short[newLength];
        if (array != null) {
            int oldLength = array.length;
            System.arraycopy(array, 0, t, 0, oldLength < newLength ? oldLength : newLength);
        }
        return t;
    }

    public static byte[] arrayCopyByte(byte[] array, int newLength) {
        if (newLength < 0) {
            newLength = array.length;
        }
        byte[] t = new byte[newLength];
        if (array != null) {
            int oldLength = array.length;
            System.arraycopy(array, 0, t, 0, oldLength < newLength ? oldLength : newLength);
        }
        return t;
    }

    public static boolean[] arrayCopyBool(boolean[] array, int newLength) {
        if (newLength < 0) {
            newLength = array.length;
        }
        boolean[] t = new boolean[newLength];
        if (array != null) {
            int oldLength = array.length;
            System.arraycopy(array, 0, t, 0, oldLength < newLength ? oldLength : newLength);
        }
        return t;
    }

    public static void swapInt(int[] array, int indexA, int indexB) {
        int t = array[indexA];
        array[indexA] = array[indexB];
        array[indexB] = t;
    }

    public static String dumpArray(String msg, float[][] A, int x1, int x2, int y1, int y2) {
        String s = "dumpArray: " + msg + "\n";
        int x = x1;
        while (x <= x2) {
            s = String.valueOf(s) + "\t*" + x + "*";
            ++x;
        }
        int y = y2;
        while (y >= y1) {
            s = String.valueOf(s) + "\n*" + y + "*";
            int x3 = x1;
            while (x3 <= x2) {
                s = String.valueOf(s) + "\t" + (x3 < A.length && y < A[x3].length ? A[x3][y] : Float.NaN);
                ++x3;
            }
            --y;
        }
        return s;
    }

    public static String dumpIntArray(int[] A, int n) {
        String str = "";
        int i = 0;
        while (i < n) {
            str = String.valueOf(str) + " " + A[i];
            ++i;
        }
        return str;
    }

    public static String sortedItem(Lst<String> v, int n) {
        if (v.size() == 0) {
            return null;
        }
        if (v.size() == 1) {
            return (String)v.get(0);
        }
        Object[] keys = v.toArray(new String[v.size()]);
        Arrays.sort(keys);
        return keys[n % keys.length];
    }

    public static <type> Lst<type>[] createArrayOfArrayList(int size) {
        return new Lst[size];
    }

    public static <K, V> Map<K, V>[] createArrayOfHashtable(int size) {
        return new Hashtable[size];
    }

    public static void swap(Object[] o, int i, int j) {
        Object oi = o[i];
        o[i] = o[j];
        o[j] = oi;
    }

    public static float[][] newFloat2(int n) {
        return new float[n][];
    }

    public static int[][] newInt2(int n) {
        return new int[n][];
    }

    public static int[][][] newInt3(int nx, int ny) {
        return ny < 0 ? new int[nx][][] : (int[][][])new int[nx][ny][];
    }

    public static float[][][] newFloat3(int nx, int ny) {
        return ny < 0 ? new float[nx][][] : (float[][][])new float[nx][ny][];
    }

    public static int[][][][] newInt4(int n) {
        return new int[n][][][];
    }

    public static short[][] newShort2(int n) {
        return new short[n][];
    }

    public static byte[][] newByte2(int n) {
        return new byte[n][];
    }

    public static double[][] newDouble2(int n) {
        return new double[n][];
    }

    public static int removeMapKeys(Map<String, ?> map, String root) {
        Lst<String> list = new Lst<String>();
        for (String key : map.keySet()) {
            if (!key.startsWith(root)) continue;
            list.addLast(key);
        }
        int i = list.size();
        while (--i >= 0) {
            map.remove(list.get(i));
        }
        return list.size();
    }

    public static boolean isAS(Object x) {
        return x instanceof String[];
    }

    public static boolean isASS(Object x) {
        return x instanceof String[][];
    }

    public static boolean isAP(Object x) {
        return x instanceof T3[];
    }

    public static boolean isAF(Object x) {
        return x instanceof float[];
    }

    public static boolean isAFloat(Object x) {
        return x instanceof Float[];
    }

    public static boolean isAD(Object x) {
        return x instanceof double[];
    }

    public static boolean isADD(Object x) {
        return x instanceof double[][];
    }

    public static boolean isAB(Object x) {
        return x instanceof byte[];
    }

    public static boolean isAI(Object x) {
        return x instanceof int[];
    }

    public static boolean isAII(Object x) {
        return x instanceof int[][];
    }

    public static boolean isAFF(Object x) {
        return x instanceof float[][];
    }

    public static boolean isAFFF(Object x) {
        return x instanceof float[][][];
    }

    public static byte[] ensureSignedBytes(byte[] b) {
        if (b != null) {
            // empty if block
        }
        return b;
    }
}

