/*
 * Decompiled with CFR 0.152.
 */
package javajs.img;

import javajs.util.AU;

class JpegObj {
    String comment;
    int imageHeight;
    int imageWidth;
    int[] blockWidth;
    int[] blockHeight;
    int precision = 8;
    int numberOfComponents = 3;
    float[][][] components;
    int[] compID = new int[]{1, 2, 3};
    int[] hsampFactor = new int[]{1, 1, 1};
    int[] vsampFactor = new int[]{1, 1, 1};
    int[] qtableNumber;
    int[] dctableNumber;
    int[] actableNumber;
    private boolean[] lastColumnIsDummy;
    private boolean[] lastRowIsDummy;
    int ss;
    int se;
    int ah;
    int al;
    private int[] compWidth;
    private int[] compHeight;
    private int maxHsampFactor;
    private int maxVsampFactor;

    public JpegObj() {
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 1;
        this.qtableNumber = nArray;
        int[] nArray2 = new int[3];
        nArray2[1] = 1;
        nArray2[2] = 1;
        this.dctableNumber = nArray2;
        int[] nArray3 = new int[3];
        nArray3[1] = 1;
        nArray3[2] = 1;
        this.actableNumber = nArray3;
        this.lastColumnIsDummy = new boolean[3];
        this.lastRowIsDummy = new boolean[3];
        this.ss = 0;
        this.se = 63;
        this.ah = 0;
        this.al = 0;
        this.components = AU.newFloat3(this.numberOfComponents, -1);
        this.compWidth = new int[this.numberOfComponents];
        this.compHeight = new int[this.numberOfComponents];
        this.blockWidth = new int[this.numberOfComponents];
        this.blockHeight = new int[this.numberOfComponents];
    }

    void getYCCArray(int[] pixels) {
        this.maxHsampFactor = 1;
        this.maxVsampFactor = 1;
        int y = 0;
        while (y < this.numberOfComponents) {
            this.maxHsampFactor = Math.max(this.maxHsampFactor, this.hsampFactor[y]);
            this.maxVsampFactor = Math.max(this.maxVsampFactor, this.vsampFactor[y]);
            ++y;
        }
        y = 0;
        while (y < this.numberOfComponents) {
            this.compWidth[y] = (this.imageWidth % 8 != 0 ? (int)Math.ceil((double)this.imageWidth / 8.0) * 8 : this.imageWidth) / this.maxHsampFactor * this.hsampFactor[y];
            if (this.compWidth[y] != this.imageWidth / this.maxHsampFactor * this.hsampFactor[y]) {
                this.lastColumnIsDummy[y] = true;
            }
            this.blockWidth[y] = (int)Math.ceil((double)this.compWidth[y] / 8.0);
            this.compHeight[y] = (this.imageHeight % 8 != 0 ? (int)Math.ceil((double)this.imageHeight / 8.0) * 8 : this.imageHeight) / this.maxVsampFactor * this.vsampFactor[y];
            if (this.compHeight[y] != this.imageHeight / this.maxVsampFactor * this.vsampFactor[y]) {
                this.lastRowIsDummy[y] = true;
            }
            this.blockHeight[y] = (int)Math.ceil((double)this.compHeight[y] / 8.0);
            ++y;
        }
        float[][] Y = new float[this.compHeight[0]][this.compWidth[0]];
        float[][] Cr1 = new float[this.compHeight[0]][this.compWidth[0]];
        float[][] Cb1 = new float[this.compHeight[0]][this.compWidth[0]];
        int pt = 0;
        int y2 = 0;
        while (y2 < this.imageHeight) {
            int x = 0;
            while (x < this.imageWidth) {
                int p = pixels[pt];
                int r = p >> 16 & 0xFF;
                int g = p >> 8 & 0xFF;
                int b = p & 0xFF;
                Y[y2][x] = (float)(0.299 * (double)r + 0.587 * (double)g + 0.114 * (double)b);
                Cb1[y2][x] = 128.0f + (float)(-0.16874 * (double)r - 0.33126 * (double)g + 0.5 * (double)b);
                Cr1[y2][x] = 128.0f + (float)(0.5 * (double)r - 0.41869 * (double)g - 0.08131 * (double)b);
                ++x;
                ++pt;
            }
            ++y2;
        }
        this.components[0] = Y;
        this.components[1] = Cb1;
        this.components[2] = Cr1;
    }
}

