/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.util.Map;
import javajs.util.Lst;
import javajs.util.SB;
import jspecview.api.JSVPanel;
import jspecview.api.JSVTreeNode;
import jspecview.common.PanelData;
import jspecview.common.Parameters;
import jspecview.common.Spectrum;
import jspecview.dialog.JSVDialog;
import jspecview.source.JDXSource;

public class PanelNode {
    public JSVTreeNode treeNode;
    public JDXSource source;
    public String fileName;
    public JSVPanel jsvp;
    public String id;
    public JSVDialog legend;
    public boolean isSelected;
    public boolean isView;
    public boolean isSimulation;
    public String frameTitle;

    public PanelNode(String string, String string2, JDXSource jDXSource, JSVPanel jSVPanel) {
        this.id = string;
        this.source = jDXSource;
        this.fileName = string2;
        this.isSimulation = jDXSource.getFilePath().indexOf("http://SIMULATION/") >= 0;
        this.jsvp = jSVPanel;
        if (jSVPanel != null) {
            this.pd().getSpectrumAt(0).setId(string);
            this.frameTitle = jSVPanel.getTitle();
        }
    }

    public void setTreeNode(JSVTreeNode jSVTreeNode) {
        this.treeNode = jSVTreeNode;
    }

    public Object getTreeNode() {
        return this.treeNode;
    }

    public void dispose() {
        this.source.dispose();
        if (this.jsvp != null) {
            this.jsvp.dispose();
        }
        this.source = null;
        this.jsvp = null;
        this.legend = null;
    }

    public PanelData pd() {
        return this.jsvp.getPanelData();
    }

    public Spectrum getSpectrum() {
        return this.pd().getSpectrum();
    }

    public JSVDialog setLegend(JSVDialog jSVDialog) {
        if (this.legend != null) {
            this.legend.dispose();
        }
        this.legend = jSVDialog;
        return jSVDialog;
    }

    public String toString() {
        return (this.id == null ? "" : this.id + ": ") + (this.frameTitle == null ? this.fileName : this.frameTitle);
    }

    public static JDXSource findSourceByNameOrId(String string, Lst<PanelNode> lst) {
        PanelNode panelNode;
        int n = lst.size();
        while (--n >= 0) {
            panelNode = (PanelNode)lst.get(n);
            if (!string.equals(panelNode.id) && !string.equalsIgnoreCase(panelNode.source.getFilePath())) continue;
            return panelNode.source;
        }
        n = lst.size();
        while (--n >= 0) {
            panelNode = (PanelNode)lst.get(n);
            if (!string.equals(panelNode.fileName)) continue;
            return panelNode.source;
        }
        return null;
    }

    public static PanelNode findNodeById(String string, Lst<PanelNode> lst) {
        if (string != null) {
            int n = lst.size();
            while (--n >= 0) {
                if (!string.equals(((PanelNode)lst.get((int)n)).id) && !string.equals(((PanelNode)lst.get((int)n)).frameTitle)) continue;
                return (PanelNode)lst.get(n);
            }
        }
        return null;
    }

    public static PanelNode findNode(JSVPanel jSVPanel, Lst<PanelNode> lst) {
        int n = lst.size();
        while (--n >= 0) {
            if (((PanelNode)lst.get((int)n)).jsvp != jSVPanel) continue;
            return (PanelNode)lst.get(n);
        }
        return null;
    }

    public static String getSpectrumListAsString(Lst<PanelNode> lst) {
        SB sB = new SB();
        for (int i = 0; i < lst.size(); ++i) {
            PanelNode panelNode = (PanelNode)lst.get(i);
            if (panelNode.isView) continue;
            sB.append(" ").append(panelNode.id);
        }
        return sB.toString().trim();
    }

    public static int isOpen(Lst<PanelNode> lst, String string) {
        int n = -1;
        if (string != null) {
            int n2 = lst.size();
            while (--n2 >= 0) {
                if (!string.equals(((PanelNode)lst.get((int)n2)).source.getFilePath()) && !string.equals(((PanelNode)lst.get((int)n2)).frameTitle)) continue;
                return n;
            }
        }
        return -1;
    }

    public void setFrameTitle(String string) {
        this.frameTitle = string;
    }

    public static JSVPanel getLastFileFirstNode(Lst<PanelNode> lst) {
        int n = lst.size();
        PanelNode panelNode = n == 0 ? null : (PanelNode)lst.get(n - 1);
        int n2 = n - 1;
        while (--n2 >= 0 && ((PanelNode)lst.get((int)n2)).source == panelNode.source) {
            panelNode = (PanelNode)lst.get(n2);
        }
        return panelNode == null ? null : panelNode.jsvp;
    }

    Map<String, Object> getInfo(String string) {
        Map<String, Object> map = this.pd().getInfo(false, string);
        Parameters.putInfo(string, map, "panelId", this.id);
        Parameters.putInfo(string, map, "panelFileName", this.fileName);
        Parameters.putInfo(string, map, "panelSource", this.source.getFilePath());
        return map;
    }
}

