/*
 * Decompiled with CFR 0.152.
 */
package com.sparshui.server;

import com.sparshui.common.Location;
import com.sparshui.server.Group;

public class TouchPoint {
    private int _id;
    private Location _location;
    private int _state;
    private boolean _changed;
    private long _time;
    private Group _group;

    public boolean isClaimed() {
        return this._group != null;
    }

    public TouchPoint(int n, Location location, long l) {
        this._id = n;
        this._location = location;
        this._time = l;
        this._state = 0;
    }

    public TouchPoint(TouchPoint touchPoint) {
        this._id = touchPoint._id;
        this._location = touchPoint._location;
        this._state = touchPoint._state;
        this._time = touchPoint._time;
    }

    public long getTime() {
        return this._time;
    }

    public int getID() {
        return this._id;
    }

    public Location getLocation() {
        return this._location;
    }

    public int getState() {
        return this._state;
    }

    public void setState(int n) {
        this._state = n;
    }

    public void setGroup(Group group) {
        this._group = group;
        this._group.update(this);
    }

    public void update(Location location, long l, int n) {
        this._location = location;
        this._state = n;
        this._changed = true;
        this._time = l;
        if (this._group != null) {
            this._group.update(this);
        }
    }

    public void resetChanged() {
        this._changed = false;
    }

    public boolean isChanged() {
        return this._changed;
    }

    public Object clone() {
        return new TouchPoint(this);
    }

    public boolean isNear(TouchPoint touchPoint) {
        return (double)Math.abs(this._location.getX() - touchPoint._location.getX()) < 0.005 && (double)Math.abs(this._location.getY() - touchPoint._location.getY()) < 0.005;
    }
}

