/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.styleelement;

import java.awt.Font;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.StyledMapRenderer;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.Keyword;
import org.openstreetmap.josm.gui.mappaint.StyleKeys;
import org.openstreetmap.josm.gui.mappaint.mapcss.Instruction;

public abstract class StyleElement
implements StyleKeys {
    protected static final int ICON_IMAGE_IDX = 0;
    protected static final int ICON_WIDTH_IDX = 1;
    protected static final int ICON_HEIGHT_IDX = 2;
    protected static final int ICON_OPACITY_IDX = 3;
    protected static final int ICON_OFFSET_X_IDX = 4;
    protected static final int ICON_OFFSET_Y_IDX = 5;
    protected static final String[] ICON_KEYS = new String[]{"icon-image", "icon-width", "icon-height", "icon-opacity", "icon-offset-x", "icon-offset-y"};
    protected static final String[] REPEAT_IMAGE_KEYS = new String[]{"repeat-image", "repeat-image-width", "repeat-image-height", "repeat-image-opacity", null, null};
    public float majorZIndex;
    public float zIndex;
    public float objectZIndex;
    public boolean isModifier;
    private static volatile String DEFAULT_FONT_NAME;
    private static volatile Float DEFAULT_FONT_SIZE;
    private static final Object lock;
    private static final Map<FontDescriptor, Font> FONT_MAP;

    public StyleElement(float f, float f2, float f3, boolean bl) {
        this.majorZIndex = f;
        this.zIndex = f2;
        this.objectZIndex = f3;
        this.isModifier = bl;
    }

    protected StyleElement(Cascade cascade, float f) {
        this.majorZIndex = cascade.get("major-z-index", Float.valueOf(f), Float.class).floatValue();
        this.zIndex = cascade.get("z-index", Float.valueOf(0.0f), Float.class).floatValue();
        this.objectZIndex = cascade.get("object-z-index", Float.valueOf(0.0f), Float.class).floatValue();
        this.isModifier = cascade.get("modifier", Boolean.FALSE, Boolean.class);
    }

    public abstract void paintPrimitive(OsmPrimitive var1, MapPaintSettings var2, StyledMapRenderer var3, boolean var4, boolean var5, boolean var6);

    public boolean isProperLineStyle() {
        return false;
    }

    protected static Float getWidth(Cascade cascade, String string, Float f) {
        Float f2 = cascade.get(string, null, Float.class, true);
        if (f2 != null) {
            if (f2.floatValue() > 0.0f) {
                return f2;
            }
        } else {
            Instruction.RelativeFloat relativeFloat;
            Keyword keyword = cascade.get(string, null, Keyword.class, true);
            if (Keyword.THINNEST.equals(keyword)) {
                return Float.valueOf(0.0f);
            }
            if (Keyword.DEFAULT.equals(keyword)) {
                return Float.valueOf(MapPaintSettings.INSTANCE.getDefaultSegmentWidth());
            }
            if (f != null && (relativeFloat = cascade.get(string, null, Instruction.RelativeFloat.class, true)) != null) {
                return Float.valueOf(f.floatValue() + relativeFloat.val);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Float getDefaultFontSize() {
        Float f = DEFAULT_FONT_SIZE;
        if (f == null) {
            Object object = lock;
            synchronized (object) {
                f = DEFAULT_FONT_SIZE;
                if (f == null) {
                    DEFAULT_FONT_SIZE = f = Float.valueOf(Main.pref.getInteger("mappaint.fontsize", 8));
                }
            }
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDefaultFontName() {
        String string = DEFAULT_FONT_NAME;
        if (string == null) {
            Object object = lock;
            synchronized (object) {
                string = DEFAULT_FONT_NAME;
                if (string == null) {
                    DEFAULT_FONT_NAME = string = Main.pref.get("mappaint.font", "Droid Sans");
                }
            }
        }
        return string;
    }

    private static Font getCachedFont(FontDescriptor fontDescriptor) {
        Font font = FONT_MAP.get(fontDescriptor);
        if (font != null) {
            return font;
        }
        font = new Font(fontDescriptor.name, fontDescriptor.style, fontDescriptor.size);
        FONT_MAP.put(fontDescriptor, font);
        return font;
    }

    private static Font getCachedFont(String string, int n, int n2) {
        return StyleElement.getCachedFont(new FontDescriptor(string, n, n2));
    }

    protected static Font getFont(Cascade cascade, String string) {
        Font font;
        String string2 = cascade.get("font-family", StyleElement.getDefaultFontName(), String.class);
        float f = cascade.get("font-size", StyleElement.getDefaultFontSize(), Float.class).floatValue();
        int n = 0;
        if ("bold".equalsIgnoreCase(cascade.get("font-weight", null, String.class))) {
            n = 1;
        }
        int n2 = 0;
        if ("italic".equalsIgnoreCase(cascade.get("font-style", null, String.class))) {
            n2 = 2;
        }
        if ((font = StyleElement.getCachedFont(string2, n2 | n, Math.round(f))).canDisplayUpTo(string) == -1) {
            return font;
        }
        return StyleElement.getCachedFont("SansSerif", n2 | n, Math.round(f));
    }

    public boolean equals(Object object) {
        if (!(object instanceof StyleElement)) {
            return false;
        }
        StyleElement styleElement = (StyleElement)object;
        return this.isModifier == styleElement.isModifier && this.majorZIndex == styleElement.majorZIndex && this.zIndex == styleElement.zIndex && this.objectZIndex == styleElement.objectZIndex;
    }

    public int hashCode() {
        int n = 5;
        n = 41 * n + Float.floatToIntBits(this.majorZIndex);
        n = 41 * n + Float.floatToIntBits(this.zIndex);
        n = 41 * n + Float.floatToIntBits(this.objectZIndex);
        n = 41 * n + (this.isModifier ? 1 : 0);
        return n;
    }

    public String toString() {
        return String.format("z_idx=[%s/%s/%s] ", Float.valueOf(this.majorZIndex), Float.valueOf(this.zIndex), Float.valueOf(this.objectZIndex)) + (this.isModifier ? "modifier " : "");
    }

    static {
        lock = new Object();
        FONT_MAP = new HashMap<FontDescriptor, Font>();
    }

    private static class FontDescriptor {
        public String name;
        public int style;
        public int size;

        FontDescriptor(String string, int n, int n2) {
            this.name = string;
            this.style = n;
            this.size = n2;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
            n = 31 * n + this.size;
            n = 31 * n + this.style;
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            FontDescriptor fontDescriptor = (FontDescriptor)object;
            if (this.name == null ? fontDescriptor.name != null : !this.name.equals(fontDescriptor.name)) {
                return false;
            }
            if (this.size != fontDescriptor.size) {
                return false;
            }
            return this.style == fontDescriptor.style;
        }
    }
}

