/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.OutputStream;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.StreamProgressUpdater;
import org.openstreetmap.josm.tools.I18n;

public class ProgressOutputStream
extends OutputStream {
    private final StreamProgressUpdater updater;
    private final OutputStream out;

    public ProgressOutputStream(OutputStream outputStream, long l, ProgressMonitor progressMonitor) {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        this.updater = new StreamProgressUpdater(l, progressMonitor, I18n.tr("Uploading data ...", new Object[0]));
        this.out = outputStream;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
        this.updater.advanceTicker(n2);
    }

    @Override
    public void write(int n) throws IOException {
        this.out.write(n);
        this.updater.advanceTicker(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.out.close();
        }
        finally {
            this.updater.finishTask();
        }
    }
}

