/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.converter;

import de.intarsys.tools.converter.Canonical;
import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.converter.ConverterRegistry;
import de.intarsys.tools.converter.DoubleDispatchConverter;
import de.intarsys.tools.converter.IConverter;
import de.intarsys.tools.converter.IConverterRegistry;
import de.intarsys.tools.converter.PACKAGE;
import de.intarsys.tools.provider.Providers;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StandardConverterRegistry
implements IConverterRegistry {
    private static final Logger Log = PACKAGE.Log;
    private final Map<Class, IConverter> converters = new HashMap<Class, IConverter>();
    private boolean initialized = false;
    private boolean lookupProviders = true;

    public Object convert(Object object, Class clazz) throws ConversionException {
        if (object == null) {
            return null;
        }
        if (clazz == Object.class) {
            return object;
        }
        if (clazz.isInstance(object)) {
            return object;
        }
        IConverter iConverter = this.lookupConverter(clazz);
        if (iConverter == null) {
            Canonical canonical = ConverterRegistry.get().convert(object, Canonical.class);
            if (canonical == object) {
                throw new ConversionException("can't convert " + object.getClass().getName() + " to " + clazz);
            }
            try {
                return ConverterRegistry.get().convert(canonical, clazz);
            }
            catch (ConversionException conversionException) {
                throw new ConversionException("can't convert " + object.getClass().getName() + " to " + clazz, conversionException);
            }
        }
        return iConverter.convert(object);
    }

    protected Iterator<IConverter> findProviders() {
        return Providers.get().lookupProviders(IConverter.class);
    }

    protected void init() {
        if (!this.isLookupProviders() || this.initialized) {
            return;
        }
        this.initialized = true;
        Iterator<IConverter> iterator = this.findProviders();
        while (iterator.hasNext()) {
            try {
                this.registerConverter(iterator.next());
            }
            catch (Throwable throwable) {
                Log.log(Level.WARNING, "error creating converter", throwable);
            }
        }
    }

    public boolean isLookupProviders() {
        return this.lookupProviders;
    }

    @Override
    public synchronized IConverter lookupConverter(Class clazz) {
        this.init();
        return this.converters.get(clazz);
    }

    @Override
    public synchronized void registerConverter(IConverter iConverter) {
        IConverter iConverter2 = this.converters.get(iConverter.getTargetType());
        if (iConverter2 == null) {
            iConverter2 = new DoubleDispatchConverter(iConverter.getTargetType());
            ((DoubleDispatchConverter)iConverter2).registerConverter(iConverter);
            this.converters.put(iConverter2.getTargetType(), iConverter2);
        } else {
            ((DoubleDispatchConverter)iConverter2).registerConverter(iConverter);
        }
    }

    public void setLookupProviders(boolean bl) {
        this.lookupProviders = bl;
    }

    @Override
    public synchronized void unregisterConverter(IConverter iConverter) {
        IConverter iConverter2 = this.converters.get(iConverter.getTargetType());
        if (iConverter2 != null) {
            ((DoubleDispatchConverter)iConverter2).unregisterConverter(iConverter);
        }
    }
}

