/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.st;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSIndirectObject;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSNumber;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.parser.COSDocumentParser;
import de.intarsys.pdf.parser.COSLoadException;
import de.intarsys.pdf.st.AbstractXRefParser;
import de.intarsys.pdf.st.STDocument;
import de.intarsys.pdf.st.STStreamXRefSection;
import de.intarsys.pdf.st.STXRefEntry;
import de.intarsys.pdf.st.STXRefEntryCompressed;
import de.intarsys.pdf.st.STXRefEntryFree;
import de.intarsys.pdf.st.STXRefEntryOccupied;
import de.intarsys.pdf.st.STXRefSection;
import de.intarsys.tools.randomaccess.IRandomAccess;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Iterator;

public class XRefStreamParser
extends AbstractXRefParser {
    private int[] wSizeDefault = new int[]{1, 2, 1};
    private int[] wSize;
    private ByteArrayInputStream in;

    public XRefStreamParser(STDocument sTDocument, COSDocumentParser cOSDocumentParser) {
        super(sTDocument, cOSDocumentParser);
    }

    private void initWBytes(STStreamXRefSection sTStreamXRefSection) {
        COSArray cOSArray = sTStreamXRefSection.getW();
        if (cOSArray == null) {
            this.wSize = this.wSizeDefault;
            return;
        }
        this.wSize = new int[3];
        int n = 0;
        while (n < cOSArray.size()) {
            this.wSize[n] = ((COSInteger)cOSArray.get(n)).intValue();
            ++n;
        }
        n = cOSArray.size();
        while (n < 3) {
            this.wSize[n] = 0;
            ++n;
        }
    }

    protected void loadPrevious(IRandomAccess iRandomAccess, STXRefSection sTXRefSection) throws IOException, COSLoadException {
        int n = sTXRefSection.getPreviousOffset();
        if (n != -1) {
            XRefStreamParser xRefStreamParser = new XRefStreamParser(this.getDoc(), this.getParser());
            iRandomAccess.seek((long)n);
            STXRefSection sTXRefSection2 = ((AbstractXRefParser)xRefStreamParser).parse(iRandomAccess);
            sTXRefSection.setPrevious(sTXRefSection2);
        }
    }

    @Override
    public STXRefSection parse(IRandomAccess iRandomAccess) throws IOException, COSLoadException {
        STXRefSection sTXRefSection = this.parseXRef(iRandomAccess);
        this.loadPrevious(iRandomAccess, sTXRefSection);
        return sTXRefSection;
    }

    private void parseStreamContent(STStreamXRefSection sTStreamXRefSection) throws IOException {
        this.initWBytes(sTStreamXRefSection);
        this.in = new ByteArrayInputStream(sTStreamXRefSection.cosGetStream().getDecodedBytes());
        COSArray cOSArray = sTStreamXRefSection.getIndex();
        Iterator iterator = cOSArray.iterator();
        while (iterator.hasNext()) {
            COSNumber cOSNumber = ((COSObject)iterator.next()).asNumber();
            if (!iterator.hasNext()) continue;
            COSNumber cOSNumber2 = ((COSObject)iterator.next()).asNumber();
            if (cOSNumber == null || cOSNumber2 == null) continue;
            int n = cOSNumber.intValue();
            int n2 = cOSNumber2.intValue();
            int n3 = 0;
            while (n3 < n2) {
                int n4 = this.readType(this.in);
                switch (n4) {
                    case 0: {
                        sTStreamXRefSection.addEntry(this.parseType0(this.in, n + n3));
                        break;
                    }
                    case 1: {
                        sTStreamXRefSection.addEntry(this.parseType1(this.in, n + n3));
                        break;
                    }
                    case 2: {
                        sTStreamXRefSection.addEntry(this.parseType2(this.in, n + n3));
                        break;
                    }
                    default: {
                        this.parseTypeUnknown(this.in);
                    }
                }
                ++n3;
            }
        }
    }

    private STXRefEntry parseType0(ByteArrayInputStream byteArrayInputStream, int n) {
        int n2 = this.read(byteArrayInputStream, this.wSize[1], -1);
        int n3 = this.read(byteArrayInputStream, this.wSize[2], -1);
        return new STXRefEntryFree(n, n3, n2);
    }

    private STXRefEntry parseType1(ByteArrayInputStream byteArrayInputStream, int n) {
        int n2 = this.read(byteArrayInputStream, this.wSize[1], -1);
        int n3 = this.read(byteArrayInputStream, this.wSize[2], 0);
        return new STXRefEntryOccupied(n, n3, n2);
    }

    private STXRefEntry parseType2(ByteArrayInputStream byteArrayInputStream, int n) {
        int n2 = this.read(byteArrayInputStream, this.wSize[1], -1);
        int n3 = this.read(byteArrayInputStream, this.wSize[2], 0);
        return new STXRefEntryCompressed(n, 0, n2, 0, n3);
    }

    private void parseTypeUnknown(ByteArrayInputStream byteArrayInputStream) {
        this.read(byteArrayInputStream, this.wSize[1], -1);
        this.read(byteArrayInputStream, this.wSize[1], -1);
    }

    protected STXRefSection parseXRef(IRandomAccess iRandomAccess) throws IOException, COSLoadException {
        long l = iRandomAccess.getOffset();
        COSStream cOSStream = (COSStream)this.getDoc().getParser().parseIndirectObject(iRandomAccess, null);
        ((COSIndirectObject)cOSStream.containable()).setDirty(false);
        STStreamXRefSection sTStreamXRefSection = new STStreamXRefSection(this.getDoc(), l, cOSStream);
        this.parseStreamContent(sTStreamXRefSection);
        return sTStreamXRefSection;
    }

    private int read(ByteArrayInputStream byteArrayInputStream, int n, int n2) {
        if (n == 0) {
            return n2;
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            n3 <<= 8;
            n3 += byteArrayInputStream.read();
            ++n4;
        }
        return n3;
    }

    private int readType(ByteArrayInputStream byteArrayInputStream) {
        return this.read(byteArrayInputStream, this.wSize[0], 1);
    }
}

