/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.color.awt;

import de.intarsys.pdf.pd.PDCSDeviceRGB;
import de.intarsys.pdf.pd.PDCSIndexed;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.pdf.platform.cwt.color.awt.AwtCSSpecial;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;

public class AwtCSIndexed
extends AwtCSSpecial {
    public AwtCSIndexed(PDColorSpace pDColorSpace) {
        super(pDColorSpace);
    }

    @Override
    protected ColorSpace createColorSpace() {
        throw new UnsupportedOperationException();
    }

    protected int[] extractIntRGBS(int n) {
        if (this.myPDColorSpace().getBaseColorSpace() instanceof PDCSDeviceRGB) {
            return this.extractIntRGBsDirect(n);
        }
        return this.extractIntRGBsOther(n);
    }

    protected int[] extractIntRGBsDirect(int n) {
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = 0xFF000000 | this.myPDColorSpace().getColorBytes()[n2 * 3] << 16 & 0xFF0000 | this.myPDColorSpace().getColorBytes()[n2 * 3 + 1] << 8 & 0xFF00 | this.myPDColorSpace().getColorBytes()[n2 * 3 + 2] & 0xFF;
            ++n2;
        }
        return nArray;
    }

    protected int[] extractIntRGBsOther(int n) {
        ColorSpace colorSpace = AwtCSIndexed.getColorSpace(this.myPDColorSpace().getBaseColorSpace()).getColorSpace();
        int n2 = colorSpace.getNumComponents();
        int[] nArray = new int[n];
        int n3 = 0;
        while (n3 < n) {
            float[] fArray = new float[n2];
            int n4 = 0;
            while (n4 < n2) {
                fArray[n4] = (float)(0xFF & this.myPDColorSpace().getColorBytes()[n3 * n2 + n4]) / 255.0f;
                ++n4;
            }
            float[] fArray2 = colorSpace.toRGB(fArray);
            nArray[n3] = 0xFF000000 | (int)(fArray2[0] * 255.0f) << 16 | (int)(fArray2[1] * 255.0f) << 8 & 0xFF00 | (int)(fArray2[2] * 255.0f) & 0xFF;
            ++n3;
        }
        return nArray;
    }

    @Override
    public ColorModel getColorModel(PDImage pDImage) {
        int n = pDImage.getBitsPerComponent();
        int n2 = 1 << n;
        if (this.myPDColorSpace().getColorCount() < n2) {
            n2 = this.myPDColorSpace().getColorCount();
        }
        return new IndexColorModel(n, n2, this.extractIntRGBS(n2), 0, false, -1, 0);
    }

    @Override
    public int getNumComponents() {
        return 1;
    }

    @Override
    public float[] getRGB(float[] fArray) {
        float[] fArray2 = new float[AwtCSIndexed.getColorSpace(this.myPDColorSpace().getBaseColorSpace()).getNumComponents()];
        int n = 0;
        while (n < fArray2.length) {
            fArray2[n] = (float)(this.myPDColorSpace().getColorBytes()[(int)fArray[0] * AwtCSIndexed.getColorSpace(this.myPDColorSpace().getBaseColorSpace()).getNumComponents() + n] & 0xFF) / 255.0f;
            ++n;
        }
        return AwtCSIndexed.getColorSpace(this.myPDColorSpace().getBaseColorSpace()).getRGB(fArray2);
    }

    protected PDCSIndexed myPDColorSpace() {
        return (PDCSIndexed)this.getPDColorSpace();
    }
}

