/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.plugin.merge.listeners;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.LinkedList;
import java.util.ResourceBundle;
import javax.swing.JTextField;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.pdfsam.console.utils.ValidationUtility;
import org.pdfsam.guiclient.business.listeners.AbstractRunButtonActionListener;
import org.pdfsam.guiclient.commons.business.SoundPlayer;
import org.pdfsam.guiclient.commons.business.WorkExecutor;
import org.pdfsam.guiclient.commons.business.WorkThread;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.guiclient.dto.PdfSelectionTableItem;
import org.pdfsam.guiclient.dto.StringItem;
import org.pdfsam.guiclient.utils.DialogUtility;
import org.pdfsam.i18n.GettextResource;
import org.pdfsam.plugin.merge.GUI.MergeMainGUI;

public class RunButtonActionListener
extends AbstractRunButtonActionListener {
    private static final Logger log = Logger.getLogger((String)RunButtonActionListener.class.getPackage().getName());
    private MergeMainGUI panel;

    public RunButtonActionListener(MergeMainGUI panel) {
        this.panel = panel;
    }

    public void actionPerformed(ActionEvent arg0) {
        if (WorkExecutor.getInstance().getRunningThreads() > 0 || this.panel.getSelectionPanel().isAdding()) {
            DialogUtility.showWarningAddingDocument((Component)((Object)this.panel));
            return;
        }
        Object[] items = this.panel.getSelectionPanel().getTableRows();
        if (ArrayUtils.isEmpty((Object[])items)) {
            DialogUtility.showWarningNoDocsSelected((Component)((Object)this.panel), (int)0);
            return;
        }
        if (StringUtils.isEmpty((String)this.panel.getDestinationTextField().getText())) {
            DialogUtility.showWarningNoDestinationSelected((Component)((Object)this.panel), (int)0);
            return;
        }
        LinkedList<String> args = new LinkedList<String>();
        try {
            String destination;
            File destFile;
            if (this.panel.getOverwriteCheckbox().isSelected() && Configuration.getInstance().isAskOverwriteConfirmation()) {
                int dialogRet = DialogUtility.askForOverwriteConfirmation((Component)((Object)this.panel));
                if (1 == dialogRet) {
                    this.panel.getOverwriteCheckbox().setSelected(false);
                } else if (2 == dialogRet) {
                    return;
                }
            }
            RunButtonActionListener.ensurePdfExtensionOnTextField((JTextField)this.panel.getDestinationTextField());
            File destinationDir = new File(this.panel.getDestinationTextField().getText());
            File parent = destinationDir.getParentFile();
            if (parent == null || !parent.exists()) {
                String suggestedDir = this.getSuggestedOutputFile((PdfSelectionTableItem)items[items.length - 1], destinationDir.getName());
                int chosenOpt = DialogUtility.showConfirmOuputLocationDialog((Component)((Object)this.panel), (String)suggestedDir);
                if (0 == chosenOpt) {
                    this.panel.getDestinationTextField().setText(suggestedDir);
                } else if (2 == chosenOpt) {
                    return;
                }
            }
            File file = destFile = (destination = this.panel.getDestinationTextField().getText()) != null ? new File(destination) : null;
            if (destFile != null && destFile.exists() && !this.panel.getOverwriteCheckbox().isSelected()) {
                int chosenOpt = DialogUtility.askForOverwriteOutputFileDialog((Component)((Object)this.panel), (String)destFile.getName());
                if (0 == chosenOpt) {
                    this.panel.getOverwriteCheckbox().setSelected(true);
                } else if (2 == chosenOpt) {
                    return;
                }
            }
            args.add("-o");
            args.add(destination);
            StringBuilder psStringBuilder = new StringBuilder();
            for (Object item : items) {
                String pageSelection = !StringUtils.isEmpty((String)item.getPageSelection()) ? item.getPageSelection() : "All";
                String[] selections = StringUtils.split((String)pageSelection, (String)",");
                if (!ValidationUtility.isValidPageSelectionsArray((String[])selections)) {
                    DialogUtility.errorValidatingBounds((Component)((Object)this.panel), (String)pageSelection);
                    return;
                }
                args.add("-f");
                String f = item.getInputFile().getAbsolutePath();
                if (!StringUtils.isEmpty((String)item.getPassword())) {
                    log.debug((Object)GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Found a password for input file."));
                    f = f + ":" + item.getPassword();
                }
                args.add(f);
                psStringBuilder.append(pageSelection).append(":");
            }
            args.add("-u");
            args.add(psStringBuilder.toString());
            if (this.panel.getOverwriteCheckbox().isSelected()) {
                args.add("-overwrite");
            }
            if (this.panel.getOutputCompressedCheck().isSelected()) {
                args.add("-compressed");
            }
            if (this.panel.getMergeTypeCheck().isSelected()) {
                args.add("-copyfields");
            }
            args.add("-pdfversion");
            args.add(((StringItem)this.panel.getVersionCombo().getSelectedItem()).getId());
            args.add("concat");
            String[] myStringArray = args.toArray(new String[args.size()]);
            WorkExecutor.getInstance().execute((Runnable)new WorkThread(myStringArray));
        }
        catch (Exception ex) {
            log.error((Object)GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Error: "), (Throwable)ex);
            SoundPlayer.getInstance().playErrorSound();
        }
    }
}

