/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.commons.components;

import java.awt.Insets;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import org.pdfsam.guiclient.commons.components.DefaultPopupMenu;
import org.pdfsam.guiclient.commons.components.PrefixPopupMenu;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.i18n.GettextResource;

public class CommonComponentsFactory {
    public static final int SIMPLE_TEXT_FIELD_TYPE = 0;
    public static final int DESTINATION_TEXT_FIELD_TYPE = 1;
    public static final int PREFIX_TEXT_FIELD_TYPE = 2;
    public static final int PREFIX_TEXT_FIELD_TYPE_FULL_MENU = 3;
    public static final int RUN_BUTTON_TYPE = 1;
    public static final int BROWSE_BUTTON_TYPE = 2;
    public static final int ADD_BUTTON_TYPE = 3;
    public static final int OVERWRITE_CHECKBOX_TYPE = 1;
    public static final int COMPRESS_CHECKBOX_TYPE = 2;
    public static final int DONT_PRESERVER_ORDER_CHECKBOX_TYPE = 3;
    public static final int PDF_VERSION_LABEL = 1;
    private static CommonComponentsFactory instance = null;
    private Configuration config = Configuration.getInstance();

    private CommonComponentsFactory() {
    }

    public static synchronized CommonComponentsFactory getInstance() {
        if (instance == null) {
            instance = new CommonComponentsFactory();
        }
        return instance;
    }

    public synchronized JButton createButton(int buttonType) {
        JButton retVal = new JButton();
        switch (buttonType) {
            case 1: {
                retVal.setMargin(new Insets(2, 2, 2, 2));
                retVal.setIcon(new ImageIcon(this.getClass().getResource("/images/run.png")));
                retVal.setText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Run"));
                break;
            }
            case 2: {
                retVal.setMargin(new Insets(2, 2, 2, 2));
                retVal.setIcon(new ImageIcon(this.getClass().getResource("/images/browse.png")));
                retVal.setText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Browse"));
                break;
            }
            case 3: {
                retVal.setMargin(new Insets(2, 2, 2, 2));
                retVal.setIcon(new ImageIcon(this.getClass().getResource("/images/add.png")));
                retVal.setText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Add"));
                break;
            }
        }
        return retVal;
    }

    public synchronized JCheckBox createCheckBox(int checkboxType) {
        JCheckBox retVal = new JCheckBox();
        switch (checkboxType) {
            case 2: {
                retVal.setText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Compress output file/files"));
                retVal.setToolTipText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Pdf version required:") + " 1.5");
                break;
            }
            case 1: {
                retVal.setText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Overwrite if already exists"));
                retVal.setSelected(true);
                break;
            }
            case 3: {
                retVal.setText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Don't preserve file order (fast load)"));
                break;
            }
        }
        return retVal;
    }

    public synchronized JLabel createLabel(int labelType) {
        JLabel retVal = new JLabel();
        switch (labelType) {
            case 1: {
                retVal.setText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Output document pdf version:"));
                break;
            }
        }
        return retVal;
    }

    public synchronized JTextField createTextField(int textFieldType) {
        JTextField retVal = new JTextField();
        retVal.setBorder(new EtchedBorder(1));
        switch (textFieldType) {
            case 0: 
            case 1: {
                retVal.setComponentPopupMenu(new DefaultPopupMenu());
                break;
            }
            case 2: {
                retVal.setComponentPopupMenu(new PrefixPopupMenu(0, retVal));
                retVal.setText("pdfsam_");
                break;
            }
            case 3: {
                retVal.setComponentPopupMenu(new PrefixPopupMenu(1, retVal));
                retVal.setText("pdfsam_");
                break;
            }
        }
        return retVal;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("Cannot clone ComponentFactory object.");
    }
}

