/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.common;

import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationUtils;
import org.apache.commons.configuration.FileConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.log4j.Logger;
import org.zaproxy.zap.control.ControlOverrides;
import org.zaproxy.zap.utils.ZapXmlConfiguration;

public abstract class AbstractParam {
    private static final Logger logger = Logger.getLogger(AbstractParam.class);
    private FileConfiguration config = null;

    public void load(FileConfiguration fileConfiguration) {
        this.config = fileConfiguration;
        try {
            this.parse();
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    public void load(String string) {
        this.load(string, null);
    }

    public void load(String string, ControlOverrides controlOverrides) {
        try {
            this.config = new ZapXmlConfiguration(string);
            if (controlOverrides != null) {
                for (Map.Entry<String, String> entry : controlOverrides.getConfigs().entrySet()) {
                    logger.info((Object)("Setting config " + entry.getKey() + " = " + entry.getValue() + " was " + this.config.getString(entry.getKey())));
                    this.config.setProperty(entry.getKey(), (Object)entry.getValue());
                }
            }
            this.parse();
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public AbstractParam clone() {
        try {
            AbstractParam abstractParam = (AbstractParam)this.getClass().newInstance();
            XMLConfiguration xMLConfiguration = new XMLConfiguration();
            ConfigurationUtils.copy((Configuration)this.getConfig(), (Configuration)xMLConfiguration);
            abstractParam.load((FileConfiguration)xMLConfiguration);
            return abstractParam;
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    protected abstract void parse();
}

