/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.parosproxy.paros.core.scanner.NameValuePair;
import org.parosproxy.paros.core.scanner.Variant;
import org.parosproxy.paros.core.scanner.VariantODataFilterQuery;
import org.parosproxy.paros.core.scanner.VariantODataIdQuery;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpRequestHeader;

public class VariantODataUnitTest {
    private static final Variant VARIANT_ODATA_ID_QUERY = new VariantODataIdQuery();
    private static final Variant VARIANT_ODATA_FILTER_QUERY = new VariantODataFilterQuery();

    @Test
    public void shouldAbleToInjectValueInODataSimpleResourceID() throws URIException, NullPointerException, CloneNotSupportedException {
        this.doTestInjectParameter(VARIANT_ODATA_ID_QUERY, new URI("http", null, "localhost", 50050, "/remoting/servlet.svc/Book('BOOK1')/Summary", "%24format=json"), "__ID__Book", "'BOOK1'", "'hacked'", "http://localhost:50050/remoting/servlet.svc/Book('hacked')/Summary?%24format=json");
    }

    @Test
    public void shouldAbleToInjectValueInODataCompositeResourceID() throws URIException, NullPointerException, CloneNotSupportedException {
        this.doTestInjectParameter(VARIANT_ODATA_ID_QUERY, new URI("http", null, "localhost", 50050, "/remoting/servlet.svc/DisplayItem(seqno=576460752035250185L,table='B0A43AEFE9A9FA0441AFE5302EF534A707CF0834F87A6EA884FB425A1C996EB1CA699ADDD2B48F13')"), "seqno", "576460752035250185L", "hacked", "http://localhost:50050/remoting/servlet.svc/DisplayItem(seqno=hacked,table='B0A43AEFE9A9FA0441AFE5302EF534A707CF0834F87A6EA884FB425A1C996EB1CA699ADDD2B48F13')");
    }

    @Test
    public void shouldAbleToInjectValueInODataCompositeResourceID2() throws URIException, NullPointerException, CloneNotSupportedException {
        this.doTestInjectParameter(VARIANT_ODATA_ID_QUERY, new URI("http", null, "localhost", 50050, "/remoting/servlet.svc/DisplayItem(seqno=576460752035250185L,table='B0A43AEFE9A9FA0441AFE5302EF534A707CF0834F87A6EA884FB425A1C996EB1CA699ADDD2B48F13')"), "table", "'B0A43AEFE9A9FA0441AFE5302EF534A707CF0834F87A6EA884FB425A1C996EB1CA699ADDD2B48F13'", "hacked", "http://localhost:50050/remoting/servlet.svc/DisplayItem(seqno=576460752035250185L,table=hacked)");
    }

    @Test
    public void shouldBeAbleToInjectValueInODataFilterParameters() throws URIException, NullPointerException, CloneNotSupportedException {
        this.doTestInjectParameter(VARIANT_ODATA_FILTER_QUERY, new URI("http", null, "localhost", 15050, "/remoting/servlet.svc/Book", "$top=3&$select=name&$filter=(p1 eq 5) and (param2 gt 6) and startswith(code,'Once')$format=json"), "p1", "5", "hacked", "http://localhost:15050/remoting/servlet.svc/Book?$top=3&$select=name&$filter=(p1 eq hacked) and (param2 gt 6) and startswith(code,'Once')$format=json");
    }

    @Test
    public void shouldBeAbleToInjectValueInODataFilterParametersHavingBlanksNearEquals1() throws URIException, NullPointerException, CloneNotSupportedException {
        this.doTestInjectParameter(VARIANT_ODATA_FILTER_QUERY, new URI("http", null, "localhost", 15050, "/remoting/servlet.svc/Book", "$top=3&$select=name&$filter =(p1 eq 5) and (param2 gt 6) and startswith(code,'Once')$format=json"), "param2", "6", "hacked", "http://localhost:15050/remoting/servlet.svc/Book?$top=3&$select=name&$filter =(p1 eq 5) and (param2 gt hacked) and startswith(code,'Once')$format=json");
    }

    @Test
    public void shouldBeAbleToInjectValueInODataFilterParametersHavingBlanksNearEquals2() throws URIException, NullPointerException, CloneNotSupportedException {
        this.doTestInjectParameter(VARIANT_ODATA_FILTER_QUERY, new URI("http", null, "localhost", 15050, "/remoting/servlet.svc/Book", "$top=3&$select=name&$filter = (p1 eq 5) and (param2 gt 6) and startswith(code,'Once')$format=json"), "param2", "6", "hacked", "http://localhost:15050/remoting/servlet.svc/Book?$top=3&$select=name&$filter = (p1 eq 5) and (param2 gt hacked) and startswith(code,'Once')$format=json");
    }

    @Test
    public void shouldBeAbleToInjectValueInODataFilterParametersHavingBlanksNearEquals3() throws URIException, NullPointerException, CloneNotSupportedException {
        this.doTestInjectParameter(VARIANT_ODATA_FILTER_QUERY, new URI("http", null, "localhost", 15050, "/remoting/servlet.svc/Book", "$top=3&$select=name&$filter= (p1 eq 5) and (param2 gt 6) and startswith(code,'Once')$format=json"), "param2", "6", "hacked", "http://localhost:15050/remoting/servlet.svc/Book?$top=3&$select=name&$filter= (p1 eq 5) and (param2 gt hacked) and startswith(code,'Once')$format=json");
    }

    @Test
    public void shouldBeAbleToHandleURIwithoutQuery() throws URIException, NullPointerException, CloneNotSupportedException {
        URI uRI = new URI("http", null, "localhost", 15050, "/remoting/servlet.svc/Book");
        this.doTestInjectParameter(VARIANT_ODATA_FILTER_QUERY, uRI, "param2", "6", "hacked", "http://localhost:15050/remoting/servlet.svc/Book");
    }

    @Test
    public void shouldBeAbleToHandleURIwithoutPath() throws URIException, NullPointerException, CloneNotSupportedException {
        URI uRI = new URI("http", null, "localhost", 15050);
        this.doTestInjectParameter(VARIANT_ODATA_ID_QUERY, uRI, "param2", "6", "hacked", "http://localhost:15050");
    }

    protected String setParameter(HttpMessage httpMessage, String string, String string2, Variant variant, NameValuePair nameValuePair) {
        return variant.setParameter(httpMessage, nameValuePair, string, string2);
    }

    private void doTestInjectParameter(Variant variant, URI uRI, String string, String string2, String string3, String string4) throws URIException, NullPointerException, CloneNotSupportedException {
        HttpMessage httpMessage = new HttpMessage();
        httpMessage.setRequestHeader(new HttpRequestHeader());
        NameValuePair nameValuePair = new NameValuePair(16, string, string2, 1);
        httpMessage.getRequestHeader().setURI((URI)uRI.clone());
        variant.setMessage(httpMessage);
        String string5 = nameValuePair.getName();
        this.setParameter(httpMessage, string5, string3, variant, nameValuePair);
        URI uRI2 = httpMessage.getRequestHeader().getURI();
        String string6 = uRI2.getURI();
        Assert.assertThat((String)"RequestHeader.uri", (Object)string6, (Matcher)Matchers.is((Object)string4));
    }
}

