/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.zaproxy.zap.Version;

public class VersionUnitTest {
    private static final String VALID_VERSION = "1.0.0";

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionIfVersionIsNull() {
        String string = null;
        new Version(string);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionIfVersionIsEmpty() {
        String string = "";
        new Version(string);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAcceptVersionWithOnlyMajorVersion() {
        String string = "1";
        new Version(string);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAcceptVersionWithOnlyMajorAndMinorVersion() {
        String string = "1.0";
        new Version(string);
    }

    @Test
    public void shouldAcceptVersionWithMajorMinorAndPatchNumbers() {
        String string = VALID_VERSION;
        new Version(string);
    }

    @Test
    public void shouldReturnTrueWhenEqualingToTheSameVersionNumber() {
        Version version = new Version(VALID_VERSION);
        Version version2 = new Version(VALID_VERSION);
        boolean bl = version.equals(version2);
        Assert.assertThat((Object)bl, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)true)));
    }

    @Test
    public void shouldReturnFalseWhenEqualingToDifferntVersionNumbers() {
        Version version = new Version(VALID_VERSION);
        Version version2 = new Version("2.0.0");
        boolean bl = version.equals(version2);
        Assert.assertThat((Object)bl, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)false)));
    }

    @Test
    public void shouldReturnPositiveNumberWhenComparingToOlderPatchVersion() {
        Version version = new Version("2.0.1");
        Version version2 = new Version("2.0.0");
        int n = version.compareTo(version2);
        Assert.assertThat((Object)n, (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
    }

    @Test
    public void shouldReturnPositiveNumberWhenComparingToOlderMinorVersion() {
        Version version = new Version("2.1.0");
        Version version2 = new Version("2.0.0");
        int n = version.compareTo(version2);
        Assert.assertThat((Object)n, (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
    }

    @Test
    public void shouldReturnPositiveNumberWhenComparingToOlderMajorVersion() {
        Version version = new Version("3.0.0");
        Version version2 = new Version("2.0.0");
        int n = version.compareTo(version2);
        Assert.assertThat((Object)n, (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
    }

    @Test
    public void shouldReturnZeroWhenComparingToEqualVersion() {
        Version version = new Version(VALID_VERSION);
        Version version2 = new Version(VALID_VERSION);
        int n = version.compareTo(version2);
        Assert.assertThat((Object)n, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0)));
    }

    @Test
    public void shouldReturnNegativeNumberWhenComparingToNewerPatchVersion() {
        Version version = new Version(VALID_VERSION);
        Version version2 = new Version("1.0.1");
        int n = version.compareTo(version2);
        Assert.assertThat((Object)n, (Matcher)Matchers.is((Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0))));
    }

    @Test
    public void shouldReturnNegativeNumberWhenComparingToNewerMinorVersion() {
        Version version = new Version(VALID_VERSION);
        Version version2 = new Version("1.1.0");
        int n = version.compareTo(version2);
        Assert.assertThat((Object)n, (Matcher)Matchers.is((Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0))));
    }

    @Test
    public void shouldReturnNegativeNumberWhenComparingToNewerMajorVersion() {
        Version version = new Version(VALID_VERSION);
        Version version2 = new Version("2.0.0");
        int n = version.compareTo(version2);
        Assert.assertThat((Object)n, (Matcher)Matchers.is((Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0))));
    }

    @Test
    public void shouldMatchExactVersion() {
        Version version = new Version("1.2.3");
        String string = "1.2.3";
        boolean bl = version.matches(string);
        Assert.assertThat((Object)bl, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)true)));
    }

    @Test
    public void shouldMatchMinorWildcardedVersionWithEqualMajorVersion() {
        Version version = new Version(VALID_VERSION);
        String string = "1.*";
        boolean bl = version.matches(string);
        Assert.assertThat((Object)bl, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)true)));
    }

    @Test
    public void shouldMatchMinorWildcardedVersionWithEqualMajorVersionAndDifferentMinorVersion() {
        Version version = new Version("1.5.0");
        String string = "1.*";
        boolean bl = version.matches(string);
        Assert.assertThat((Object)bl, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)true)));
    }

    @Test
    public void shouldMatchMinorWildcardedVersionWithEqualMajorVersionAndDifferentPatchVersion() {
        Version version = new Version("1.0.4");
        String string = "1.*";
        boolean bl = version.matches(string);
        Assert.assertThat((Object)bl, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)true)));
    }

    @Test
    public void shouldMatchMinorWildcardedVersionWithEqualMajorVersionAndDifferentMinorAndPatchVersion() {
        Version version = new Version("1.9.3");
        String string = "1.*";
        boolean bl = version.matches(string);
        Assert.assertThat((Object)bl, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)true)));
    }

    @Test
    public void shouldNotMatchMinorWildcardedVersionWithGreaterMajorVersion() {
        Version version = new Version("2.0.0");
        String string = "1.*";
        boolean bl = version.matches(string);
        Assert.assertThat((Object)bl, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)false)));
    }

    @Test
    public void shouldReturnVersionAsString() {
        Version version = new Version("1.2.3");
        String string = version.toString();
        Assert.assertThat((Object)string, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"1.2.3")));
    }
}

