/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.view.posttable;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;

public class RequestPostTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -3239987476977015394L;
    private static final String[] columnNames = new String[]{Constant.messages.getString("http.panel.view.table.paramName"), Constant.messages.getString("http.panel.view.table.paramValue")};
    private static final Pattern pSeparator = Pattern.compile("([^=&]+)[=]([^=&]*)");
    private Vector<String[]> listPair = new Vector();
    private boolean editable = true;
    private boolean isChanged = false;
    private static final Logger logger = Logger.getLogger(RequestPostTableModel.class);

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.listPair.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        String[] stringArray = this.listPair.get(n);
        return stringArray[n2];
    }

    @Override
    public String getColumnName(int n) {
        return columnNames[n];
    }

    public synchronized void setText(String string) {
        this.isChanged = false;
        this.listPair.clear();
        String string2 = null;
        String string3 = null;
        Matcher matcher = pSeparator.matcher(string);
        int n = 0;
        while (matcher.find()) {
            ++n;
            String[] stringArray = new String[2];
            try {
                string2 = URLDecoder.decode(matcher.group(1), "8859_1");
                string3 = URLDecoder.decode(matcher.group(2), "8859_1");
                stringArray[0] = string2;
                stringArray[1] = string3;
                this.listPair.add(stringArray);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                logger.error((Object)unsupportedEncodingException.getMessage(), (Throwable)unsupportedEncodingException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                logger.error((Object)illegalArgumentException.getMessage(), (Throwable)illegalArgumentException);
            }
        }
        if (n == 0) {
            if (string.isEmpty() && this.editable) {
                this.listPair.add(new String[]{"", ""});
            }
        } else if (this.editable) {
            this.listPair.add(new String[]{"", ""});
        }
        this.fireTableDataChanged();
    }

    public synchronized String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (int i = 0; i < this.listPair.size(); ++i) {
            String[] stringArray = this.listPair.get(i);
            try {
                String string = URLEncoder.encode(stringArray[0], "UTF8");
                String string2 = URLEncoder.encode(stringArray[1], "UTF8");
                if (string.length() <= 0) continue;
                if (bl) {
                    stringBuilder.append('&');
                }
                stringBuilder.append(string);
                stringBuilder.append('=');
                stringBuilder.append(string2);
                bl = true;
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                logger.error((Object)unsupportedEncodingException.getMessage(), (Throwable)unsupportedEncodingException);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                logger.error((Object)illegalArgumentException.getMessage(), (Throwable)illegalArgumentException);
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return this.isEditable();
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (n < this.listPair.size() - 1) {
            String[] stringArray = this.listPair.get(n);
            stringArray[n2] = (String)object;
            this.fireTableCellUpdated(n, n2);
            this.isChanged = true;
        } else if (!object.equals("")) {
            String[] stringArray = this.listPair.get(n);
            stringArray[n2] = (String)object;
            String[] stringArray2 = new String[]{"", ""};
            this.listPair.add(stringArray2);
            this.fireTableCellUpdated(n, n2);
            this.isChanged = true;
        }
    }

    public boolean hasChanged() {
        return this.isChanged;
    }
}

