/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.spider;

import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.apache.log4j.varia.NullAppender;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.zaproxy.zap.spider.SpiderParam;
import org.zaproxy.zap.spider.URLCanonicalizer;

public class URLCanonicalizerUnitTest {
    @BeforeClass
    public static void suppressLogging() {
        Logger.getLogger(URLCanonicalizer.class).addAppender((Appender)new NullAppender());
    }

    @Test
    public void shouldCanonicalizeURIsWithAuthority() {
        String[] stringArray;
        for (String string : stringArray = new String[]{"http://example.com/", "https://example.com/", "ftp://example.com/"}) {
            String string2 = URLCanonicalizer.getCanonicalURL(string);
            Assert.assertThat((String)string2, (Object)string2, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)string)));
        }
    }

    @Test
    public void shouldIgnoreURIsWithNoAuthority() {
        String[] stringArray;
        for (String string : stringArray = new String[]{"javascript:ignore()", "mailto:ignore@example.com"}) {
            String string2 = URLCanonicalizer.getCanonicalURL(string);
            Assert.assertThat((String)string2, (Object)string2, (Matcher)Matchers.is((Matcher)Matchers.equalTo(null)));
        }
    }

    @Test
    public void shouldReturnCanonicalUriWithPercentEncodedPath() throws URIException {
        String string = new URI("http://example.com/path/%C3%A1/", true).toString();
        String string2 = URLCanonicalizer.getCanonicalURL(string);
        Assert.assertThat((Object)string2, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"http://example.com/path/%C3%A1/")));
    }

    @Test
    public void shouldReturnCanonicalUriWithPercentEncodedQuery() throws URIException {
        String string = new URI("http://example.com/path/?par%C3%A2m=v%C3%A3lue", true).toString();
        String string2 = URLCanonicalizer.getCanonicalURL(string);
        Assert.assertThat((Object)string2, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"http://example.com/path/?par%C3%A2m=v%C3%A3lue")));
    }

    @Test
    public void shouldCorrectlyParseQueryParameterNamesAndValuesWithAmpersandsAndEqualsWhenCanonicalizing() throws URIException {
        String string = new URI("http://example.com/?par%26am%3D1=val%26u%3De1", true).toString();
        String string2 = URLCanonicalizer.getCanonicalURL(string);
        Assert.assertThat((Object)string2, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"http://example.com/?par%26am%3D1=val%26u%3De1")));
    }

    @Test
    public void shouldReturnPercentEncodedUriWhenCleaningParametersIn_USE_ALL_mode() throws URIException {
        URI uRI = new URI("http://example.com/path/%C3%A1/?par%C3%A2m=v%C3%A3lue", true);
        String string = URLCanonicalizer.buildCleanedParametersURIRepresentation(uRI, SpiderParam.HandleParametersOption.USE_ALL, false);
        Assert.assertThat((Object)string, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"http://example.com/path/%C3%A1/?par%C3%A2m=v%C3%A3lue")));
    }

    @Test
    public void shouldReturnPercentEncodedUriWhenCleaningParametersIn_IGNORE_VALUE_mode() throws URIException {
        URI uRI = new URI("http://example.com/path/%C3%A1/?par%C3%A2m=v%C3%A3lue1", true);
        String string = URLCanonicalizer.buildCleanedParametersURIRepresentation(uRI, SpiderParam.HandleParametersOption.IGNORE_VALUE, false);
        Assert.assertThat((Object)string, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"http://example.com/path/%C3%A1/?par%C3%A2m")));
    }

    @Test
    public void shouldReturnPercentEncodedUriWhenCleaningParametersIn_IGNORE_COMPLETELY_mode() throws URIException {
        URI uRI = new URI("http://example.com/path/%C3%A1/?par%C3%A2m=v%C3%A3lue", true);
        String string = URLCanonicalizer.buildCleanedParametersURIRepresentation(uRI, SpiderParam.HandleParametersOption.IGNORE_COMPLETELY, false);
        Assert.assertThat((Object)string, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"http://example.com/path/%C3%A1/")));
    }

    @Test
    public void shouldCorrectlyParseQueryParamNamesAndValuesWithAmpersandsAndEqualsWhenCleaningParametersIn_USE_ALL_mode() throws URIException {
        URI uRI = new URI("http://example.com/path/?par%3Dam1=val%26ue1&par%26am2=val%3Due2", true);
        String string = URLCanonicalizer.buildCleanedParametersURIRepresentation(uRI, SpiderParam.HandleParametersOption.USE_ALL, false);
        Assert.assertThat((Object)string, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"http://example.com/path/?par%3Dam1=val%26ue1&par%26am2=val%3Due2")));
    }

    @Test
    public void shouldCorrectlyParseQueryParamNamesAndValuesWithAmpersandsAndEqualsWhenCleaningParametersIn_IGNORE_VALUE_mode() throws URIException {
        URI uRI = new URI("http://example.com/path/?par%3Dam1=val%26ue1&par%26am2=val%3Due2", true);
        String string = URLCanonicalizer.buildCleanedParametersURIRepresentation(uRI, SpiderParam.HandleParametersOption.IGNORE_VALUE, false);
        Assert.assertThat((Object)string, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"http://example.com/path/?par%26am2&par%3Dam1")));
    }

    @Test
    public void shouldCorrectlyParseQueryParamNamesAndValuesWithAmpersandsAndEqualsWhenCleaningParametersIn_IGNORE_COMPLETELY_mode() throws URIException {
        URI uRI = new URI("http://example.com/path/?par%3Dam1=val%26ue1&par%26am2=val%3Due2", true);
        String string = URLCanonicalizer.buildCleanedParametersURIRepresentation(uRI, SpiderParam.HandleParametersOption.IGNORE_COMPLETELY, false);
        Assert.assertThat((Object)string, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"http://example.com/path/")));
    }

    @Test
    public void shouldCanonicalizeNormalURLWithoutParametersIn_USE_ALL_mode() throws URIException {
        URI uRI = new URI("http", null, "host", 9001, "/myservlet");
        String string = URLCanonicalizer.buildCleanedParametersURIRepresentation(uRI, SpiderParam.HandleParametersOption.USE_ALL, false);
        Assert.assertThat((Object)string, (Matcher)Matchers.is((Object)"http://host:9001/myservlet"));
    }

    @Test
    public void shouldCanonicalizeNormalURLWithoutParametersIn_IGNORE_COMPLETELY_mode() throws URIException {
        URI uRI = new URI("http", null, "host", 9001, "/myservlet");
        String string = URLCanonicalizer.buildCleanedParametersURIRepresentation(uRI, SpiderParam.HandleParametersOption.IGNORE_COMPLETELY, false);
        Assert.assertThat((Object)string, (Matcher)Matchers.is((Object)"http://host:9001/myservlet"));
    }

    @Test
    public void shouldCanonicalizeNormalURLWithoutParametersIn_IGNORE_VALUE_mode() throws URIException {
        URI uRI = new URI("http", null, "host", 9001, "/myservlet");
        String string = URLCanonicalizer.buildCleanedParametersURIRepresentation(uRI, SpiderParam.HandleParametersOption.IGNORE_VALUE, false);
        Assert.assertThat((Object)string, (Matcher)Matchers.is((Object)"http://host:9001/myservlet"));
    }

    @Test
    public void shouldCanonicalizeNormalURLWithParametersIn_USE_ALL_mode() throws URIException {
        URI uRI = new URI("http", null, "host", 9001, "/myservlet", "p1=2&p2=myparam");
        String string = URLCanonicalizer.buildCleanedParametersURIRepresentation(uRI, SpiderParam.HandleParametersOption.USE_ALL, false);
        Assert.assertThat((Object)string, (Matcher)Matchers.is((Object)"http://host:9001/myservlet?p1=2&p2=myparam"));
    }

    @Test
    public void shouldCanonicalizeNormalURLWithParametersIn_IGNORE_COMPLETELY_mode() throws URIException {
        URI uRI = new URI("http", null, "host", 9001, "/myservlet", "p1=2&p2=myparam");
        String string = URLCanonicalizer.buildCleanedParametersURIRepresentation(uRI, SpiderParam.HandleParametersOption.IGNORE_COMPLETELY, false);
        Assert.assertThat((Object)string, (Matcher)Matchers.is((Object)"http://host:9001/myservlet"));
    }

    @Test
    public void shouldCanonicalizeNormalURLWithParametersIn_IGNORE_VALUE_mode() throws URIException {
        URI uRI = new URI("http", null, "host", 9001, "/myservlet", "p1=2&p2=myparam");
        String string = URLCanonicalizer.buildCleanedParametersURIRepresentation(uRI, SpiderParam.HandleParametersOption.IGNORE_VALUE, false);
        Assert.assertThat((Object)string, (Matcher)Matchers.is((Object)"http://host:9001/myservlet?p1&p2"));
    }

    @Test
    public void shouldCanonicalizeODataIDSimpleIn_USE_ALL_mode() throws URIException {
        SpiderParam.HandleParametersOption handleParametersOption = SpiderParam.HandleParametersOption.USE_ALL;
        URI uRI = new URI("http", null, "host", 9001, "/app.svc/Book(1)");
        String string = URLCanonicalizer.buildCleanedParametersURIRepresentation(uRI, handleParametersOption, true);
        Assert.assertThat((Object)string, (Matcher)Matchers.is((Object)"http://host:9001/app.svc/Book(1)"));
        uRI = new URI("http", null, "host", 9001, "/app.svc/Book(1)/Author");
        string = URLCanonicalizer.buildCleanedParametersURIRepresentation(uRI, handleParametersOption, true);
        Assert.assertThat((Object)string, (Matcher)Matchers.is((Object)"http://host:9001/app.svc/Book(1)/Author"));
    }

    @Test
    public void shouldCanonicalizeODataIDSimpleIn_IGNORE_COMPLETELY_mode() throws URIException {
        SpiderParam.HandleParametersOption handleParametersOption = SpiderParam.HandleParametersOption.IGNORE_COMPLETELY;
        URI uRI = new URI("http", null, "host", 9001, "/app.svc/Book(1)");
        String string = URLCanonicalizer.buildCleanedParametersURIRepresentation(uRI, handleParametersOption, true);
        Assert.assertThat((Object)string, (Matcher)Matchers.is((Object)"http://host:9001/app.svc/Book()"));
        uRI = new URI("http", null, "host", 9001, "/app.svc/Book(1)/Author");
        string = URLCanonicalizer.buildCleanedParametersURIRepresentation(uRI, handleParametersOption, true);
        Assert.assertThat((Object)string, (Matcher)Matchers.is((Object)"http://host:9001/app.svc/Book()/Author"));
    }

    @Test
    public void shouldCanonicalizeODataIDSimpleIn_IGNORE_VALUE_mode() throws URIException {
        SpiderParam.HandleParametersOption handleParametersOption = SpiderParam.HandleParametersOption.IGNORE_VALUE;
        URI uRI = new URI("http", null, "host", 9001, "/app.svc/Book(1)");
        String string = URLCanonicalizer.buildCleanedParametersURIRepresentation(uRI, handleParametersOption, true);
        Assert.assertThat((Object)string, (Matcher)Matchers.is((Object)"http://host:9001/app.svc/Book()"));
        uRI = new URI("http", null, "host", 9001, "/app.svc/Book(1)/Author");
        string = URLCanonicalizer.buildCleanedParametersURIRepresentation(uRI, handleParametersOption, true);
        Assert.assertThat((Object)string, (Matcher)Matchers.is((Object)"http://host:9001/app.svc/Book()/Author"));
    }

    @Test
    public void shouldCanonicalizeODataIDMultipleIn_USE_ALL_mode() throws URIException {
        SpiderParam.HandleParametersOption handleParametersOption = SpiderParam.HandleParametersOption.USE_ALL;
        URI uRI = new URI("http", null, "host", 9001, "/app.svc/Book(title='dummy',year=2012)");
        String string = URLCanonicalizer.buildCleanedParametersURIRepresentation(uRI, handleParametersOption, true);
        Assert.assertThat((Object)string, (Matcher)Matchers.is((Object)"http://host:9001/app.svc/Book(title='dummy',year=2012)"));
        uRI = new URI("http", null, "host", 9001, "/app.svc/Book(title='dummy',year=2012)/Author");
        string = URLCanonicalizer.buildCleanedParametersURIRepresentation(uRI, handleParametersOption, true);
        Assert.assertThat((Object)string, (Matcher)Matchers.is((Object)"http://host:9001/app.svc/Book(title='dummy',year=2012)/Author"));
    }

    @Test
    public void shouldCanonicalizeODataIDMultipleIn_IGNORE_COMPLETELY_mode() throws URIException {
        SpiderParam.HandleParametersOption handleParametersOption = SpiderParam.HandleParametersOption.IGNORE_COMPLETELY;
        URI uRI = new URI("http", null, "host", 9001, "/app.svc/Book(title='dummy',year=2012)");
        String string = URLCanonicalizer.buildCleanedParametersURIRepresentation(uRI, handleParametersOption, true);
        Assert.assertThat((Object)string, (Matcher)Matchers.is((Object)"http://host:9001/app.svc/Book()"));
        uRI = new URI("http", null, "host", 9001, "/app.svc/Book(title='dummy',year=2012)/Author");
        string = URLCanonicalizer.buildCleanedParametersURIRepresentation(uRI, handleParametersOption, true);
        Assert.assertThat((Object)string, (Matcher)Matchers.is((Object)"http://host:9001/app.svc/Book()/Author"));
    }

    @Test
    public void shouldCanonicalizeODataIDMultipleIn_IGNORE_VALUE_mode() throws URIException {
        SpiderParam.HandleParametersOption handleParametersOption = SpiderParam.HandleParametersOption.IGNORE_VALUE;
        URI uRI = new URI("http", null, "host", 9001, "/app.svc/Book(title='dummy',year=2012)");
        String string = URLCanonicalizer.buildCleanedParametersURIRepresentation(uRI, handleParametersOption, true);
        Assert.assertThat((Object)string, (Matcher)Matchers.is((Object)"http://host:9001/app.svc/Book(title,year)"));
        uRI = new URI("http", null, "host", 9001, "/app.svc/Book(title='dummy',year=2012)/Author");
        string = URLCanonicalizer.buildCleanedParametersURIRepresentation(uRI, handleParametersOption, true);
        Assert.assertThat((Object)string, (Matcher)Matchers.is((Object)"http://host:9001/app.svc/Book(title,year)/Author"));
    }
}

