/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.spider;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.zaproxy.zap.spider.URLResolver;

public class URLResolverUnitTest {
    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionOnMissingBaseUrl() {
        URLResolver.resolveUrl(null, "notNull");
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionOnMissingRelativeUrl() {
        URLResolver.resolveUrl("notNull", null);
    }

    @Test
    public void shouldAppendRelativeUrlToBaseUrlHost() {
        Assert.assertThat((Object)URLResolver.resolveUrl("http://www.abc.de", "/xy/z"), (Matcher)Matchers.is((Object)"http://www.abc.de/xy/z"));
    }

    @Test
    public void shouldInsertSlashBetweenBaseUrlAndRelativeUrlIfMissing() {
        Assert.assertThat((Object)URLResolver.resolveUrl("http://www.abc.de", "xyz"), (Matcher)Matchers.is((Object)"http://www.abc.de/xyz"));
    }

    @Test
    public void shouldReplaceLastPartOfUrlPathFromBaseUrlWithRelativeUrl() {
        Assert.assertThat((Object)URLResolver.resolveUrl("http://www.abc.de/w/x", "y/z"), (Matcher)Matchers.is((Object)"http://www.abc.de/w/y/z"));
    }

    @Test
    public void shouldRemoveFragmentFromBaseUrlBeforeAppendingRelativeUrl() {
        Assert.assertThat((Object)URLResolver.resolveUrl("http://www.abc.de#anchor", "y"), (Matcher)Matchers.is((Object)"http://www.abc.de/y"));
    }

    @Test
    public void shouldRemoveQueryFromBaseUrlBeforeAppendingRelativeUrl() {
        Assert.assertThat((Object)URLResolver.resolveUrl("http://www.abc.de?y=z", "test"), (Matcher)Matchers.is((Object)"http://www.abc.de/test"));
    }

    @Test
    public void shouldRemoveParametersFromBaseUrlBeforeAppendingRelativeUrl() {
        Assert.assertThat((Object)URLResolver.resolveUrl("http://www.abc.de;y;z", "test"), (Matcher)Matchers.is((Object)"http://www.abc.de/test"));
    }

    @Test
    public void shouldReturnOriginalBaseUrlForGivenEmptyRelativeUrl() {
        Assert.assertThat((Object)URLResolver.resolveUrl("http://www.abc.de/x?y=z&u=v#123", ""), (Matcher)Matchers.is((Object)"http://www.abc.de/x?y=z&u=v#123"));
    }

    @Test
    public void shouldReturnOriginalRelativeUrlForGivenAbsoluteUrlAsRelativeUrl() {
        Assert.assertThat((Object)URLResolver.resolveUrl("http://base.url", "http://www.abc.de/x?y=z&u=v#123"), (Matcher)Matchers.is((Object)"http://www.abc.de/x?y=z&u=v#123"));
    }

    @Test
    public void shouldUseSchemeOfBaseUrlForGivenUrlWithHostAsRelativeUrl() {
        Assert.assertThat((Object)URLResolver.resolveUrl("https://base.url", "//www.test.com"), (Matcher)Matchers.is((Object)"https://www.test.com"));
    }

    @Test
    public void shouldAppendQueryGivenAsRelativeUrlToBaseUrl() {
        Assert.assertThat((Object)URLResolver.resolveUrl("http://abc.de/123", "?x=y"), (Matcher)Matchers.is((Object)"http://abc.de/123?x=y"));
    }

    @Test
    public void shouldAppendParametersGivenAsRelativeUrlToBaseUrl() {
        Assert.assertThat((Object)URLResolver.resolveUrl("http://abc.de/123", ";x=y"), (Matcher)Matchers.is((Object)"http://abc.de/123;x=y"));
    }

    @Test
    public void shouldAppendFragmentGivenAsRelativeUrlToBaseUrl() {
        Assert.assertThat((Object)URLResolver.resolveUrl("http://abc.de/123", "#test"), (Matcher)Matchers.is((Object)"http://abc.de/123#test"));
    }

    @Test
    public void shouldRemoveLeadingSlashPointsFromRelativeUrlBeforeAppendingToBaseUrl() {
        Assert.assertThat((Object)URLResolver.resolveUrl("http://abc.de/123/xyz", "../test"), (Matcher)Matchers.is((Object)"http://abc.de/test"));
    }

    @Test
    public void shouldRemoveAllSlashPointSlashOccurencesFromResolvedUrl() {
        Assert.assertThat((Object)URLResolver.resolveUrl("http://abc.de/./", "test/./xyz/./123"), (Matcher)Matchers.is((Object)"http://abc.de/test/xyz/123"));
    }

    @Test
    public void shouldRemoveTrailingPointFromResolvedUrl() {
        Assert.assertThat((Object)URLResolver.resolveUrl("http://abc.de", "test/."), (Matcher)Matchers.is((Object)"http://abc.de/test/"));
    }

    @Test
    public void shouldApplyDirectoryTraversalWithSlashPointsInResolvedUrl() {
        Assert.assertThat((Object)URLResolver.resolveUrl("http://abc.de/x/../", "y/../z/../test/123/.."), (Matcher)Matchers.is((Object)"http://abc.de/test/"));
    }
}

