/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.spider.parser;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import net.htmlparser.jericho.StartTagType;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.spider.SpiderParam;
import org.zaproxy.zap.spider.parser.SpiderParser;

public class SpiderHtmlParser
extends SpiderParser {
    private static final Pattern urlPattern = Pattern.compile("url\\s*=\\s*([^;]+)", 2);
    private SpiderParam params;

    public SpiderHtmlParser(SpiderParam spiderParam) {
        this.params = spiderParam;
    }

    @Override
    public boolean parseResource(HttpMessage httpMessage, Source source, int n) {
        if (source == null) {
            source = new Source((CharSequence)httpMessage.getResponseBody().toString());
        }
        String string = httpMessage == null ? "" : httpMessage.getRequestHeader().getURI().toString();
        Element element = source.getFirstElement("base");
        if (element != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Base tag was found in HTML: " + element.getDebugInfo()));
            }
            if (element.getAttributeValue("href") != null) {
                string = element.getAttributeValue("href");
            }
        }
        this.parseSource(httpMessage, source, n, string);
        if (this.params.isParseComments()) {
            List list = source.getAllStartTags(StartTagType.COMMENT);
            for (StartTag startTag : list) {
                Source source2 = new Source((CharSequence)startTag.getTagContent());
                this.parseSource(httpMessage, source2, n, string);
            }
        }
        return false;
    }

    private void parseSource(HttpMessage httpMessage, Source source, int n, String string) {
        log.debug((Object)"Parsing an HTML message...");
        List list = source.getAllElements("a");
        for (Element element : list) {
            this.processAttributeElement(httpMessage, n, string, element, "href");
        }
        list = source.getAllElements("area");
        for (Element element : list) {
            this.processAttributeElement(httpMessage, n, string, element, "href");
        }
        list = source.getAllElements("frame");
        for (Element element : list) {
            this.processAttributeElement(httpMessage, n, string, element, "src");
        }
        list = source.getAllElements("iframe");
        for (Element element : list) {
            this.processAttributeElement(httpMessage, n, string, element, "src");
        }
        list = source.getAllElements("link");
        for (Element element : list) {
            this.processAttributeElement(httpMessage, n, string, element, "href");
        }
        list = source.getAllElements("script");
        for (Element element : list) {
            this.processAttributeElement(httpMessage, n, string, element, "src");
        }
        list = source.getAllElements("img");
        for (Element element : list) {
            this.processAttributeElement(httpMessage, n, string, element, "src");
        }
        list = source.getAllElements("meta");
        for (Element element : list) {
            Matcher matcher;
            String string2 = element.getAttributeValue("http-equiv");
            String string3 = element.getAttributeValue("content");
            if (string2 == null || string3 == null || !string2.equalsIgnoreCase("refresh") && !string2.equalsIgnoreCase("location") || !(matcher = urlPattern.matcher(string3)).find()) continue;
            String string4 = matcher.group(1);
            this.processURL(httpMessage, n, string4, string);
        }
    }

    private void processAttributeElement(HttpMessage httpMessage, int n, String string, Element element, String string2) {
        String string3 = element.getAttributeValue(string2);
        if (string3 == null) {
            return;
        }
        this.processURL(httpMessage, n, string3, string);
    }

    @Override
    public boolean canParseResource(HttpMessage httpMessage, String string, boolean bl) {
        return !bl && httpMessage.getResponseHeader() != null && httpMessage.getResponseHeader().isHtml();
    }
}

