/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.utils;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.zaproxy.zap.utils.XMLStringUtil;

public class XMLStringUtilUnitTest {
    @Test
    public void shouldNotEscapeXmlWithoutControlCharacters() {
        String string = "ABCDEF";
        String string2 = XMLStringUtil.escapeControlChrs(string);
        Assert.assertThat((Object)string2, (Matcher)Matchers.is((Object)string));
    }

    @Test
    public void shouldNotRemoveAnythingFromXmlWithoutControlCharacters() {
        String string = "ABCDEF";
        String string2 = XMLStringUtil.removeControlChrs(string);
        Assert.assertThat((Object)string2, (Matcher)Matchers.is((Object)string));
    }

    @Test
    public void shouldEscapeControlCharacters() {
        String string = "A\u0000B\u0001C\u0010D\ufffeE\uffffF";
        String string2 = XMLStringUtil.escapeControlChrs(string);
        Assert.assertThat((Object)string2, (Matcher)Matchers.is((Object)"A\\x0000B\\x0001C\\x0010D\\xfffeE\\xffffF"));
    }

    @Test
    public void shouldRemoveControlCharacters() {
        String string = "A\u0000B\u0001C\u0010D\ufffeE\uffffF";
        String string2 = XMLStringUtil.removeControlChrs(string);
        Assert.assertThat((Object)string2, (Matcher)Matchers.is((Object)"ABCDEF"));
    }
}

