/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.ui.prefs;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.owasp.jbrofuzz.JBroFuzz;
import org.owasp.jbrofuzz.ui.prefs.AbstractPrefsPanel;
import org.owasp.jbrofuzz.ui.prefs.PrefDialog;
import org.owasp.jbrofuzz.version.JBroFuzzPrefs;

class FuzzPPanel
extends AbstractPrefsPanel {
    private static final long serialVersionUID = 1154452563244021077L;
    private static final String[] SOCKET_SECONDS = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "50"};
    private final JComboBox stoBox;
    private final JCheckBox[] checkBoxes = new JCheckBox[JBroFuzzPrefs.FUZZING.length - 1];

    public FuzzPPanel(final PrefDialog dialog) {
        super("Fuzzing");
        int stoPrefValue = JBroFuzz.PREFS.getInt(JBroFuzzPrefs.FUZZING[0].getId(), 7);
        if (stoPrefValue < 1 || stoPrefValue > 51) {
            stoPrefValue = 7;
        }
        this.stoBox = new JComboBox<String>(SOCKET_SECONDS);
        this.stoBox.setSelectedIndex(stoPrefValue - 1);
        this.stoBox.setMaximumRowCount(6);
        this.stoBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent stoEvent) {
                dialog.setApplyEnabled(true);
            }
        });
        JLabel stoLabel = new JLabel(JBroFuzzPrefs.FUZZING[0].getTitle());
        stoLabel.setToolTipText(JBroFuzzPrefs.FUZZING[0].getTooltip());
        JPanel sTimeOutPanel = new JPanel(new FlowLayout(2, 15, 15));
        sTimeOutPanel.setAlignmentX(0.0f);
        sTimeOutPanel.add(stoLabel);
        sTimeOutPanel.add(this.stoBox);
        this.add(sTimeOutPanel);
        this.add(Box.createRigidArea(new Dimension(0, 20)));
        int i = 0;
        while (i < this.checkBoxes.length) {
            boolean boolEntry = JBroFuzz.PREFS.getBoolean(JBroFuzzPrefs.FUZZING[i + 1].getId(), true);
            this.checkBoxes[i] = new JCheckBox(JBroFuzzPrefs.FUZZING[i + 1].getTitle(), boolEntry);
            this.checkBoxes[i].setToolTipText(JBroFuzzPrefs.FUZZING[i + 1].getTooltip());
            this.checkBoxes[i].setBorderPaintedFlat(true);
            this.checkBoxes[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    dialog.setApplyEnabled(true);
                }
            });
            this.add(this.checkBoxes[i]);
            this.add(Box.createRigidArea(new Dimension(0, 20)));
            ++i;
        }
        this.add(Box.createRigidArea(new Dimension(0, 200)));
    }

    @Override
    public void apply() {
        JBroFuzz.PREFS.putInt(JBroFuzzPrefs.FUZZING[0].getId(), this.stoBox.getSelectedIndex() + 1);
        int i = 0;
        while (i < this.checkBoxes.length) {
            JBroFuzz.PREFS.putBoolean(JBroFuzzPrefs.FUZZING[i + 1].getId(), this.checkBoxes[i].isSelected());
            ++i;
        }
    }
}

