/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleActionListener;
import org.eclipse.swt.accessibility.AccessibleAttributeListener;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEditableTextListener;
import org.eclipse.swt.accessibility.AccessibleFactory;
import org.eclipse.swt.accessibility.AccessibleHyperlinkListener;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.accessibility.AccessibleObject;
import org.eclipse.swt.accessibility.AccessibleTableCellListener;
import org.eclipse.swt.accessibility.AccessibleTableListener;
import org.eclipse.swt.accessibility.AccessibleTextExtendedListener;
import org.eclipse.swt.accessibility.AccessibleTextListener;
import org.eclipse.swt.accessibility.AccessibleValueListener;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class Accessible {
    Vector accessibleListeners;
    Vector accessibleControlListeners;
    Vector accessibleTextListeners;
    Vector accessibleActionListeners;
    Vector accessibleEditableTextListeners;
    Vector accessibleHyperlinkListeners;
    Vector accessibleTableListeners;
    Vector accessibleTableCellListeners;
    Vector accessibleTextExtendedListeners;
    Vector accessibleValueListeners;
    Vector accessibleAttributeListeners;
    Accessible parent;
    AccessibleObject accessibleObject;
    Control control;
    Vector relations;
    Vector children;

    public Accessible(Accessible accessible) {
        this.parent = Accessible.checkNull(accessible);
        this.control = accessible.control;
        if (accessible.children == null) {
            accessible.children = new Vector();
        }
        accessible.children.addElement(this);
    }

    @Deprecated
    protected Accessible() {
    }

    static Accessible checkNull(Accessible accessible) {
        if (accessible == null) {
            SWT.error(4);
        }
        return accessible;
    }

    Accessible(Control control) {
        this.control = control;
        AccessibleFactory.registerAccessible(this);
    }

    public void addAccessibleListener(AccessibleListener accessibleListener) {
        this.checkWidget();
        if (accessibleListener == null) {
            SWT.error(4);
        }
        if (this.accessibleListeners == null) {
            this.accessibleListeners = new Vector();
        }
        this.accessibleListeners.addElement(accessibleListener);
    }

    public void addAccessibleControlListener(AccessibleControlListener accessibleControlListener) {
        this.checkWidget();
        if (accessibleControlListener == null) {
            SWT.error(4);
        }
        if (this.accessibleControlListeners == null) {
            this.accessibleControlListeners = new Vector();
        }
        this.accessibleControlListeners.addElement(accessibleControlListener);
    }

    public void addAccessibleTextListener(AccessibleTextListener accessibleTextListener) {
        this.checkWidget();
        if (accessibleTextListener == null) {
            SWT.error(4);
        }
        if (accessibleTextListener instanceof AccessibleTextExtendedListener) {
            if (this.accessibleTextExtendedListeners == null) {
                this.accessibleTextExtendedListeners = new Vector();
            }
            this.accessibleTextExtendedListeners.addElement(accessibleTextListener);
        } else {
            if (this.accessibleTextListeners == null) {
                this.accessibleTextListeners = new Vector();
            }
            this.accessibleTextListeners.addElement(accessibleTextListener);
        }
    }

    public void addAccessibleActionListener(AccessibleActionListener accessibleActionListener) {
        this.checkWidget();
        if (accessibleActionListener == null) {
            SWT.error(4);
        }
        if (this.accessibleActionListeners == null) {
            this.accessibleActionListeners = new Vector();
        }
        this.accessibleActionListeners.addElement(accessibleActionListener);
    }

    public void addAccessibleEditableTextListener(AccessibleEditableTextListener accessibleEditableTextListener) {
        this.checkWidget();
        if (accessibleEditableTextListener == null) {
            SWT.error(4);
        }
        if (this.accessibleEditableTextListeners == null) {
            this.accessibleEditableTextListeners = new Vector();
        }
        this.accessibleEditableTextListeners.addElement(accessibleEditableTextListener);
    }

    public void addAccessibleHyperlinkListener(AccessibleHyperlinkListener accessibleHyperlinkListener) {
        this.checkWidget();
        if (accessibleHyperlinkListener == null) {
            SWT.error(4);
        }
        if (this.accessibleHyperlinkListeners == null) {
            this.accessibleHyperlinkListeners = new Vector();
        }
        this.accessibleHyperlinkListeners.addElement(accessibleHyperlinkListener);
    }

    public void addAccessibleTableListener(AccessibleTableListener accessibleTableListener) {
        this.checkWidget();
        if (accessibleTableListener == null) {
            SWT.error(4);
        }
        if (this.accessibleTableListeners == null) {
            this.accessibleTableListeners = new Vector();
        }
        this.accessibleTableListeners.addElement(accessibleTableListener);
    }

    public void addAccessibleTableCellListener(AccessibleTableCellListener accessibleTableCellListener) {
        this.checkWidget();
        if (accessibleTableCellListener == null) {
            SWT.error(4);
        }
        if (this.accessibleTableCellListeners == null) {
            this.accessibleTableCellListeners = new Vector();
        }
        this.accessibleTableCellListeners.addElement(accessibleTableCellListener);
    }

    public void addAccessibleValueListener(AccessibleValueListener accessibleValueListener) {
        this.checkWidget();
        if (accessibleValueListener == null) {
            SWT.error(4);
        }
        if (this.accessibleValueListeners == null) {
            this.accessibleValueListeners = new Vector();
        }
        this.accessibleValueListeners.addElement(accessibleValueListener);
    }

    public void addAccessibleAttributeListener(AccessibleAttributeListener accessibleAttributeListener) {
        this.checkWidget();
        if (accessibleAttributeListener == null) {
            SWT.error(4);
        }
        if (this.accessibleAttributeListeners == null) {
            this.accessibleAttributeListeners = new Vector();
        }
        this.accessibleAttributeListeners.addElement(accessibleAttributeListener);
    }

    public void addRelation(int n, Accessible accessible) {
        Relation relation;
        this.checkWidget();
        if (this.relations == null) {
            this.relations = new Vector();
        }
        if (this.relations.indexOf(relation = new Relation(n, accessible)) != -1) {
            return;
        }
        this.relations.add(relation);
        if (this.accessibleObject != null) {
            this.accessibleObject.addRelation(n, accessible);
        }
    }

    void addRelations() {
        if (this.relations == null) {
            return;
        }
        if (this.accessibleObject == null) {
            return;
        }
        for (int i = 0; i < this.relations.size(); ++i) {
            Relation relation = (Relation)this.relations.elementAt(i);
            this.accessibleObject.addRelation(relation.type, relation.target);
        }
    }

    public void dispose() {
        if (this.parent == null) {
            return;
        }
        this.release();
        this.parent.children.removeElement(this);
        this.parent = null;
    }

    public Control getControl() {
        return this.control;
    }

    void checkWidget() {
        if (!this.isValidThread()) {
            SWT.error(22);
        }
        if (this.control.isDisposed()) {
            SWT.error(24);
        }
    }

    AccessibleObject getAccessibleObject() {
        if (this.accessibleObject == null) {
            if (this.parent == null) {
                AccessibleFactory.createAccessible(this);
            } else {
                this.accessibleObject = AccessibleFactory.createChildAccessible(this, -1);
                this.accessibleObject.parent = this.parent.getAccessibleObject();
            }
        }
        return this.accessibleObject;
    }

    int getControlHandle() {
        int n;
        int n2 = this.control.handle;
        if (this.control instanceof Label && (n = OS.gtk_container_get_children(n2)) != 0) {
            int n3 = n;
            while (n3 != 0) {
                int n4 = OS.g_list_data(n3);
                if (OS.GTK_VERSION >= OS.VERSION(2, 18, 0) ? OS.gtk_widget_get_visible(n4) : OS.GTK_WIDGET_VISIBLE(n4)) {
                    n2 = n4;
                    break;
                }
                n3 = OS.g_list_next(n3);
            }
            OS.g_list_free(n);
        }
        return n2;
    }

    public void internal_dispose_Accessible() {
        AccessibleFactory.unregisterAccessible(this);
        this.release();
    }

    public static Accessible internal_new_Accessible(Control control) {
        return new Accessible(control);
    }

    boolean isValidThread() {
        return this.control.getDisplay().getThread() == Thread.currentThread();
    }

    void release() {
        if (this.children != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                Accessible accessible = (Accessible)this.children.elementAt(i);
                accessible.dispose();
            }
        }
        if (this.accessibleObject != null) {
            this.accessibleObject.release();
            this.accessibleObject = null;
        }
    }

    public void removeAccessibleControlListener(AccessibleControlListener accessibleControlListener) {
        this.checkWidget();
        if (accessibleControlListener == null) {
            SWT.error(4);
        }
        if (this.accessibleControlListeners != null) {
            this.accessibleControlListeners.removeElement(accessibleControlListener);
            if (this.accessibleControlListeners.isEmpty()) {
                this.accessibleControlListeners = null;
            }
        }
    }

    public void removeAccessibleListener(AccessibleListener accessibleListener) {
        this.checkWidget();
        if (accessibleListener == null) {
            SWT.error(4);
        }
        if (this.accessibleListeners != null) {
            this.accessibleListeners.removeElement(accessibleListener);
            if (this.accessibleListeners.isEmpty()) {
                this.accessibleListeners = null;
            }
        }
    }

    public void removeAccessibleTextListener(AccessibleTextListener accessibleTextListener) {
        this.checkWidget();
        if (accessibleTextListener == null) {
            SWT.error(4);
        }
        if (accessibleTextListener instanceof AccessibleTextExtendedListener) {
            if (this.accessibleTextExtendedListeners != null) {
                this.accessibleTextExtendedListeners.removeElement(accessibleTextListener);
                if (this.accessibleTextExtendedListeners.isEmpty()) {
                    this.accessibleTextExtendedListeners = null;
                }
            }
        } else if (this.accessibleTextListeners != null) {
            this.accessibleTextListeners.removeElement(accessibleTextListener);
            if (this.accessibleTextListeners.isEmpty()) {
                this.accessibleTextListeners = null;
            }
        }
    }

    public void removeAccessibleActionListener(AccessibleActionListener accessibleActionListener) {
        this.checkWidget();
        if (accessibleActionListener == null) {
            SWT.error(4);
        }
        if (this.accessibleActionListeners != null) {
            this.accessibleActionListeners.removeElement(accessibleActionListener);
            if (this.accessibleActionListeners.isEmpty()) {
                this.accessibleActionListeners = null;
            }
        }
    }

    public void removeAccessibleEditableTextListener(AccessibleEditableTextListener accessibleEditableTextListener) {
        this.checkWidget();
        if (accessibleEditableTextListener == null) {
            SWT.error(4);
        }
        if (this.accessibleEditableTextListeners != null) {
            this.accessibleEditableTextListeners.removeElement(accessibleEditableTextListener);
            if (this.accessibleEditableTextListeners.isEmpty()) {
                this.accessibleEditableTextListeners = null;
            }
        }
    }

    public void removeAccessibleHyperlinkListener(AccessibleHyperlinkListener accessibleHyperlinkListener) {
        this.checkWidget();
        if (accessibleHyperlinkListener == null) {
            SWT.error(4);
        }
        if (this.accessibleHyperlinkListeners != null) {
            this.accessibleHyperlinkListeners.removeElement(accessibleHyperlinkListener);
            if (this.accessibleHyperlinkListeners.isEmpty()) {
                this.accessibleHyperlinkListeners = null;
            }
        }
    }

    public void removeAccessibleTableListener(AccessibleTableListener accessibleTableListener) {
        this.checkWidget();
        if (accessibleTableListener == null) {
            SWT.error(4);
        }
        if (this.accessibleTableListeners != null) {
            this.accessibleTableListeners.removeElement(accessibleTableListener);
            if (this.accessibleTableListeners.isEmpty()) {
                this.accessibleTableListeners = null;
            }
        }
    }

    public void removeAccessibleTableCellListener(AccessibleTableCellListener accessibleTableCellListener) {
        this.checkWidget();
        if (accessibleTableCellListener == null) {
            SWT.error(4);
        }
        if (this.accessibleTableCellListeners != null) {
            this.accessibleTableCellListeners.removeElement(accessibleTableCellListener);
            if (this.accessibleTableCellListeners.isEmpty()) {
                this.accessibleTableCellListeners = null;
            }
        }
    }

    public void removeAccessibleValueListener(AccessibleValueListener accessibleValueListener) {
        this.checkWidget();
        if (accessibleValueListener == null) {
            SWT.error(4);
        }
        if (this.accessibleValueListeners != null) {
            this.accessibleValueListeners.removeElement(accessibleValueListener);
            if (this.accessibleValueListeners.isEmpty()) {
                this.accessibleValueListeners = null;
            }
        }
    }

    public void removeAccessibleAttributeListener(AccessibleAttributeListener accessibleAttributeListener) {
        this.checkWidget();
        if (accessibleAttributeListener == null) {
            SWT.error(4);
        }
        if (this.accessibleAttributeListeners != null) {
            this.accessibleAttributeListeners.removeElement(accessibleAttributeListener);
            if (this.accessibleAttributeListeners.isEmpty()) {
                this.accessibleAttributeListeners = null;
            }
        }
    }

    public void removeRelation(int n, Accessible accessible) {
        this.checkWidget();
        if (this.relations == null) {
            return;
        }
        Relation relation = new Relation(n, accessible);
        int n2 = this.relations.indexOf(relation);
        if (n2 == -1) {
            return;
        }
        this.relations.remove(n2);
        if (this.accessibleObject != null) {
            this.accessibleObject.removeRelation(n, accessible);
        }
    }

    public void sendEvent(int n, Object object) {
        this.checkWidget();
        if (this.accessibleObject != null) {
            this.accessibleObject.sendEvent(n, object);
        }
    }

    public void sendEvent(int n, Object object, int n2) {
        this.checkWidget();
        if (this.accessibleObject != null) {
            switch (n) {
                case 32777: 
                case 32778: 
                case 32779: 
                case 32780: 
                case 32781: 
                case 32782: 
                case 32788: {
                    this.accessibleObject.sendEvent(n, object, n2);
                }
            }
        }
    }

    public void selectionChanged() {
        this.checkWidget();
        if (this.accessibleObject != null) {
            this.accessibleObject.selectionChanged();
        }
    }

    public void setFocus(int n) {
        this.checkWidget();
        if (this.accessibleObject != null) {
            this.accessibleObject.setFocus(n);
        }
    }

    public void textCaretMoved(int n) {
        this.checkWidget();
        if (this.accessibleObject != null) {
            this.accessibleObject.textCaretMoved(n);
        }
    }

    public void textChanged(int n, int n2, int n3) {
        this.checkWidget();
        if (this.accessibleObject != null) {
            this.accessibleObject.textChanged(n, n2, n3);
        }
    }

    public void textSelectionChanged() {
        this.checkWidget();
        if (this.accessibleObject != null) {
            this.accessibleObject.textSelectionChanged();
        }
    }

    static class Relation {
        int type;
        Accessible target;

        public Relation(int n, Accessible accessible) {
            this.type = n;
            this.target = accessible;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Relation)) {
                return false;
            }
            Relation relation = (Relation)object;
            return relation.type == this.type && relation.target == this.target;
        }
    }
}

