/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.merger.diff;

import java.util.ArrayList;
import org.openoffice.xmerge.merger.DiffAlgorithm;
import org.openoffice.xmerge.merger.Difference;
import org.openoffice.xmerge.merger.Iterator;
import org.openoffice.xmerge.util.Debug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IteratorLCSAlgorithm
implements DiffAlgorithm {
    @Override
    public Difference[] computeDiffs(Iterator orgSeq, Iterator modSeq) {
        int orgSeqlen = orgSeq.elementCount();
        int modSeqlen = modSeq.elementCount();
        int[][] diffTable = this.createDiffTable(orgSeq, modSeq);
        if (Debug.isFlagSet(1)) {
            this.printDiffTable(diffTable);
        }
        ArrayList<Difference> diffResult = new ArrayList<Difference>();
        this.generateResult(diffTable, orgSeqlen, modSeqlen, diffResult);
        Difference[] diffArray = new Difference[]{};
        if (diffResult.size() > 0) {
            diffArray = new Difference[diffResult.size()];
            diffResult.toArray(diffArray);
        }
        diffTable = null;
        diffResult = null;
        return diffArray;
    }

    private void printDiffTable(int[][] diffTable) {
        String tmpString = "";
        for (int i = 0; i < diffTable.length; ++i) {
            for (int j = 0; j < diffTable[i].length; ++j) {
                tmpString = tmpString + " " + diffTable[i][j] + " ";
            }
            Debug.log(1, tmpString);
            tmpString = "";
        }
    }

    private int[][] createDiffTable(Iterator orgSeq, Iterator modSeq) {
        int i;
        int orgSeqlen = orgSeq.elementCount() + 1;
        int modSeqlen = modSeq.elementCount() + 1;
        int[][] diffTable = new int[orgSeqlen][];
        for (i = 0; i < orgSeqlen; ++i) {
            diffTable[i] = new int[modSeqlen];
        }
        Object orgSeqObject = orgSeq.start();
        i = 1;
        while (orgSeqObject != null) {
            Object modSeqObject = modSeq.start();
            int j = 1;
            while (modSeqObject != null) {
                diffTable[i][j] = orgSeq.equivalent(orgSeqObject, modSeqObject) ? diffTable[i - 1][j - 1] + 1 : (diffTable[i - 1][j] >= diffTable[i][j - 1] ? diffTable[i - 1][j] : diffTable[i][j - 1]);
                modSeqObject = modSeq.next();
                ++j;
            }
            orgSeqObject = orgSeq.next();
            ++i;
        }
        return diffTable;
    }

    private void generateResult(int[][] diffTable, int i, int j, ArrayList<Difference> diffVector) {
        if (i == 0 && j == 0) {
            return;
        }
        if (j == 0) {
            for (int cnt = 0; cnt < i; ++cnt) {
                Difference diff = new Difference(2, cnt, j);
                diffVector.add(diff);
            }
            return;
        }
        if (i == 0) {
            for (int cnt = 0; cnt < j; ++cnt) {
                Difference diff = new Difference(1, i, cnt);
                diffVector.add(diff);
            }
            return;
        }
        if (diffTable[i - 1][j - 1] == diffTable[i][j] - 1 && diffTable[i - 1][j - 1] == diffTable[i - 1][j] && diffTable[i - 1][j - 1] == diffTable[i][j - 1]) {
            this.generateResult(diffTable, i - 1, j - 1, diffVector);
        } else if (diffTable[i - 1][j] > diffTable[i][j - 1]) {
            this.generateResult(diffTable, i - 1, j, diffVector);
            Difference diff = new Difference(2, i - 1, j);
            diffVector.add(diff);
        } else if (diffTable[i - 1][j] < diffTable[i][j - 1]) {
            this.generateResult(diffTable, i, j - 1, diffVector);
            Difference diff = new Difference(1, i, j - 1);
            diffVector.add(diff);
        } else {
            this.generateResult(diffTable, i - 1, j - 1, diffVector);
            Difference diff = new Difference(3, i - 1, j - 1);
            diffVector.add(diff);
        }
    }
}

