/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wiki;

import com.sun.star.uno.XComponentContext;
import com.sun.star.wiki.EditPageParser;
import com.sun.star.wiki.Helper;
import com.sun.star.wiki.MainThreadDialogExecutor;
import com.sun.star.wiki.WikiCancelException;
import com.sun.star.wiki.WikiEditSettingDialog;
import com.sun.star.wiki.WikiPropDialog;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.util.Map;
import javax.swing.text.html.HTMLEditorKit;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiArticle {
    private final XComponentContext m_xContext;
    private String m_sEditTime = "";
    private String m_sEditToken = "";
    private String m_sHTMLCode;
    private boolean m_bNoArticle = true;
    private String m_sWikiUser;
    private String m_sWikiPass;
    private final String m_sTitle;
    private final URI m_aMainURI;
    private HostConfiguration m_aHostConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WikiArticle(XComponentContext xContext, String sTitle, Map<String, String> wikiSettings, boolean bLogin, WikiPropDialog aPropDialog) throws MalformedURLException, IOException, WikiCancelException {
        this.m_xContext = xContext;
        String sMainUrl = wikiSettings.get("Url");
        this.m_sWikiUser = wikiSettings.get("Username");
        this.m_sWikiPass = wikiSettings.get("Password");
        this.m_sTitle = sTitle;
        this.m_aMainURI = new URI(sMainUrl, false);
        if (bLogin) {
            WikiEditSettingDialog aDialog = new WikiEditSettingDialog(this.m_xContext, "vnd.sun.star.script:WikiEditor.EditSetting?location=application", wikiSettings, false);
            try {
                while (!this.Login()) {
                    if (aPropDialog != null) {
                        aPropDialog.SetThrobberActive(false);
                    }
                    if (!MainThreadDialogExecutor.Show(xContext, aDialog)) {
                        throw new WikiCancelException();
                    }
                    this.m_sWikiUser = wikiSettings.get("Username");
                    this.m_sWikiPass = wikiSettings.get("Password");
                    if (aPropDialog == null) continue;
                    aPropDialog.SetThrobberActive(true);
                    Thread.yield();
                }
            }
            finally {
                aDialog.DisposeDialog();
            }
        }
        this.InitArticleHTML();
    }

    public String GetMainURL() {
        return this.m_aMainURI.toString();
    }

    public String GetTitle() {
        return this.m_sTitle;
    }

    private String getArticleWiki() throws IOException, WikiCancelException {
        String sWikiCode = null;
        if (this.m_aHostConfig != null) {
            URI aURI = new URI(this.m_aMainURI.toString() + "index.php?title=" + this.m_sTitle + "&action=edit", false);
            GetMethod aRequest = new GetMethod(aURI.getEscapedPathQuery());
            Helper.ExecuteMethod((HttpMethodBase)aRequest, this.m_aHostConfig, aURI, this.m_xContext, false);
            int nResultCode = aRequest.getStatusCode();
            String sWebPage = null;
            if (nResultCode == 200) {
                sWebPage = aRequest.getResponseBodyAsString();
            }
            aRequest.releaseConnection();
            if (sWebPage != null) {
                StringReader r = new StringReader(sWebPage);
                HTMLEditorKit.Parser parse = Helper.GetHTMLParser();
                EditPageParser callback = new EditPageParser();
                parse.parse(r, callback, true);
                this.m_sEditTime = callback.m_sEditTime;
                this.m_sEditToken = callback.m_sEditToken;
                int iPosStart = callback.m_nWikiArticleStart;
                int iPosEnd = callback.m_nWikiArticleEnd;
                if (iPosStart >= 0 && iPosEnd > 0) {
                    String sArticle = sWebPage.substring(iPosStart, iPosEnd);
                    iPosStart = sArticle.indexOf(62) + 1;
                    sWikiCode = sArticle.substring(iPosStart, sArticle.length());
                }
            }
        }
        return sWikiCode;
    }

    private void InitArticleHTML() throws IOException, WikiCancelException {
        if (this.m_aHostConfig != null) {
            URI aURI = new URI(this.m_aMainURI.toString() + "index.php?title=" + this.m_sTitle, false);
            GetMethod aRequest = new GetMethod(aURI.getEscapedPathQuery());
            Helper.ExecuteMethod((HttpMethodBase)aRequest, this.m_aHostConfig, aURI, this.m_xContext, false);
            int nResultCode = aRequest.getStatusCode();
            String sWebPage = null;
            if (nResultCode == 200) {
                sWebPage = aRequest.getResponseBodyAsString();
            }
            if (sWebPage != null) {
                StringReader r = new StringReader(sWebPage);
                HTMLEditorKit.Parser parse = Helper.GetHTMLParser();
                EditPageParser callback = new EditPageParser();
                parse.parse(r, callback, true);
                int iPosStart = callback.m_nHTMLArticleStart;
                int iPosEnd = callback.m_nHTMLArticleEnd;
                int nPosNoArt = callback.m_nNoArticleInd;
                if (iPosStart >= 0 && iPosEnd > 0) {
                    this.m_sHTMLCode = sWebPage.substring(iPosStart, iPosEnd);
                    this.m_bNoArticle = nPosNoArt >= 0 && nPosNoArt >= iPosStart && nPosNoArt <= iPosEnd;
                }
            }
        }
    }

    protected boolean setArticle(String sWikiCode, String sWikiComment, boolean bMinorEdit) throws IOException, WikiCancelException {
        boolean bResult = false;
        if (this.m_aHostConfig != null && sWikiCode != null && sWikiComment != null) {
            this.getArticleWiki();
            URI aURI = new URI(this.m_aMainURI.getPath() + "index.php?title=" + this.m_sTitle + "&action=submit", false);
            PostMethod aPost = new PostMethod();
            aPost.setPath(aURI.getEscapedPathQuery());
            aPost.addParameter("wpTextbox1", sWikiCode);
            aPost.addParameter("wpSummary", sWikiComment);
            aPost.addParameter("wpSection", "");
            aPost.addParameter("wpEdittime", this.m_sEditTime);
            aPost.addParameter("wpSave", "Save page");
            aPost.addParameter("wpEditToken", this.m_sEditToken);
            if (bMinorEdit) {
                aPost.addParameter("wpMinoredit", "1");
            }
            Helper.ExecuteMethod((HttpMethodBase)aPost, this.m_aHostConfig, aURI, this.m_xContext, false);
            int nResultCode = aPost.getStatusCode();
            if (nResultCode < 400) {
                bResult = true;
            }
            String aResult = aPost.getResponseBodyAsString();
            System.out.print("nSubmitCode = " + nResultCode + "\n===\n" + aResult);
        }
        return bResult;
    }

    private boolean Login() throws IOException, WikiCancelException {
        this.m_aHostConfig = Helper.Login(this.m_aMainURI, this.m_sWikiUser, this.m_sWikiPass, this.m_xContext);
        return this.m_aHostConfig != null;
    }

    protected boolean NotExist() {
        boolean bResult = true;
        if (this.m_sHTMLCode != null) {
            bResult = this.m_bNoArticle;
        }
        return bResult;
    }
}

