/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.nodes;

import com.android.dex.ClassData;
import com.android.dex.ClassDef;
import jadx.core.codegen.CodeWriter;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.annotations.Annotation;
import jadx.core.dex.attributes.nodes.JadxErrorAttr;
import jadx.core.dex.attributes.nodes.LineAttrNode;
import jadx.core.dex.attributes.nodes.SourceFileAttr;
import jadx.core.dex.info.AccessInfo;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.info.FieldInfo;
import jadx.core.dex.info.MethodInfo;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.LiteralArg;
import jadx.core.dex.instructions.args.PrimitiveType;
import jadx.core.dex.nodes.DexNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.ILoadable;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.ProcessState;
import jadx.core.dex.nodes.ResRefField;
import jadx.core.dex.nodes.parser.AnnotationsParser;
import jadx.core.dex.nodes.parser.FieldValueAttr;
import jadx.core.dex.nodes.parser.SignatureParser;
import jadx.core.dex.nodes.parser.StaticValuesParser;
import jadx.core.utils.exceptions.DecodeException;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassNode
extends LineAttrNode
implements ILoadable {
    private static final Logger LOG = LoggerFactory.getLogger(ClassNode.class);
    private final DexNode dex;
    private final ClassInfo clsInfo;
    private final AccessInfo accessFlags;
    private ArgType superClass;
    private List<ArgType> interfaces;
    private Map<ArgType, List<ArgType>> genericMap;
    private final List<MethodNode> methods;
    private final List<FieldNode> fields;
    private Map<Object, FieldNode> constFields = Collections.emptyMap();
    private List<ClassNode> innerClasses = Collections.emptyList();
    private CodeWriter code;
    private ClassNode parentClass;
    private ProcessState state = ProcessState.NOT_LOADED;
    private final Set<ClassNode> dependencies = new HashSet<ClassNode>();

    public ClassNode(DexNode dex, ClassDef cls) throws DecodeException {
        this.dex = dex;
        this.clsInfo = ClassInfo.fromDex(dex, cls.getTypeIndex());
        try {
            Annotation a;
            this.superClass = cls.getSupertypeIndex() == -1 ? null : dex.getType(cls.getSupertypeIndex());
            this.interfaces = new ArrayList<ArgType>(cls.getInterfaces().length);
            for (short interfaceIdx : cls.getInterfaces()) {
                this.interfaces.add(dex.getType(interfaceIdx));
            }
            if (cls.getClassDataOffset() != 0) {
                ClassData clsData = dex.readClassData(cls);
                int mthsCount = clsData.getDirectMethods().length + clsData.getVirtualMethods().length;
                int fieldsCount = clsData.getStaticFields().length + clsData.getInstanceFields().length;
                this.methods = new ArrayList<MethodNode>(mthsCount);
                this.fields = new ArrayList<FieldNode>(fieldsCount);
                for (ClassData.Method method : clsData.getDirectMethods()) {
                    this.methods.add(new MethodNode(this, method));
                }
                for (ClassData.Method method : clsData.getVirtualMethods()) {
                    this.methods.add(new MethodNode(this, method));
                }
                for (ClassData.Method method : clsData.getStaticFields()) {
                    this.fields.add(new FieldNode(this, (ClassData.Field)method));
                }
                this.loadStaticValues(cls, this.fields);
                for (ClassData.Method method : clsData.getInstanceFields()) {
                    this.fields.add(new FieldNode(this, (ClassData.Field)method));
                }
            } else {
                this.methods = Collections.emptyList();
                this.fields = Collections.emptyList();
            }
            this.loadAnnotations(cls);
            this.parseClassSignature();
            this.setFieldsTypesFromSignature();
            int sfIdx = cls.getSourceFileIndex();
            if (sfIdx != -1) {
                String fileName = dex.getString(sfIdx);
                this.addSourceFilenameAttr(fileName);
            }
            int accFlagsValue = (a = this.getAnnotation("dalvik.annotation.InnerClass")) != null ? ((Integer)a.getValues().get("accessFlags")).intValue() : cls.getAccessFlags();
            this.accessFlags = new AccessInfo(accFlagsValue, AccessInfo.AFType.CLASS);
        }
        catch (Exception e) {
            throw new DecodeException("Error decode class: " + this.clsInfo, e);
        }
    }

    public ClassNode(DexNode dex, ClassInfo clsInfo) {
        this.dex = dex;
        this.clsInfo = clsInfo;
        this.interfaces = Collections.emptyList();
        this.methods = Collections.emptyList();
        this.fields = Collections.emptyList();
        this.accessFlags = new AccessInfo(4097, AccessInfo.AFType.CLASS);
        this.parentClass = this;
    }

    private void loadAnnotations(ClassDef cls) {
        int offset = cls.getAnnotationsOffset();
        if (offset != 0) {
            try {
                new AnnotationsParser(this).parse(offset);
            }
            catch (Exception e) {
                LOG.error("Error parsing annotations in {}", (Object)this, (Object)e);
            }
        }
    }

    private void loadStaticValues(ClassDef cls, List<FieldNode> staticFields) throws DecodeException {
        for (FieldNode f : staticFields) {
            if (!f.getAccessFlags().isFinal()) continue;
            f.addAttr(new FieldValueAttr(null));
        }
        int offset = cls.getStaticValuesOffset();
        if (offset != 0) {
            StaticValuesParser parser = new StaticValuesParser(this.dex, this.dex.openSection(offset));
            int count = parser.processFields(staticFields);
            this.constFields = new LinkedHashMap<Object, FieldNode>(count);
            for (FieldNode f : staticFields) {
                FieldValueAttr fv;
                AccessInfo accFlags = f.getAccessFlags();
                if (!accFlags.isStatic() || !accFlags.isFinal() || (fv = f.get(AType.FIELD_VALUE)) == null || fv.getValue() == null) continue;
                if (accFlags.isPublic()) {
                    this.dex.getConstFields().put(fv.getValue(), f);
                }
                this.constFields.put(fv.getValue(), f);
            }
        }
    }

    private void parseClassSignature() {
        SignatureParser sp = SignatureParser.fromNode(this);
        if (sp == null) {
            return;
        }
        try {
            ArgType type;
            this.genericMap = sp.consumeGenericMap();
            this.superClass = sp.consumeType();
            for (int i = 0; i < this.interfaces.size() && (type = sp.consumeType()) != null; ++i) {
                this.interfaces.set(i, type);
            }
        }
        catch (JadxRuntimeException e) {
            LOG.error("Class signature parse error: {}", (Object)this, (Object)e);
        }
    }

    private void setFieldsTypesFromSignature() {
        for (FieldNode field : this.fields) {
            SignatureParser sp = SignatureParser.fromNode(field);
            if (sp == null) continue;
            try {
                ArgType gType = sp.consumeType();
                if (gType == null) continue;
                field.setType(gType);
            }
            catch (JadxRuntimeException e) {
                LOG.error("Field signature parse error: {}", (Object)field, (Object)e);
            }
        }
    }

    private void addSourceFilenameAttr(String fileName) {
        if (fileName == null) {
            return;
        }
        if (fileName.endsWith(".java")) {
            fileName = fileName.substring(0, fileName.length() - 5);
        }
        if (fileName.isEmpty() || fileName.equals("SourceFile") || fileName.equals("\"")) {
            return;
        }
        if (this.clsInfo != null) {
            String name = this.clsInfo.getShortName();
            if (fileName.equals(name)) {
                return;
            }
            if (fileName.contains("$") && fileName.endsWith("$" + name)) {
                return;
            }
            ClassInfo parentClass = this.clsInfo.getTopParentClass();
            if (parentClass != null && fileName.equals(parentClass.getShortName())) {
                return;
            }
        }
        this.addAttr(new SourceFileAttr(fileName));
        LOG.debug("Class '{}' compiled from '{}'", (Object)this, (Object)fileName);
    }

    @Override
    public void load() {
        for (MethodNode mth : this.getMethods()) {
            try {
                mth.load();
            }
            catch (Exception e) {
                LOG.error("Method load error: {}", (Object)mth, (Object)e);
                mth.addAttr(new JadxErrorAttr(e));
            }
        }
        for (ClassNode innerCls : this.getInnerClasses()) {
            innerCls.load();
        }
    }

    @Override
    public void unload() {
        for (MethodNode mth : this.getMethods()) {
            mth.unload();
        }
        for (ClassNode innerCls : this.getInnerClasses()) {
            innerCls.unload();
        }
    }

    @Nullable
    public ArgType getSuperClass() {
        return this.superClass;
    }

    public List<ArgType> getInterfaces() {
        return this.interfaces;
    }

    public Map<ArgType, List<ArgType>> getGenericMap() {
        return this.genericMap;
    }

    public List<MethodNode> getMethods() {
        return this.methods;
    }

    public List<FieldNode> getFields() {
        return this.fields;
    }

    public FieldNode getConstField(Object obj) {
        return this.getConstField(obj, true);
    }

    public FieldNode getConstField(Object obj, boolean searchGlobal) {
        String str;
        FieldNode field;
        ClassNode cn = this;
        while ((field = cn.constFields.get(obj)) == null && cn.clsInfo.getParentClass() != null && (cn = this.dex.resolveClass(cn.clsInfo.getParentClass())) != null) {
        }
        if (field == null && searchGlobal) {
            field = this.dex.getConstFields().get(obj);
        }
        if (obj instanceof Integer && (str = this.dex.root().getResourcesNames().get(obj)) != null) {
            ResRefField resField = new ResRefField(this.dex, str.replace('/', '.'));
            if (field == null) {
                return resField;
            }
            if (!field.getName().equals(resField.getName())) {
                field = resField;
            }
        }
        return field;
    }

    public FieldNode getConstFieldByLiteralArg(LiteralArg arg) {
        PrimitiveType type = arg.getType().getPrimitiveType();
        if (type == null) {
            return null;
        }
        long literal = arg.getLiteral();
        switch (type) {
            case BOOLEAN: {
                return this.getConstField(literal == 1L, false);
            }
            case CHAR: {
                return this.getConstField(Character.valueOf((char)literal), Math.abs(literal) > 10L);
            }
            case BYTE: {
                return this.getConstField((byte)literal, Math.abs(literal) > 10L);
            }
            case SHORT: {
                return this.getConstField((short)literal, Math.abs(literal) > 100L);
            }
            case INT: {
                return this.getConstField((int)literal, Math.abs(literal) > 100L);
            }
            case LONG: {
                return this.getConstField(literal, Math.abs(literal) > 1000L);
            }
            case FLOAT: {
                float f = Float.intBitsToFloat((int)literal);
                return this.getConstField(Float.valueOf(f), (double)f != 0.0);
            }
            case DOUBLE: {
                double d = Double.longBitsToDouble(literal);
                return this.getConstField(d, d != 0.0);
            }
        }
        return null;
    }

    public FieldNode searchFieldById(int id) {
        return this.searchField(FieldInfo.fromDex(this.dex, id));
    }

    public FieldNode searchField(FieldInfo field) {
        for (FieldNode f : this.fields) {
            if (!f.getFieldInfo().equals(field)) continue;
            return f;
        }
        return null;
    }

    public FieldNode searchFieldByName(String name) {
        for (FieldNode f : this.fields) {
            if (!f.getName().equals(name)) continue;
            return f;
        }
        return null;
    }

    public MethodNode searchMethod(MethodInfo mth) {
        for (MethodNode m : this.methods) {
            if (!m.getMethodInfo().equals(mth)) continue;
            return m;
        }
        return null;
    }

    public MethodNode searchMethodByName(String shortId) {
        for (MethodNode m : this.methods) {
            if (!m.getMethodInfo().getShortId().equals(shortId)) continue;
            return m;
        }
        return null;
    }

    public MethodNode searchMethodById(int id) {
        return this.searchMethodByName(MethodInfo.fromDex(this.dex, id).getShortId());
    }

    public ClassNode getParentClass() {
        if (this.parentClass == null) {
            ClassNode parent;
            this.parentClass = this.clsInfo.isInner() ? (parent = (parent = this.dex().resolveClass(this.clsInfo.getParentClass())) == null ? this : parent) : this;
        }
        return this.parentClass;
    }

    public ClassNode getTopParentClass() {
        ClassNode parent = this.getParentClass();
        return parent == this ? this : parent.getParentClass();
    }

    public List<ClassNode> getInnerClasses() {
        return this.innerClasses;
    }

    public void addInnerClass(ClassNode cls) {
        if (this.innerClasses.isEmpty()) {
            this.innerClasses = new ArrayList<ClassNode>(3);
        }
        this.innerClasses.add(cls);
    }

    public boolean isEnum() {
        return this.getAccessFlags().isEnum() && this.getSuperClass() != null && this.getSuperClass().getObject().equals(ArgType.ENUM.getObject());
    }

    public boolean isAnonymous() {
        return this.clsInfo.isInner() && this.clsInfo.getAlias().getShortName().startsWith("AnonymousClass") && this.getDefaultConstructor() != null;
    }

    public MethodNode getDefaultConstructor() {
        for (MethodNode mth : this.methods) {
            if (!mth.isDefaultConstructor()) continue;
            return mth;
        }
        return null;
    }

    public AccessInfo getAccessFlags() {
        return this.accessFlags;
    }

    public DexNode dex() {
        return this.dex;
    }

    public String getRawName() {
        return this.clsInfo.getRawName();
    }

    public ClassInfo getClassInfo() {
        return this.clsInfo;
    }

    public ClassInfo getAlias() {
        return this.clsInfo.getAlias();
    }

    public String getShortName() {
        return this.clsInfo.getAlias().getShortName();
    }

    public String getFullName() {
        return this.clsInfo.getAlias().getFullName();
    }

    public String getPackage() {
        return this.clsInfo.getAlias().getPackage();
    }

    public void setCode(CodeWriter code) {
        this.code = code;
    }

    public CodeWriter getCode() {
        return this.code;
    }

    public ProcessState getState() {
        return this.state;
    }

    public void setState(ProcessState state) {
        this.state = state;
    }

    public Set<ClassNode> getDependencies() {
        return this.dependencies;
    }

    public String toString() {
        return this.clsInfo.getFullName();
    }
}

