/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.format.nodes.read;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import org.jruby.truffle.format.nodes.PackNode;
import org.jruby.truffle.format.nodes.SourceNode;
import org.jruby.truffle.format.nodes.type.ToDoubleNode;
import org.jruby.truffle.format.nodes.type.ToDoubleNodeGen;
import org.jruby.truffle.runtime.RubyContext;

@NodeChildren(value={@NodeChild(value="source", type=SourceNode.class)})
public abstract class ReadDoubleNode
extends PackNode {
    @Node.Child
    private ToDoubleNode toDoubleNode;

    public ReadDoubleNode(RubyContext context) {
        super(context);
    }

    @Specialization(guards={"isNull(source)"})
    public double read(VirtualFrame frame, Object source) {
        CompilerDirectives.transferToInterpreter();
        this.advanceSourcePosition(frame);
        throw new IllegalStateException();
    }

    @Specialization
    public double read(VirtualFrame frame, int[] source) {
        return source[this.advanceSourcePosition(frame)];
    }

    @Specialization
    public double read(VirtualFrame frame, long[] source) {
        return source[this.advanceSourcePosition(frame)];
    }

    @Specialization
    public double read(VirtualFrame frame, double[] source) {
        return source[this.advanceSourcePosition(frame)];
    }

    @Specialization
    public double read(VirtualFrame frame, Object[] source) {
        if (this.toDoubleNode == null) {
            CompilerDirectives.transferToInterpreter();
            this.toDoubleNode = this.insert(ToDoubleNodeGen.create(this.getContext(), null));
        }
        return this.toDoubleNode.executeToDouble(frame, source[this.advanceSourcePosition(frame)]);
    }
}

