/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.layouts;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.IncompatibleLocationException;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.util.EnumSet;
import org.joda.time.DateTime;
import org.jruby.truffle.om.dsl.api.UnexpectedLayoutRefusalException;
import org.jruby.truffle.runtime.layouts.BasicObjectLayoutImpl;
import org.jruby.truffle.runtime.layouts.TimeLayout;

public class TimeLayoutImpl
extends BasicObjectLayoutImpl
implements TimeLayout {
    public static final TimeLayout INSTANCE = new TimeLayoutImpl();
    protected static final Shape.Allocator TIME_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey DATE_TIME_IDENTIFIER = new HiddenKey("dateTime");
    protected static final Property DATE_TIME_PROPERTY = Property.create(DATE_TIME_IDENTIFIER, TIME_ALLOCATOR.locationForType(DateTime.class, EnumSet.of(LocationModifier.NonNull)), 0);
    protected static final HiddenKey N_SEC_IDENTIFIER = new HiddenKey("nSec");
    protected static final Property N_SEC_PROPERTY = Property.create(N_SEC_IDENTIFIER, TIME_ALLOCATOR.locationForType(Long.TYPE, EnumSet.of(LocationModifier.NonNull)), 0);
    protected static final HiddenKey ZONE_IDENTIFIER = new HiddenKey("zone");
    protected static final Property ZONE_PROPERTY = Property.create(ZONE_IDENTIFIER, TIME_ALLOCATOR.locationForType(Object.class, EnumSet.of(LocationModifier.NonNull)), 0);
    protected static final HiddenKey OFFSET_IDENTIFIER = new HiddenKey("offset");
    protected static final Property OFFSET_PROPERTY = Property.create(OFFSET_IDENTIFIER, TIME_ALLOCATOR.locationForType(Object.class, EnumSet.of(LocationModifier.NonNull)), 0);
    protected static final HiddenKey RELATIVE_OFFSET_IDENTIFIER = new HiddenKey("relativeOffset");
    protected static final Property RELATIVE_OFFSET_PROPERTY = Property.create(RELATIVE_OFFSET_IDENTIFIER, TIME_ALLOCATOR.locationForType(Boolean.TYPE, EnumSet.of(LocationModifier.NonNull)), 0);
    protected static final HiddenKey IS_UTC_IDENTIFIER = new HiddenKey("isUtc");
    protected static final Property IS_UTC_PROPERTY = Property.create(IS_UTC_IDENTIFIER, TIME_ALLOCATOR.locationForType(Boolean.TYPE, EnumSet.of(LocationModifier.NonNull)), 0);

    protected TimeLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createTimeShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape(new TimeType(logicalClass, metaClass)).addProperty(DATE_TIME_PROPERTY).addProperty(N_SEC_PROPERTY).addProperty(ZONE_PROPERTY).addProperty(OFFSET_PROPERTY).addProperty(RELATIVE_OFFSET_PROPERTY).addProperty(IS_UTC_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createTime(DynamicObjectFactory factory, DateTime dateTime, long nSec, Object zone, Object offset, boolean relativeOffset, boolean isUtc) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant(factory);
        assert (this.createsTime(factory));
        assert (factory.getShape().hasProperty(DATE_TIME_IDENTIFIER));
        assert (factory.getShape().hasProperty(N_SEC_IDENTIFIER));
        assert (factory.getShape().hasProperty(ZONE_IDENTIFIER));
        assert (factory.getShape().hasProperty(OFFSET_IDENTIFIER));
        assert (factory.getShape().hasProperty(RELATIVE_OFFSET_IDENTIFIER));
        assert (factory.getShape().hasProperty(IS_UTC_IDENTIFIER));
        assert (dateTime != null);
        assert (zone != null);
        assert (offset != null);
        return factory.newInstance(dateTime, nSec, zone, offset, relativeOffset, isUtc);
    }

    @Override
    public boolean isTime(DynamicObject object) {
        return this.isTime(object.getShape().getObjectType());
    }

    private boolean isTime(ObjectType objectType) {
        return objectType instanceof TimeType;
    }

    private boolean createsTime(DynamicObjectFactory factory) {
        return this.isTime(factory.getShape().getObjectType());
    }

    @Override
    public DateTime getDateTime(DynamicObject object) {
        assert (this.isTime(object));
        assert (object.getShape().hasProperty(DATE_TIME_IDENTIFIER));
        return (DateTime)DATE_TIME_PROPERTY.get(object, true);
    }

    @Override
    public void setDateTime(DynamicObject object, DateTime value) {
        assert (this.isTime(object));
        assert (object.getShape().hasProperty(DATE_TIME_IDENTIFIER));
        assert (value != null);
        try {
            DATE_TIME_PROPERTY.set(object, value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnexpectedLayoutRefusalException(e);
        }
    }

    @Override
    public long getNSec(DynamicObject object) {
        assert (this.isTime(object));
        assert (object.getShape().hasProperty(N_SEC_IDENTIFIER));
        return (Long)N_SEC_PROPERTY.get(object, true);
    }

    @Override
    public void setNSec(DynamicObject object, long value) {
        assert (this.isTime(object));
        assert (object.getShape().hasProperty(N_SEC_IDENTIFIER));
        try {
            N_SEC_PROPERTY.set(object, value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnexpectedLayoutRefusalException(e);
        }
    }

    @Override
    public Object getZone(DynamicObject object) {
        assert (this.isTime(object));
        assert (object.getShape().hasProperty(ZONE_IDENTIFIER));
        return ZONE_PROPERTY.get(object, true);
    }

    @Override
    public void setZone(DynamicObject object, Object value) {
        assert (this.isTime(object));
        assert (object.getShape().hasProperty(ZONE_IDENTIFIER));
        assert (value != null);
        try {
            ZONE_PROPERTY.set(object, value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnexpectedLayoutRefusalException(e);
        }
    }

    @Override
    public Object getOffset(DynamicObject object) {
        assert (this.isTime(object));
        assert (object.getShape().hasProperty(OFFSET_IDENTIFIER));
        return OFFSET_PROPERTY.get(object, true);
    }

    @Override
    public void setOffset(DynamicObject object, Object value) {
        assert (this.isTime(object));
        assert (object.getShape().hasProperty(OFFSET_IDENTIFIER));
        assert (value != null);
        try {
            OFFSET_PROPERTY.set(object, value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnexpectedLayoutRefusalException(e);
        }
    }

    @Override
    public boolean getRelativeOffset(DynamicObject object) {
        assert (this.isTime(object));
        assert (object.getShape().hasProperty(RELATIVE_OFFSET_IDENTIFIER));
        return (Boolean)RELATIVE_OFFSET_PROPERTY.get(object, true);
    }

    @Override
    public void setRelativeOffset(DynamicObject object, boolean value) {
        assert (this.isTime(object));
        assert (object.getShape().hasProperty(RELATIVE_OFFSET_IDENTIFIER));
        try {
            RELATIVE_OFFSET_PROPERTY.set(object, value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnexpectedLayoutRefusalException(e);
        }
    }

    @Override
    public boolean getIsUtc(DynamicObject object) {
        assert (this.isTime(object));
        assert (object.getShape().hasProperty(IS_UTC_IDENTIFIER));
        return (Boolean)IS_UTC_PROPERTY.get(object, true);
    }

    @Override
    public void setIsUtc(DynamicObject object, boolean value) {
        assert (this.isTime(object));
        assert (object.getShape().hasProperty(IS_UTC_IDENTIFIER));
        try {
            IS_UTC_PROPERTY.set(object, value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnexpectedLayoutRefusalException(e);
        }
    }

    protected static class TimeType
    extends BasicObjectLayoutImpl.BasicObjectType {
        public TimeType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public TimeType setLogicalClass(DynamicObject logicalClass) {
            return new TimeType(logicalClass, this.metaClass);
        }

        @Override
        public TimeType setMetaClass(DynamicObject metaClass) {
            return new TimeType(this.logicalClass, metaClass);
        }
    }
}

