/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import java.awt.Font;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class OutputViewer {
    private static JFrame frame;
    private static JTextArea ta;

    public static void init() {
    }

    private static void append(String s) {
        if (frame == null) {
            frame = new JFrame("JConsole: Output");
            ta = new JTextArea();
            ta.setEditable(false);
            frame.getContentPane().add(new JScrollPane(ta));
            ta.setFont(new Font("Monospaced", 1, 14));
            frame.setSize(500, 600);
            frame.setLocation(524, 168);
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    if (JFrame.getFrames().length == 1) {
                        System.exit(0);
                    }
                }
            });
        }
        ta.append(s);
        ta.setCaretPosition(ta.getText().length());
        frame.setVisible(true);
    }

    private static void appendln(String s) {
        OutputViewer.append(s + "\n");
    }

    static {
        System.setOut(PipeListener.create("System.out"));
        System.setErr(PipeListener.create("System.err"));
    }

    private static class PipeListener
    extends Thread {
        public PrintStream ps;
        private String name;
        private PipedInputStream inPipe;
        private BufferedReader br;

        public static PrintStream create(String name) {
            return new PipeListener((String)name).ps;
        }

        private PipeListener(String name) {
            this.name = name;
            try {
                this.inPipe = new PipedInputStream();
                this.ps = new PrintStream(new PipedOutputStream(this.inPipe));
                this.br = new BufferedReader(new InputStreamReader(this.inPipe));
            }
            catch (IOException e) {
                OutputViewer.appendln("PipeListener<init>(" + name + "): " + e);
            }
            this.start();
        }

        @Override
        public void run() {
            try {
                String str;
                while ((str = this.br.readLine()) != null) {
                    OutputViewer.appendln(str);
                    try {
                        Field f = PipedInputStream.class.getDeclaredField("writeSide");
                        f.setAccessible(true);
                        f.set(this.inPipe, this);
                    }
                    catch (Exception e) {
                        OutputViewer.appendln("PipeListener(" + this.name + ").run: " + e);
                    }
                }
                OutputViewer.appendln("-- " + this.name + " closed --");
                this.br.close();
            }
            catch (IOException e) {
                OutputViewer.appendln("PipeListener(" + this.name + ").run: " + e);
            }
        }
    }
}

