// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _IFSelect_Act_HeaderFile
#define _IFSelect_Act_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineHandle.hxx>
#include <Handle_IFSelect_Act.hxx>

#include <TCollection_AsciiString.hxx>
#include <IFSelect_ActFunc.hxx>
#include <IFSelect_Activator.hxx>
#include <Standard_CString.hxx>
#include <IFSelect_ReturnStatus.hxx>
#include <Standard_Integer.hxx>
#include <Handle_IFSelect_SessionPilot.hxx>
class Standard_DomainError;
class IFSelect_SessionPilot;


//! Act gives a simple way to define and add functions to be ran
//! from a SessionPilot, as follows :
//!
//! Define a function as
//! static IFSelect_RetStatus myfunc
//! (const Standard_CString name,
//! const Handle(IFSelect_SessionPilot)& pilot)
//! { ... }
//! When ran, it receives the exact name (string) of the called
//! function, and the SessionPilot which brings other infos
//!
//! Add it by
//! IFSelect_Act::AddFunc (name,help,myfunc);
//! for a normal function, or
//! IFSelect_Act::AddFSet (name,help,myfunc);
//! for a function which is intended to create a control item
//! name and help are given as CString
//!
//! Then, it is available for run
class IFSelect_Act : public IFSelect_Activator
{

public:

  
  //! Creates an Act with a name, help and a function
  //! mode (Add or AddSet) is given when recording
  Standard_EXPORT IFSelect_Act(const Standard_CString name, const Standard_CString help, const IFSelect_ActFunc func);
  
  //! Execution of Command Line. remark that <number> is senseless
  //! because each Act brings one and only one function
  Standard_EXPORT   IFSelect_ReturnStatus Do (const Standard_Integer number, const Handle(IFSelect_SessionPilot)& pilot) ;
  
  //! Short Help for commands : returns the help given to create
  Standard_EXPORT   Standard_CString Help (const Standard_Integer number)  const;
  
  //! Changes the default group name for the following Acts
  //! group empty means to come back to default from Activator
  //! Also a file name can be precised (to query by getsource)
  Standard_EXPORT static   void SetGroup (const Standard_CString group, const Standard_CString file = "") ;
  
  //! Adds a function with its name and help : creates an Act then
  //! records it as normal function
  Standard_EXPORT static   void AddFunc (const Standard_CString name, const Standard_CString help, const IFSelect_ActFunc func) ;
  
  //! Adds a function with its name and help : creates an Act then
  //! records it as function for XSET (i.e. to create control item)
  Standard_EXPORT static   void AddFSet (const Standard_CString name, const Standard_CString help, const IFSelect_ActFunc func) ;




  DEFINE_STANDARD_RTTI(IFSelect_Act)

protected:




private: 


  TCollection_AsciiString thename;
  TCollection_AsciiString thehelp;
  IFSelect_ActFunc thefunc;


};







#endif // _IFSelect_Act_HeaderFile
