/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.pd.PDCSSpecial;
import de.intarsys.pdf.pd.PDColorSpace;

public class PDCSIndexed
extends PDCSSpecial {
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    private PDColorSpace baseColorSpace;
    private byte[] colorBytes;
    private int colorCount;

    protected PDCSIndexed(COSObject cOSObject) {
        super(cOSObject);
        this.baseColorSpace = (PDColorSpace)PDColorSpace.META.createFromCos(cOSObject.asArray().get(1));
        this.colorCount = cOSObject.asArray().get(2).asInteger().intValue() + 1;
        COSObject cOSObject2 = cOSObject.asArray().get(3);
        this.colorBytes = cOSObject2 instanceof COSStream ? ((COSStream)cOSObject2).getDecodedBytes() : cOSObject2.asString().byteValue();
    }

    public PDColorSpace getBaseColorSpace() {
        return this.baseColorSpace;
    }

    public byte[] getColorBytes() {
        return this.colorBytes;
    }

    public int getColorCount() {
        return this.colorCount;
    }

    public static class MetaClass
    extends PDCSSpecial.MetaClass {
        protected MetaClass(Class clazz) {
            super(clazz);
        }

        @Override
        public COSBasedObject doCreateCOSBasedObjectBasic(COSObject cOSObject) {
            return new PDCSIndexed(cOSObject);
        }
    }
}

