/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.content.CSContent;
import de.intarsys.pdf.content.IContentStreamProvider;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.pd.IAdditionalActionSupport;
import de.intarsys.pdf.pd.PDAdditionalActions;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDApplicationData;
import de.intarsys.pdf.pd.PDObject;
import de.intarsys.pdf.pd.PDPageNode;
import de.intarsys.pdf.pd.PDPageTree;
import de.intarsys.pdf.pd.PDResources;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PDPage
extends PDPageNode
implements IAdditionalActionSupport,
IContentStreamProvider {
    public static String COPY_SUFFIX = "_copy";
    public static final COSName DK_Annots = COSName.constant("Annots");
    public static final COSName DK_Contents = COSName.constant("Contents");
    public static final COSName DK_CropBox = COSName.constant("CropBox");
    public static final COSName DK_MediaBox = COSName.constant("MediaBox");
    public static final COSName DK_Metadata = COSName.constant("Metadata");
    public static final COSName DK_PieceInfo = COSName.constant("PieceInfo");
    public static final COSName DK_Resources = COSName.constant("Resources");
    public static final COSName DK_TemplateInstantiated = COSName.constant("TemplateInstantiated");
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    private static final List NULL = new ArrayList();
    public static final Set PAGE_ACTION_TRIGGERS = new HashSet(3);
    private SoftReference cachedAnnotations = null;
    private SoftReference cachedContentStream = null;

    static {
        PAGE_ACTION_TRIGGERS.add("O");
        PAGE_ACTION_TRIGGERS.add("C");
    }

    protected PDPage(COSObject cOSObject) {
        super(cOSObject);
    }

    public void addAnnotation(PDAnnotation pDAnnotation) {
        COSArray cOSArray = this.cosGetField(DK_Annots).asArray();
        if (cOSArray == null) {
            cOSArray = COSArray.create();
            cOSArray.beIndirect();
            this.cosSetField(DK_Annots, cOSArray);
            this.cachedAnnotations = null;
        }
        cOSArray.add(pDAnnotation.cosGetDict());
        pDAnnotation.setPage(this);
    }

    public void addContentStream(CSContent cSContent) {
        this.cosAddContents(cSContent.createStream());
    }

    @Override
    protected void collectAnnotations(List list) {
        if (this.getAnnotations() != null) {
            list.addAll(this.getAnnotations());
        }
    }

    public void cosAddContents(COSStream cOSStream) {
        COSArray cOSArray;
        COSObject cOSObject = this.cosGetField(DK_Contents);
        if (cOSObject.isNull()) {
            this.cosSetField(DK_Contents, cOSStream);
        }
        if (cOSObject instanceof COSStream) {
            cOSArray = COSArray.create(2);
            cOSArray.add(cOSObject);
            cOSArray.add(cOSStream);
            this.cosSetField(DK_Contents, cOSArray);
        }
        if (cOSObject instanceof COSArray) {
            cOSArray = (COSArray)cOSObject;
            cOSArray.add(cOSStream);
        }
    }

    public COSObject cosGetContents() {
        return this.cosGetField(DK_Contents);
    }

    @Override
    protected COSName cosGetExpectedType() {
        return CN_Type_Page;
    }

    public COSDictionary cosGetPieceInfo() {
        return this.cosGetField(DK_PieceInfo).asDictionary();
    }

    public COSName cosGetTemplateInstantiated() {
        return this.cosGetField(DK_TemplateInstantiated).asName();
    }

    public void cosPrependContents(COSStream cOSStream) {
        COSArray cOSArray;
        COSObject cOSObject = this.cosGetField(DK_Contents);
        if (cOSObject.isNull()) {
            this.cosSetField(DK_Contents, cOSStream);
        }
        if (cOSObject instanceof COSStream) {
            cOSArray = COSArray.create(2);
            cOSArray.add(cOSStream);
            cOSArray.add(cOSObject);
            this.cosSetField(DK_Contents, cOSArray);
        }
        if (cOSObject instanceof COSArray) {
            cOSArray = (COSArray)cOSObject;
            cOSArray.add(0, cOSStream);
        }
    }

    public COSObject cosSetContents(COSObject cOSObject) {
        return this.cosSetField(DK_Contents, cOSObject);
    }

    public COSDictionary cosSetPieceInfo(COSDictionary cOSDictionary) {
        if (cOSDictionary != null) {
            cOSDictionary.beIndirect();
        }
        return this.cosSetField(DK_PieceInfo, cOSDictionary).asDictionary();
    }

    public void cosSetTemplateInstantiated(COSName cOSName) {
        this.cosSetField(DK_TemplateInstantiated, cOSName);
    }

    @Override
    public void dispose() {
        if (this.getAnnotations() != null) {
            for (PDAnnotation pDAnnotation : this.getAnnotations()) {
                pDAnnotation.dispose();
            }
        }
        super.dispose();
    }

    protected void getAcroFormFields(PDObject pDObject, List list) {
        List list2 = pDObject.getGenericChildren();
        List<PDAnnotation> list3 = this.getAnnotations();
        if (list2 == null) {
            return;
        }
        for (PDObject pDObject2 : list2) {
            if (list3.contains(pDObject2)) {
                list.add(pDObject2);
            }
            this.getAcroFormFields(pDObject2, list);
        }
    }

    @Override
    public PDAdditionalActions getAdditionalActions() {
        COSDictionary cOSDictionary = this.cosGetField(DK_AA).asDictionary();
        return (PDAdditionalActions)PDAdditionalActions.META.createFromCos(cOSDictionary);
    }

    public List<PDAnnotation> getAnnotations() {
        List list = null;
        if (this.cachedAnnotations != null) {
            list = (List)this.cachedAnnotations.get();
        }
        if (list == null) {
            list = this.getPDObjects(DK_Annots, PDAnnotation.META, true);
            if (list == null) {
                list = NULL;
            }
            this.cachedAnnotations = new SoftReference<List>(list);
        }
        if (list == NULL) {
            return null;
        }
        return list;
    }

    public PDApplicationData getApplicationData(String string) {
        COSDictionary cOSDictionary = this.cosGetPieceInfo();
        if (cOSDictionary == null) {
            return null;
        }
        COSName cOSName = COSName.createUTF8(string);
        COSDictionary cOSDictionary2 = cOSDictionary.get(cOSName).asDictionary();
        if (cOSDictionary2 == null) {
            return null;
        }
        return (PDApplicationData)PDApplicationData.META.createFromCos(cOSDictionary2);
    }

    protected int getContentsSize() {
        COSObject cOSObject = this.cosGetContents();
        if (cOSObject.isNull()) {
            return 0;
        }
        if (cOSObject instanceof COSStream) {
            return 1;
        }
        return ((COSArray)cOSObject).size();
    }

    @Override
    public CSContent getContentStream() {
        COSObject cOSObject;
        CSContent cSContent = null;
        if (this.cachedContentStream != null) {
            cSContent = (CSContent)this.cachedContentStream.get();
        }
        if (cSContent == null && !(cOSObject = this.cosGetContents()).isNull()) {
            cSContent = cOSObject instanceof COSStream ? CSContent.createFromCos(cOSObject.asStream()) : CSContent.createFromCos(cOSObject.asArray());
            cOSObject.removeObjectListener(this);
            cOSObject.addObjectListener(this);
            this.cachedContentStream = new SoftReference<CSContent>(cSContent);
        }
        return cSContent;
    }

    @Override
    public int getCount() {
        return 1;
    }

    @Override
    public PDAnnotation getFirstAnnotation() {
        if (this.getAnnotations() == null) {
            return null;
        }
        if (this.getAnnotations().size() == 0) {
            return null;
        }
        return this.getAnnotations().get(0);
    }

    @Override
    public PDPageNode getFirstNode() {
        return this;
    }

    @Override
    public PDPage getFirstPage() {
        return this;
    }

    @Override
    public PDAnnotation getLastAnnotation() {
        if (this.getAnnotations() == null) {
            return null;
        }
        int n = this.getAnnotations().size();
        if (n == 0) {
            return null;
        }
        return this.getAnnotations().get(n - 1);
    }

    @Override
    public PDPageNode getLastNode() {
        return this;
    }

    @Override
    public PDPage getLastPage() {
        return this;
    }

    public PDAnnotation getNextAnnotation(PDAnnotation pDAnnotation) {
        if (this.getAnnotations() == null) {
            return null;
        }
        int n = this.getAnnotations().indexOf(pDAnnotation);
        if (n == -1) {
            return null;
        }
        if (n + 1 < this.getAnnotations().size()) {
            return this.getAnnotations().get(n + 1);
        }
        return null;
    }

    public PDPage getNextPage() {
        PDPageTree pDPageTree = this.getParent();
        if (pDPageTree == null) {
            return null;
        }
        return pDPageTree.getNextPage(this);
    }

    @Override
    public PDPage getPageAt(int n) {
        if (n == 0) {
            return this;
        }
        return super.getPageAt(n);
    }

    public PDAnnotation getPreviousAnnotation(PDAnnotation pDAnnotation) {
        if (this.getAnnotations() == null) {
            return null;
        }
        int n = this.getAnnotations().indexOf(pDAnnotation);
        if (n == -1) {
            return null;
        }
        if (n - 1 >= 0) {
            return this.getAnnotations().get(n - 1);
        }
        return null;
    }

    public PDPage getPreviousPage() {
        PDPageTree pDPageTree = this.getParent();
        if (pDPageTree == null) {
            return null;
        }
        return pDPageTree.getPreviousPage(this);
    }

    @Override
    public PDResources getResources() {
        COSDictionary cOSDictionary = this.cosGetFieldInheritable(DK_Resources).asDictionary();
        return (PDResources)PDResources.META.createFromCos(cOSDictionary);
    }

    @Override
    public Set getSupportedTriggerEvents() {
        return PAGE_ACTION_TRIGGERS;
    }

    @Override
    protected void initializeFromScratch() {
        super.initializeFromScratch();
        this.setMediaBox(new CDSRectangle(CDSRectangle.SIZE_A4));
    }

    @Override
    public void invalidateCaches() {
        super.invalidateCaches();
        this.cachedAnnotations = null;
        this.cachedContentStream = null;
        COSObject cOSObject = this.cosGetField(DK_Annots);
        cOSObject.removeObjectListener(this);
        COSObject cOSObject2 = this.cosGetField(DK_Contents);
        cOSObject2.removeObjectListener(this);
    }

    @Override
    public boolean isPage() {
        return true;
    }

    @Override
    public boolean isValid() {
        PDPageTree pDPageTree = this.getParent();
        if (pDPageTree == null) {
            return false;
        }
        return pDPageTree.isValid();
    }

    public void prependContentStream(CSContent cSContent) {
        this.cosPrependContents(cSContent.createStream());
    }

    public void removeAnnotation(PDAnnotation pDAnnotation) {
        COSArray cOSArray = this.cosGetField(DK_Annots).asArray();
        if (cOSArray != null) {
            cOSArray.remove(pDAnnotation.cosGetDict());
            if (cOSArray.isEmpty()) {
                this.cosRemoveField(DK_Annots);
            }
        }
    }

    public void removeApplicationData(String string) {
        COSDictionary cOSDictionary = this.cosGetPieceInfo();
        if (cOSDictionary == null) {
            return;
        }
        COSName cOSName = COSName.createUTF8(string);
        cOSDictionary.remove(cOSName);
    }

    @Override
    public void setAdditionalActions(PDAdditionalActions pDAdditionalActions) {
        this.setFieldObject(DK_AA, pDAdditionalActions);
    }

    public void setApplicationData(String string, PDApplicationData pDApplicationData) {
        COSDictionary cOSDictionary = this.cosGetPieceInfo();
        if (cOSDictionary == null) {
            cOSDictionary = COSDictionary.create();
            this.cosSetPieceInfo(cOSDictionary);
        }
        COSName cOSName = COSName.createUTF8(string);
        cOSDictionary.put(cOSName, pDApplicationData.cosGetDict());
    }

    @Override
    public void setContentStream(CSContent cSContent) {
        if (cSContent != null) {
            this.cosSetContents(cSContent.createStream());
        } else {
            this.cosSetContents(null);
        }
    }

    @Override
    public void setResources(PDResources pDResources) {
        this.cosSetField(DK_Resources, pDResources.cosGetDict());
    }

    public static class MetaClass
    extends PDPageNode.MetaClass {
        protected MetaClass(Class clazz) {
            super(clazz);
        }

        @Override
        protected COSBasedObject doCreateCOSBasedObject(COSObject cOSObject) {
            return new PDPage(cOSObject);
        }
    }
}

