/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.openide.util.Utilities;

public final class TopologicalSortException
extends Exception {
    private Collection vertexes;
    private Map<?, ? extends Collection<?>> edges;
    private Set[] result;
    private int counter;
    private Stack<Vertex> dualGraph = new Stack();

    TopologicalSortException(Collection collection, Map<?, ? extends Collection<?>> map) {
        this.vertexes = collection;
        this.edges = map;
    }

    public final List partialSort() {
        Set[] setArray = this.topologicalSets();
        ArrayList arrayList = new ArrayList(this.vertexes.size());
        for (int i = 0; i < setArray.length; ++i) {
            for (Object e : setArray[i]) {
                arrayList.add(e);
            }
        }
        return arrayList;
    }

    public final Set[] unsortableSets() {
        Set[] setArray = this.topologicalSets();
        ArrayList<Set> arrayList = new ArrayList<Set>();
        for (int i = 0; i < setArray.length; ++i) {
            if (setArray[i].size() <= 1 && setArray[i] instanceof HashSet) continue;
            arrayList.add(setArray[i]);
        }
        return arrayList.toArray(new Set[0]);
    }

    @Override
    public String getMessage() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.printDebug(printWriter);
        printWriter.close();
        return stringWriter.toString();
    }

    @Override
    public String toString() {
        String string = this.getClass().getName();
        return string;
    }

    private void printDebug(PrintWriter printWriter) {
        HashSet hashSet = new HashSet();
        Set[] setArray = this.unsortableSets();
        for (Set hashSet2 : setArray) {
            hashSet.addAll(hashSet2);
        }
        HashMap hashMap = new HashMap();
        for (Map.Entry<?, Collection<?>> entry : this.edges.entrySet()) {
            HashSet hashSet2 = new HashSet(entry.getValue());
            hashSet2.add(entry.getKey());
            hashSet2.retainAll(hashSet);
            if (hashSet2.isEmpty()) continue;
            hashMap.put(entry.getKey(), entry.getValue());
        }
        printWriter.print("TopologicalSortException - Collection with relevant edges ");
        printWriter.print(hashMap);
        printWriter.println(" cannot be sorted");
        for (int i = 0; i < setArray.length; ++i) {
            printWriter.print(" Conflict #");
            printWriter.print(i);
            printWriter.print(": ");
            printWriter.println(setArray[i]);
        }
    }

    @Override
    public final void printStackTrace(PrintWriter printWriter) {
        this.printDebug(printWriter);
        super.printStackTrace(printWriter);
    }

    @Override
    public final void printStackTrace(PrintStream printStream) {
        PrintWriter printWriter = new PrintWriter(printStream);
        this.printStackTrace(printWriter);
        printWriter.flush();
    }

    /*
     * WARNING - void declaration
     */
    public final Set[] topologicalSets() {
        Object object2;
        if (this.result != null) {
            return this.result;
        }
        HashMap<Object, Vertex> hashMap = new HashMap<Object, Vertex>();
        this.counter = 0;
        Iterator<Object> iterator = this.vertexes.iterator();
        while (iterator.hasNext()) {
            this.constructDualGraph(this.counter, iterator.next(), hashMap);
        }
        HashMap<Object, void> hashMap2 = new HashMap<Object, void>();
        ArrayList<void> arrayList = new ArrayList<void>();
        while (!this.dualGraph.isEmpty()) {
            void object3;
            object2 = this.dualGraph.pop();
            if (((Vertex)object2).visited) continue;
            HashSet<Object> topologicalSortException = new HashSet<Object>();
            this.visitDualGraph((Vertex)object2, topologicalSortException);
            if (topologicalSortException.size() == 1 && ((Vertex)object2).edgesFrom.contains(object2)) {
                Set<Object> set = Collections.singleton(((Vertex)object2).object);
            }
            arrayList.add(object3);
            iterator = object3.iterator();
            while (iterator.hasNext()) {
                hashMap2.put(iterator.next(), object3);
            }
        }
        object2 = new HashMap();
        for (Map.Entry entry : this.edges.entrySet()) {
            Collection collection = (Collection)entry.getValue();
            if (collection == null || collection.isEmpty()) continue;
            Set set = (Set)hashMap2.get(entry.getKey());
            ArrayList<Set> arrayList2 = (ArrayList<Set>)((HashMap)object2).get(set);
            if (arrayList2 == null) {
                arrayList2 = new ArrayList<Set>();
                ((HashMap)object2).put(set, arrayList2);
            }
            Iterator iterator2 = collection.iterator();
            while (iterator2.hasNext()) {
                Set set2 = (Set)hashMap2.get(iterator2.next());
                if (set == set2) continue;
                arrayList2.add(set2);
            }
        }
        try {
            List list = Utilities.topologicalSort(arrayList, object2);
            this.result = list.toArray(new Set[0]);
        }
        catch (TopologicalSortException topologicalSortException) {
            throw new IllegalStateException("Cannot happen");
        }
        return this.result;
    }

    private Vertex constructDualGraph(int n, Object object, HashMap<Object, Vertex> hashMap) {
        Vertex vertex = hashMap.get(object);
        if (vertex != null) {
            return vertex;
        }
        vertex = new Vertex(object, n++);
        hashMap.put(object, vertex);
        Collection<?> collection = this.edges.get(object);
        if (collection != null) {
            Iterator<?> iterator = collection.iterator();
            while (iterator.hasNext()) {
                Vertex vertex2 = this.constructDualGraph(n, iterator.next(), hashMap);
                vertex2.edgesFrom.add(vertex);
            }
        }
        vertex.y = n++;
        this.dualGraph.push(vertex);
        return vertex;
    }

    private void visitDualGraph(Vertex vertex, Collection<Object> collection) {
        if (vertex.visited) {
            return;
        }
        collection.add(vertex.object);
        vertex.visited = true;
        Iterator iterator = vertex.edges();
        while (iterator.hasNext()) {
            Vertex vertex2 = (Vertex)iterator.next();
            this.visitDualGraph(vertex2, collection);
        }
    }

    private static final class Vertex
    implements Comparable<Vertex> {
        public Object object;
        public List<Vertex> edgesFrom = new ArrayList<Vertex>();
        public final int x;
        public int y;
        public boolean sorted;
        public boolean visited;

        public Vertex(Object object, int n) {
            this.x = n;
            this.object = object;
        }

        public Iterator edges() {
            if (!this.sorted) {
                Collections.sort(this.edgesFrom);
                this.sorted = true;
            }
            return this.edgesFrom.iterator();
        }

        @Override
        public int compareTo(Vertex vertex) {
            return vertex.y - this.y;
        }
    }
}

