/*
 * Decompiled with CFR 0.152.
 */
package dguitar.players.sound.midi.demo;

import dguitar.adaptors.song.SongEvent;
import dguitar.adaptors.song.SongMeasureTrack;
import dguitar.adaptors.song.SongMessage;
import dguitar.adaptors.song.SongTrack;
import dguitar.adaptors.song.SongVirtualTrack;
import dguitar.adaptors.song.event.SongNoteOnMessage;
import dguitar.players.sound.PerformanceEvent;
import dguitar.players.sound.PerformanceEventListener;
import dguitar.players.sound.PerformanceNoteEvent;
import dguitar.players.sound.midi.demo.LinePrinter;

public class ExampleEventListener
implements PerformanceEventListener {
    LinePrinter out;

    public ExampleEventListener(LinePrinter out) {
        this.out = out;
    }

    public void onEvent(PerformanceEvent event) {
        if (event instanceof PerformanceNoteEvent) {
            this.onNoteEvent((PerformanceNoteEvent)event);
        }
    }

    public void onNoteEvent(PerformanceNoteEvent event) {
        try {
            int tick = event.getOffset();
            SongEvent songEvent = event.getEvent();
            SongVirtualTrack virtualTrack = songEvent.getVirtualTrack();
            SongMeasureTrack measureTrack = virtualTrack.getMeasureTrack();
            SongTrack track = measureTrack.getTrack();
            SongMessage message = songEvent.getMessage();
            if (message instanceof SongNoteOnMessage) {
                SongNoteOnMessage snom = (SongNoteOnMessage)message;
                this.out.println("Tick " + tick + " track " + track.getIndex() + " string " + virtualTrack.getIndex() + " fret " + snom.getFret() + " message " + message);
            } else {
                this.out.println("Tick " + tick + " track " + track.getIndex() + " string " + virtualTrack.getIndex() + " message " + message);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

