/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.base.plugins;

import java.util.Iterator;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Task;
import org.gradle.api.internal.project.ProjectIdentifier;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.taskfactory.ITaskFactory;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.internal.LanguageSourceSetInternal;
import org.gradle.language.base.internal.SourceTransformTaskConfig;
import org.gradle.language.base.internal.model.ComponentBinaryRules;
import org.gradle.language.base.internal.model.ComponentRules;
import org.gradle.language.base.internal.registry.DefaultLanguageTransformContainer;
import org.gradle.language.base.internal.registry.LanguageTransform;
import org.gradle.language.base.internal.registry.LanguageTransformContainer;
import org.gradle.language.base.plugins.LanguageBasePlugin;
import org.gradle.model.Defaults;
import org.gradle.model.Finalize;
import org.gradle.model.Model;
import org.gradle.model.ModelMap;
import org.gradle.model.Mutate;
import org.gradle.model.Path;
import org.gradle.model.RuleSource;
import org.gradle.model.Validate;
import org.gradle.model.internal.core.InstanceFactory;
import org.gradle.model.internal.core.NodeInitializerRegistry;
import org.gradle.model.internal.core.Service;
import org.gradle.model.internal.manage.instance.ManagedProxyFactory;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.model.internal.manage.schema.extract.FactoryBasedNodeInitializerExtractionStrategy;
import org.gradle.model.internal.manage.schema.extract.NodeInitializerExtractionStrategy;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.model.internal.type.ModelType;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.ComponentSpec;
import org.gradle.platform.base.ComponentSpecContainer;
import org.gradle.platform.base.ComponentType;
import org.gradle.platform.base.ComponentTypeBuilder;
import org.gradle.platform.base.PlatformContainer;
import org.gradle.platform.base.binary.internal.BinarySpecFactory;
import org.gradle.platform.base.component.BaseComponentSpec;
import org.gradle.platform.base.component.internal.ComponentSpecFactory;
import org.gradle.platform.base.internal.BinarySpecInternal;
import org.gradle.platform.base.internal.ComponentSpecInternal;
import org.gradle.platform.base.internal.DefaultPlatformContainer;
import org.gradle.platform.base.internal.DefaultPlatformResolvers;
import org.gradle.platform.base.internal.PlatformResolvers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class ComponentModelBasePlugin
implements Plugin<ProjectInternal> {
    private final ModelRegistry modelRegistry;

    @Inject
    public ComponentModelBasePlugin(ModelRegistry modelRegistry) {
        this.modelRegistry = modelRegistry;
    }

    public void apply(ProjectInternal project) {
        project.getPluginManager().apply(LanguageBasePlugin.class);
        this.modelRegistry.getRoot().applyToAllLinksTransitive(ModelType.of(ComponentSpec.class), ComponentRules.class);
        this.modelRegistry.getRoot().applyToAllLinksTransitive(ModelType.of(ComponentSpec.class), ComponentBinaryRules.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Rules
    extends RuleSource {
        Rules() {
        }

        @Service
        ComponentSpecFactory componentSpecFactory(@Path(value="projectIdentifier") ProjectIdentifier projectIdentifier) {
            return new ComponentSpecFactory("components", projectIdentifier);
        }

        @ComponentType
        void registerBaseComponentSpec(ComponentTypeBuilder<ComponentSpec> builder) {
            builder.defaultImplementation(BaseComponentSpec.class);
            builder.internalView(ComponentSpecInternal.class);
        }

        @Service
        BinarySpecFactory binarySpecFactory(ServiceRegistry serviceRegistry, ITaskFactory taskFactory) {
            return new BinarySpecFactory("binaries", (Instantiator)serviceRegistry.get(Instantiator.class), taskFactory);
        }

        @Model
        void components(ComponentSpecContainer componentSpecs) {
        }

        @Mutate
        void registerNodeInitializerExtractors(NodeInitializerRegistry nodeInitializerRegistry, ComponentSpecFactory componentSpecFactory, BinarySpecFactory binarySpecFactory, ModelSchemaStore schemaStore, ManagedProxyFactory proxyFactory) {
            nodeInitializerRegistry.registerStrategy((NodeInitializerExtractionStrategy)new FactoryBasedNodeInitializerExtractionStrategy((InstanceFactory)componentSpecFactory));
            nodeInitializerRegistry.registerStrategy((NodeInitializerExtractionStrategy)new FactoryBasedNodeInitializerExtractionStrategy((InstanceFactory)binarySpecFactory));
        }

        @Service
        LanguageTransformContainer languageTransforms() {
            return new DefaultLanguageTransformContainer();
        }

        @Mutate
        void closeComponentsForBinaries(ModelMap<Task> tasks, ComponentSpecContainer components) {
        }

        @Finalize
        void createSourceTransformTasks(TaskContainer tasks, ModelMap<BinarySpecInternal> binaries, LanguageTransformContainer languageTransforms, ServiceRegistry serviceRegistry) {
            Iterator i$ = languageTransforms.iterator();
            while (i$.hasNext()) {
                LanguageTransform language = (LanguageTransform)i$.next();
                for (BinarySpecInternal binary : binaries) {
                    if (binary.isLegacyBinary() || !language.applyToBinary(binary)) continue;
                    SourceTransformTaskConfig taskConfig = language.getTransformTask();
                    for (LanguageSourceSet languageSourceSet : binary.getInputs()) {
                        LanguageSourceSetInternal sourceSet = (LanguageSourceSetInternal)languageSourceSet;
                        if (!language.getSourceSetType().isInstance(sourceSet) || !sourceSet.getMayHaveSources()) continue;
                        String taskName = taskConfig.getTaskPrefix() + StringUtils.capitalize((String)binary.getProjectScopedName()) + StringUtils.capitalize((String)sourceSet.getProjectScopedName());
                        Task task = tasks.create(taskName, taskConfig.getTaskType());
                        taskConfig.configureTask(task, binary, sourceSet, serviceRegistry);
                        task.dependsOn(new Object[]{sourceSet});
                        binary.getTasks().add(task);
                    }
                }
            }
        }

        @Model
        PlatformContainer platforms(ServiceRegistry serviceRegistry) {
            Instantiator instantiator = (Instantiator)serviceRegistry.get(Instantiator.class);
            return (PlatformContainer)instantiator.newInstance(DefaultPlatformContainer.class, new Object[]{instantiator});
        }

        @Service
        PlatformResolvers platformResolver(PlatformContainer platforms) {
            return new DefaultPlatformResolvers(platforms);
        }

        @Mutate
        void registerPlatformExtension(ExtensionContainer extensions, PlatformContainer platforms) {
            extensions.add("platforms", (Object)platforms);
        }

        @Defaults
        void collectBinaries(ModelMap<BinarySpec> binaries, ComponentSpecContainer componentSpecs) {
            for (ComponentSpec componentSpec : componentSpecs.values()) {
                for (BinarySpec binary : componentSpec.getBinaries().values()) {
                    binaries.put(((BinarySpecInternal)binary).getProjectScopedName(), (Object)binary);
                }
            }
        }

        @Validate
        void validateComponentSpecRegistrations(ComponentSpecFactory instanceFactory) {
            instanceFactory.validateRegistrations();
        }

        @Validate
        void validateBinarySpecRegistrations(BinarySpecFactory instanceFactory) {
            instanceFactory.validateRegistrations();
        }

        @Defaults
        void addSourceSetsOwnedByBinariesToTheirInputs(ModelMap<BinarySpec> binarySpecs) {
            binarySpecs.withType(BinarySpecInternal.class).afterEach((Action)new Action<BinarySpecInternal>(){

                public void execute(BinarySpecInternal binary) {
                    if (binary.isLegacyBinary()) {
                        return;
                    }
                    binary.getInputs().addAll(binary.getSources().values());
                }
            });
        }
    }
}

